/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.publisher;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class SnapshotEmitterTest {
    @Test
    public void testEmit() throws Exception {
        MockRaftClient mockRaftClient = new MockRaftClient();
        SnapshotEmitter emitter = new SnapshotEmitter.Builder().setBatchSize(2).setRaftClient((RaftClient)mockRaftClient).build();
        emitter.maybeEmit(MetadataImageTest.IMAGE1);
        MockSnapshotWriter writer = mockRaftClient.writers.get(MetadataImageTest.IMAGE1.provenance().snapshotId());
        Assertions.assertNotNull((Object)writer);
        Assertions.assertEquals((long)MetadataImageTest.IMAGE1.highestOffsetAndEpoch().offset(), (long)writer.lastContainedLogOffset());
        Assertions.assertEquals((int)MetadataImageTest.IMAGE1.highestOffsetAndEpoch().epoch(), (int)writer.lastContainedLogEpoch());
        Assertions.assertTrue((boolean)writer.isFrozen());
        Assertions.assertTrue((boolean)writer.isClosed());
        emitter.maybeEmit(MetadataImageTest.IMAGE1);
        Assertions.assertEquals((int)1, (int)mockRaftClient.writers.size());
    }

    static class MockSnapshotWriter
    implements SnapshotWriter<ApiMessageAndVersion> {
        private final OffsetAndEpoch snapshotId;
        private boolean frozen = false;
        private boolean closed = false;
        private final List<List<ApiMessageAndVersion>> batches;

        MockSnapshotWriter(OffsetAndEpoch snapshotId) {
            this.snapshotId = snapshotId;
            this.batches = new ArrayList<List<ApiMessageAndVersion>>();
        }

        public OffsetAndEpoch snapshotId() {
            return this.snapshotId;
        }

        public long lastContainedLogOffset() {
            return this.snapshotId.offset() - 1L;
        }

        public int lastContainedLogEpoch() {
            return this.snapshotId.epoch();
        }

        public boolean isFrozen() {
            return this.frozen;
        }

        public void append(List<ApiMessageAndVersion> records) {
            this.batches.add(records);
        }

        List<List<ApiMessageAndVersion>> batches() {
            ArrayList<List<ApiMessageAndVersion>> results = new ArrayList<List<ApiMessageAndVersion>>();
            this.batches.forEach(batch -> results.add(new ArrayList(batch)));
            return results;
        }

        public void freeze() {
            this.frozen = true;
        }

        public void close() {
            this.closed = true;
        }

        boolean isClosed() {
            return this.closed;
        }
    }

    static class MockRaftClient
    implements RaftClient<ApiMessageAndVersion> {
        TreeMap<OffsetAndEpoch, MockSnapshotWriter> writers = new TreeMap();

        MockRaftClient() {
        }

        public void initialize() {
        }

        public void register(RaftClient.Listener<ApiMessageAndVersion> listener) {
        }

        public void unregister(RaftClient.Listener<ApiMessageAndVersion> listener) {
        }

        public OptionalLong highWatermark() {
            return OptionalLong.empty();
        }

        public LeaderAndEpoch leaderAndEpoch() {
            return LeaderAndEpoch.UNKNOWN;
        }

        public OptionalInt nodeId() {
            return OptionalInt.empty();
        }

        public long scheduleAppend(int epoch, List<ApiMessageAndVersion> records) {
            return 0L;
        }

        public long scheduleAtomicAppend(int epoch, List<ApiMessageAndVersion> records) {
            return 0L;
        }

        public CompletableFuture<Void> shutdown(int timeoutMs) {
            return CompletableFuture.completedFuture(null);
        }

        public void resign(int epoch) {
        }

        public Optional<SnapshotWriter<ApiMessageAndVersion>> createSnapshot(OffsetAndEpoch snapshotId, long lastContainedLogTime) {
            if (this.writers.containsKey(snapshotId)) {
                return Optional.empty();
            }
            MockSnapshotWriter writer = new MockSnapshotWriter(snapshotId);
            this.writers.put(snapshotId, writer);
            return Optional.of(writer);
        }

        public Optional<OffsetAndEpoch> latestSnapshotId() {
            NavigableSet<OffsetAndEpoch> descendingSet = this.writers.descendingKeySet();
            if (descendingSet.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(descendingSet.first());
        }

        public void close() throws Exception {
        }
    }
}

