/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.controller.metrics.ControllerMetricsChanges;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControllerMetricsChangesTest {
    static final Uuid FOO_ID = Uuid.fromString((String)"wXtW6pQbTS2CL6PjdRCqVw");
    static final TopicDelta TOPIC_DELTA1 = new TopicDelta(new TopicImage("foo", FOO_ID, Collections.emptyMap()));
    static final TopicDelta TOPIC_DELTA2;

    @Test
    public void testDelta() {
        Assertions.assertEquals((int)0, (int)ControllerMetricsChanges.delta((boolean)false, (boolean)false));
        Assertions.assertEquals((int)1, (int)ControllerMetricsChanges.delta((boolean)false, (boolean)true));
        Assertions.assertEquals((int)-1, (int)ControllerMetricsChanges.delta((boolean)true, (boolean)false));
        Assertions.assertEquals((int)0, (int)ControllerMetricsChanges.delta((boolean)true, (boolean)true));
    }

    private static BrokerRegistration brokerRegistration(int brokerId, boolean fenced) {
        return new BrokerRegistration(brokerId, 100L, Uuid.fromString((String)"Pxi6QwS2RFuN8VSKjqJZyQ"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), fenced, false);
    }

    @Test
    public void testInitialValues() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        Assertions.assertEquals((int)0, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.activeBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.globalTopicsChange());
        Assertions.assertEquals((int)0, (int)changes.globalPartitionsChange());
        Assertions.assertEquals((int)0, (int)changes.offlinePartitionsChange());
        Assertions.assertEquals((int)0, (int)changes.partitionsWithoutPreferredLeaderChange());
    }

    @Test
    public void testHandleNewUnfencedBroker() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.brokerRegistration(1, false));
        Assertions.assertEquals((int)0, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)1, (int)changes.activeBrokersChange());
    }

    @Test
    public void testHandleNewFencedBroker() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.brokerRegistration(1, true));
        Assertions.assertEquals((int)1, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.activeBrokersChange());
    }

    @Test
    public void testHandleBrokerFencing() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(ControllerMetricsChangesTest.brokerRegistration(1, false), ControllerMetricsChangesTest.brokerRegistration(1, true));
        Assertions.assertEquals((int)1, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)-1, (int)changes.activeBrokersChange());
    }

    @Test
    public void testHandleBrokerUnfencing() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(ControllerMetricsChangesTest.brokerRegistration(1, true), ControllerMetricsChangesTest.brokerRegistration(1, false));
        Assertions.assertEquals((int)-1, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)1, (int)changes.activeBrokersChange());
    }

    @Test
    public void testHandleDeletedTopic() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        HashMap<Integer, PartitionRegistration> partitions = new HashMap<Integer, PartitionRegistration>();
        partitions.put(0, ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL));
        partitions.put(1, ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL));
        partitions.put(2, ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER));
        partitions.put(3, ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER));
        partitions.put(4, ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE));
        TopicImage topicImage = new TopicImage("foo", Uuid.fromString((String)"wXtW6pQbTS2CL6PjdRCqVw"), partitions);
        changes.handleDeletedTopic(topicImage);
        Assertions.assertEquals((int)-1, (int)changes.globalTopicsChange());
        Assertions.assertEquals((int)-5, (int)changes.globalPartitionsChange());
        Assertions.assertEquals((int)-1, (int)changes.offlinePartitionsChange());
        Assertions.assertEquals((int)-3, (int)changes.partitionsWithoutPreferredLeaderChange());
    }

    @Test
    public void testHandleNewTopic() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleTopicChange(null, TOPIC_DELTA1);
        Assertions.assertEquals((int)1, (int)changes.globalTopicsChange());
        Assertions.assertEquals((int)5, (int)changes.globalPartitionsChange());
        Assertions.assertEquals((int)0, (int)changes.offlinePartitionsChange());
        Assertions.assertEquals((int)2, (int)changes.partitionsWithoutPreferredLeaderChange());
    }

    @Test
    public void testTopicChange() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleTopicChange(TOPIC_DELTA2.image(), TOPIC_DELTA2);
        Assertions.assertEquals((int)0, (int)changes.globalTopicsChange());
        Assertions.assertEquals((int)1, (int)changes.globalPartitionsChange());
        Assertions.assertEquals((int)0, (int)changes.offlinePartitionsChange());
        Assertions.assertEquals((int)1, (int)changes.partitionsWithoutPreferredLeaderChange());
    }

    static {
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 0).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 1).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 2).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER).toRecord(FOO_ID, 3).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER).toRecord(FOO_ID, 4).message());
        TOPIC_DELTA2 = new TopicDelta(TOPIC_DELTA1.apply());
        TOPIC_DELTA2.replay(new PartitionChangeRecord().setPartitionId(1).setTopicId(FOO_ID).setLeader(1));
        TOPIC_DELTA2.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 5).message());
    }
}

