/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.errors;

import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.controller.errors.ControllerExceptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ControllerExceptionsTest {
    @Test
    public void testTimeoutExceptionIsTimeoutException() {
        Assertions.assertTrue((boolean)ControllerExceptions.isTimeoutException((Throwable)new TimeoutException()));
    }

    @Test
    public void testWrappedTimeoutExceptionIsTimeoutException() {
        Assertions.assertTrue((boolean)ControllerExceptions.isTimeoutException((Throwable)new ExecutionException("execution exception", (Throwable)new TimeoutException())));
    }

    @Test
    public void testRuntimeExceptionIsNotTimeoutException() {
        Assertions.assertFalse((boolean)ControllerExceptions.isTimeoutException((Throwable)new RuntimeException()));
    }

    @Test
    public void testWrappedRuntimeExceptionIsNotTimeoutException() {
        Assertions.assertFalse((boolean)ControllerExceptions.isTimeoutException((Throwable)new ExecutionException(new RuntimeException())));
    }

    @Test
    public void testTopicExistsExceptionIsNotTimeoutException() {
        Assertions.assertFalse((boolean)ControllerExceptions.isTimeoutException((Throwable)new TopicExistsException("Topic exists.")));
    }

    @Test
    public void testExecutionExceptionWithNullCauseIsNotTimeoutException() {
        Assertions.assertFalse((boolean)ControllerExceptions.isTimeoutException((Throwable)new ExecutionException(null)));
    }
}

