/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.TopicAssignment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicAssignmentTest {
    @Test
    public void testTopicAssignmentReplicas() {
        List<Integer> replicasP0 = Arrays.asList(0, 1, 2);
        List<Integer> replicasP1 = Arrays.asList(1, 2, 0);
        List<PartitionAssignment> partitionAssignments = Arrays.asList(new PartitionAssignment(replicasP0), new PartitionAssignment(replicasP1));
        Assertions.assertEquals(partitionAssignments, (Object)new TopicAssignment(partitionAssignments).assignments());
    }

    @Test
    public void testConsistentEqualsAndHashCode() {
        List<TopicAssignment> topicAssignments = Arrays.asList(new TopicAssignment(Arrays.asList(new PartitionAssignment(Arrays.asList(0, 1, 2)))), new TopicAssignment(Arrays.asList(new PartitionAssignment(Arrays.asList(1, 2, 0)))));
        for (int i = 0; i < topicAssignments.size(); ++i) {
            for (int j = 0; j < topicAssignments.size(); ++j) {
                if (i == j) {
                    Assertions.assertEquals((Object)topicAssignments.get(i), (Object)topicAssignments.get(j));
                    Assertions.assertEquals((Object)topicAssignments.get(i), (Object)new TopicAssignment(topicAssignments.get(i).assignments()));
                    Assertions.assertEquals((int)topicAssignments.get(i).hashCode(), (int)topicAssignments.get(j).hashCode());
                    continue;
                }
                Assertions.assertNotEquals((Object)topicAssignments.get(i), (Object)topicAssignments.get(j));
                Assertions.assertNotEquals((int)topicAssignments.get(i).hashCode(), (int)topicAssignments.get(j).hashCode());
            }
        }
    }

    @Test
    public void testToString() {
        List<Integer> replicas = Arrays.asList(0, 1, 2);
        List<PartitionAssignment> partitionAssignments = Arrays.asList(new PartitionAssignment(replicas));
        TopicAssignment topicAssignment = new TopicAssignment(partitionAssignments);
        Assertions.assertEquals((Object)"TopicAssignment(assignments=[PartitionAssignment(replicas=[0, 1, 2])])", (Object)topicAssignment.toString());
    }
}

