/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuorumControllerMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try {
            try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time);){
                ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller", new HashSet<String>(Arrays.asList("kafka.controller:type=ControllerEventManager,name=EventQueueTimeMs", "kafka.controller:type=ControllerEventManager,name=EventQueueProcessingTimeMs", "kafka.controller:type=KafkaController,name=ActiveControllerCount", "kafka.controller:type=KafkaController,name=LastCommittedRecordOffset", "kafka.controller:type=KafkaController,name=LastAppliedRecordLagMs", "kafka.controller:type=KafkaController,name=LastAppliedRecordOffset", "kafka.controller:type=KafkaController,name=LastAppliedRecordTimestamp", "kafka.controller:type=KafkaController,name=LastAppliedRecordOffset")));
            }
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller", Collections.emptySet());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventQueueTime() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time);){
            metrics.updateEventQueueTime(1000L);
            QuorumControllerMetricsTest.assertMetricHistogram(registry, QuorumControllerMetricsTest.metricName("ControllerEventManager", "EventQueueTimeMs"), 1L, 1000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventQueueProcessingTime() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time);){
            metrics.updateEventQueueProcessingTime(1000L);
            QuorumControllerMetricsTest.assertMetricHistogram(registry, QuorumControllerMetricsTest.metricName("ControllerEventManager", "EventQueueProcessingTimeMs"), 1L, 1000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastAppliedRecordMetrics() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        time.sleep(1000L);
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time);){
            metrics.setLastAppliedRecordOffset(100L);
            metrics.setLastAppliedRecordTimestamp(500L);
            metrics.setLastCommittedRecordOffset(50L);
            Gauge lastAppliedRecordOffset = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordOffset"));
            Assertions.assertEquals((long)100L, (Long)((Long)lastAppliedRecordOffset.value()));
            Gauge lastAppliedRecordTimestamp = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordTimestamp"));
            Assertions.assertEquals((long)500L, (Long)((Long)lastAppliedRecordTimestamp.value()));
            Gauge lastAppliedRecordLagMs = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordLagMs"));
            Assertions.assertEquals((long)(time.milliseconds() - 500L), (Long)((Long)lastAppliedRecordLagMs.value()));
            Gauge lastCommittedRecordOffset = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastCommittedRecordOffset"));
            Assertions.assertEquals((long)50L, (Long)((Long)lastCommittedRecordOffset.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    private static void assertMetricHistogram(MetricsRegistry registry, MetricName metricName, long count, double sum) {
        Histogram histogram = (Histogram)registry.allMetrics().get(metricName);
        Assertions.assertEquals((long)count, (long)histogram.count());
        Assertions.assertEquals((double)sum, (double)histogram.sum(), (double)0.1);
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s", type, name);
        return new MetricName("kafka.controller", type, name, null, mBeanName);
    }
}

