/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionReassignmentReplicasTest {
    @Test
    public void testNoneAddedOrRemoved() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(3, 2, 1)), new PartitionAssignment(Arrays.asList(3, 2, 1)));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)replicas.replicas());
    }

    @Test
    public void testAdditions() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(3, 2, 1)), new PartitionAssignment(Arrays.asList(3, 6, 2, 1, 5)));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(5, 6), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 6, 2, 1, 5), (Object)replicas.replicas());
    }

    @Test
    public void testRemovals() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(3, 2, 1, 0)), new PartitionAssignment(Arrays.asList(3, 1)));
        Assertions.assertEquals(Arrays.asList(0, 2), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 1, 0, 2), (Object)replicas.replicas());
    }

    @Test
    public void testAdditionsAndRemovals() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(3, 2, 1, 0)), new PartitionAssignment(Arrays.asList(7, 3, 1, 9)));
        Assertions.assertEquals(Arrays.asList(0, 2), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(7, 9), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(7, 3, 1, 9, 0, 2), (Object)replicas.replicas());
    }

    @Test
    public void testRearrangement() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(3, 2, 1, 0)), new PartitionAssignment(Arrays.asList(0, 1, 3, 2)));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(0, 1, 3, 2), (Object)replicas.replicas());
    }

    @Test
    public void testDoesNotCompleteReassignment() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2)), new PartitionAssignment(Arrays.asList(3, 4, 5)));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2, 3, 4));
        Assertions.assertFalse((boolean)reassignmentOptional.isPresent());
    }

    @Test
    public void testDoesNotCompleteReassignmentIfNoneOngoing() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Collections.emptyList(), Collections.emptyList(), Arrays.asList(0, 1, 2));
        Assertions.assertFalse((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2));
        Assertions.assertFalse((boolean)reassignmentOptional.isPresent());
    }

    @Test
    public void testDoesCompleteReassignmentAllNewReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2)), new PartitionAssignment(Arrays.asList(3, 4, 5)));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2, 3, 4, 5));
        Assertions.assertTrue((boolean)reassignmentOptional.isPresent());
        PartitionReassignmentReplicas.CompletedReassignment completedReassignment = (PartitionReassignmentReplicas.CompletedReassignment)reassignmentOptional.get();
        Assertions.assertEquals(Arrays.asList(3, 4, 5), (Object)completedReassignment.isr);
        Assertions.assertEquals(Arrays.asList(3, 4, 5), (Object)completedReassignment.replicas);
    }

    @Test
    public void testDoesCompleteReassignmentSomeNewReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2)), new PartitionAssignment(Arrays.asList(0, 1, 3)));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2, 3));
        Assertions.assertTrue((boolean)reassignmentOptional.isPresent());
        PartitionReassignmentReplicas.CompletedReassignment completedReassignment = (PartitionReassignmentReplicas.CompletedReassignment)reassignmentOptional.get();
        Assertions.assertEquals(Arrays.asList(0, 1, 3), (Object)completedReassignment.isr);
        Assertions.assertEquals(Arrays.asList(0, 1, 3), (Object)completedReassignment.replicas);
    }

    @Test
    public void testIsReassignmentInProgress() {
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration(new int[]{0, 1, 3, 2}, new int[]{0, 1, 3, 2}, new int[]{2}, new int[]{3}, 0, LeaderRecoveryState.RECOVERED, 0, 0)));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration(new int[]{0, 1, 3, 2}, new int[]{0, 1, 3, 2}, new int[]{2}, Replicas.NONE, 0, LeaderRecoveryState.RECOVERED, 0, 0)));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration(new int[]{0, 1, 2, 3}, new int[]{0, 1, 2, 3}, Replicas.NONE, new int[]{3}, 0, LeaderRecoveryState.RECOVERED, 0, 0)));
        Assertions.assertFalse((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration(new int[]{0, 1, 2}, new int[]{0, 1, 2}, Replicas.NONE, Replicas.NONE, 0, LeaderRecoveryState.RECOVERED, 0, 0)));
    }

    @Test
    public void testOriginalReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2)), new PartitionAssignment(Arrays.asList(0, 1, 3)));
        Assertions.assertEquals(Arrays.asList(0, 1, 2), (Object)replicas.originalReplicas());
    }
}

