/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.AclControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.timeline.SnapshotRegistry;

public class MockAclControlManager
extends AclControlManager {
    public MockAclControlManager(LogContext logContext, Optional<ClusterMetadataAuthorizer> authorizer) {
        super(new SnapshotRegistry(logContext), authorizer);
    }

    public List<AclCreateResult> createAndReplayAcls(List<AclBinding> acls) {
        ControllerResult createResults = this.createAcls(acls);
        createResults.records().forEach(record -> this.replay((AccessControlEntryRecord)record.message(), Optional.empty()));
        return (List)createResults.response();
    }

    public List<AclDeleteResult> deleteAndReplayAcls(List<AclBindingFilter> filters) {
        ControllerResult deleteResults = this.deleteAcls(filters);
        deleteResults.records().forEach(record -> this.replay((RemoveAccessControlEntryRecord)record.message(), Optional.empty()));
        return (List)deleteResults.response();
    }
}

