/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.image.writer.RaftSnapshotWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class RaftSnapshotWriterTest {
    @Test
    public void testFreezeAndClose() {
        MockSnapshotWriter snapshotWriter = new MockSnapshotWriter();
        RaftSnapshotWriter writer = new RaftSnapshotWriter((SnapshotWriter)snapshotWriter, 2);
        writer.write(RecordTestUtils.testRecord(0));
        writer.write(RecordTestUtils.testRecord(1));
        writer.write(RecordTestUtils.testRecord(2));
        writer.close(true);
        Assertions.assertTrue((boolean)snapshotWriter.frozen);
        Assertions.assertTrue((boolean)snapshotWriter.closed);
        Assertions.assertEquals(Arrays.asList(Arrays.asList(RecordTestUtils.testRecord(0), RecordTestUtils.testRecord(1)), Arrays.asList(RecordTestUtils.testRecord(2))), snapshotWriter.batches);
    }

    @Test
    public void testCloseWithoutFreeze() {
        MockSnapshotWriter snapshotWriter = new MockSnapshotWriter();
        RaftSnapshotWriter writer = new RaftSnapshotWriter((SnapshotWriter)snapshotWriter, 2);
        writer.write(RecordTestUtils.testRecord(0));
        writer.close();
        Assertions.assertFalse((boolean)snapshotWriter.frozen);
        Assertions.assertTrue((boolean)snapshotWriter.closed);
        Assertions.assertEquals(Collections.emptyList(), snapshotWriter.batches);
    }

    static class MockSnapshotWriter
    implements SnapshotWriter<ApiMessageAndVersion> {
        boolean frozen = false;
        boolean closed = false;
        List<List<ApiMessageAndVersion>> batches = new ArrayList<List<ApiMessageAndVersion>>();

        MockSnapshotWriter() {
        }

        public OffsetAndEpoch snapshotId() {
            return new OffsetAndEpoch(100L, 10);
        }

        public long lastContainedLogOffset() {
            return this.snapshotId().offset();
        }

        public int lastContainedLogEpoch() {
            return this.snapshotId().epoch();
        }

        public boolean isFrozen() {
            return this.frozen;
        }

        public void append(List<ApiMessageAndVersion> batch) {
            this.batches.add(batch);
        }

        public void freeze() {
            this.frozen = true;
        }

        public void close() {
            this.closed = true;
        }
    }
}

