/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.image.ClientQuotaImage;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClientQuotasImageTest {
    static final ClientQuotasImage IMAGE1;
    static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final ClientQuotasDelta DELTA1;
    static final ClientQuotasImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        this.testToImageAndBack(ClientQuotasImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2);
    }

    private void testToImageAndBack(ClientQuotasImage image) throws Throwable {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        ClientQuotasDelta delta = new ClientQuotasDelta(ClientQuotasImage.EMPTY);
        RecordTestUtils.replayAll(delta, writer.records());
        ClientQuotasImage nextImage = delta.apply();
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    static {
        HashMap<ClientQuotaEntity, ClientQuotaImage> entities1 = new HashMap<ClientQuotaEntity, ClientQuotaImage>();
        HashMap<String, String> fooUser = new HashMap<String, String>();
        fooUser.put("user", "foo");
        HashMap<String, Double> fooUserQuotas = new HashMap<String, Double>();
        fooUserQuotas.put("producer_byte_rate", 123.0);
        entities1.put(new ClientQuotaEntity(fooUser), new ClientQuotaImage(fooUserQuotas));
        HashMap<String, String> barUserAndIp = new HashMap<String, String>();
        barUserAndIp.put("user", "bar");
        barUserAndIp.put("ip", "127.0.0.1");
        HashMap<String, Double> barUserAndIpQuotas = new HashMap<String, Double>();
        barUserAndIpQuotas.put("consumer_byte_rate", 456.0);
        entities1.put(new ClientQuotaEntity(barUserAndIp), new ClientQuotaImage(barUserAndIpQuotas));
        IMAGE1 = new ClientQuotasImage(entities1);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("bar"), new ClientQuotaRecord.EntityData().setEntityType("ip").setEntityName("127.0.0.1"))).setKey("consumer_byte_rate").setRemove(true), MetadataRecordType.CLIENT_QUOTA_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("foo"))).setKey("consumer_byte_rate").setValue(999.0), MetadataRecordType.CLIENT_QUOTA_RECORD.highestSupportedVersion()));
        DELTA1 = new ClientQuotasDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<ClientQuotaEntity, ClientQuotaImage> entities2 = new HashMap<ClientQuotaEntity, ClientQuotaImage>();
        HashMap<String, Double> fooUserQuotas2 = new HashMap<String, Double>();
        fooUserQuotas2.put("producer_byte_rate", 123.0);
        fooUserQuotas2.put("consumer_byte_rate", 999.0);
        entities2.put(new ClientQuotaEntity(fooUser), new ClientQuotaImage(fooUserQuotas2));
        IMAGE2 = new ClientQuotasImage(entities2);
    }
}

