/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.SnapshotGenerator;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.MockRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class SnapshotGeneratorTest {
    private static final List<List<ApiMessageAndVersion>> BATCHES = Arrays.asList(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(Uuid.randomUuid()), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("bar").setTopicId(Uuid.randomUuid()), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("baz").setTopicId(Uuid.randomUuid()), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceName("foo").setResourceType(ConfigResource.Type.TOPIC.id()).setName("retention.ms").setValue("10000000"), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceName("foo").setResourceType(ConfigResource.Type.TOPIC.id()).setName("max.message.bytes").setValue("100000000"), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceName("bar").setResourceType(ConfigResource.Type.TOPIC.id()).setName("retention.ms").setValue("5000000"), 0)));

    @Test
    public void testGenerateBatches() throws Exception {
        SnapshotWriter<ApiMessageAndVersion> writer = this.createSnapshotWriter(123L, 0L);
        List<SnapshotGenerator.Section> sections = Arrays.asList(new SnapshotGenerator.Section("replication", Arrays.asList(BATCHES.get(0), BATCHES.get(1), BATCHES.get(2)).iterator()), new SnapshotGenerator.Section("configuration", Arrays.asList(BATCHES.get(3), BATCHES.get(4)).iterator()));
        SnapshotGenerator generator = new SnapshotGenerator(new LogContext(), writer, 2, sections);
        Assertions.assertFalse((boolean)writer.isFrozen());
        Assertions.assertEquals((long)123L, (long)generator.lastContainedLogOffset());
        Assertions.assertEquals(writer, (Object)generator.writer());
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)generator.generateBatches());
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)generator.generateBatches());
        Assertions.assertFalse((boolean)writer.isFrozen());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)generator.generateBatches());
        Assertions.assertTrue((boolean)writer.isFrozen());
    }

    private SnapshotWriter<ApiMessageAndVersion> createSnapshotWriter(long committedOffset, long lastContainedLogTime) {
        return (SnapshotWriter)RecordsSnapshotWriter.createWithHeader(() -> this.createNewSnapshot(new OffsetAndEpoch(committedOffset + 1L, 1)), (int)0x800000, (MemoryPool)MemoryPool.NONE, (Time)new MockTime(), (long)lastContainedLogTime, (CompressionType)CompressionType.NONE, (RecordSerde)new MetadataRecordSerde()).get();
    }

    private Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        return Optional.of(new MockRawSnapshotWriter(snapshotId, buffer -> {}));
    }
}

