/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ClientQuotaControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClientQuotaControlManagerTest {
    @Test
    public void testInvalidEntityTypes() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ClientQuotaControlManager manager = new ClientQuotaControlManager(snapshotRegistry);
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("foo", "bar"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity(null, "null"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("user", "user-1", "foo", "bar"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("foo", "bar", "ip", "1.2.3.4"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("user", "user-1", "ip", "1.2.3.4"));
        this.assertInvalidEntity(manager, ClientQuotaControlManagerTest.entity("client-id", "user-1", "ip", "1.2.3.4"));
        this.assertInvalidEntity(manager, new ClientQuotaEntity(Collections.emptyMap()));
    }

    private void assertInvalidEntity(ClientQuotaControlManager manager, ClientQuotaEntity entity) {
        this.assertInvalidQuota(manager, entity, ClientQuotaControlManagerTest.quotas("producer_byte_rate", 10000.0));
    }

    @Test
    public void testInvalidQuotaKeys() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ClientQuotaControlManager manager = new ClientQuotaControlManager(snapshotRegistry);
        ClientQuotaEntity entity = ClientQuotaControlManagerTest.entity("user", "user-1");
        this.assertInvalidQuota(manager, entity, ClientQuotaControlManagerTest.quotas("not.a.quota.key", 0.0, "request_percentage", 99.9));
        this.assertInvalidQuota(manager, entity, ClientQuotaControlManagerTest.quotas("request_percentage", 99.9, "not.a.quota.key", 0.0));
        this.assertInvalidQuota(manager, entity, ClientQuotaControlManagerTest.quotas(null, 99.9));
    }

    private void assertInvalidQuota(ClientQuotaControlManager manager, ClientQuotaEntity entity, Map<String, Double> quota) {
        ArrayList alters = new ArrayList();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(entity, quota, alters::add);
        ControllerResult result = manager.alterClientQuotas(alters);
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)((ApiError)((Map)result.response()).get(entity)).error());
        Assertions.assertEquals((int)0, (int)result.records().size());
    }

    @Test
    public void testAlterAndRemove() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ClientQuotaControlManager manager = new ClientQuotaControlManager(snapshotRegistry);
        ClientQuotaEntity userEntity = ClientQuotaControlManagerTest.userEntity("user-1");
        ArrayList<ClientQuotaAlteration> alters = new ArrayList<ClientQuotaAlteration>();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("producer_byte_rate", 10000.0), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertEquals((int)1, (int)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).size());
        Assertions.assertEquals((double)10000.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"producer_byte_rate")), (double)1.0E-6);
        alters.clear();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("producer_byte_rate", 10001.0, "consumer_byte_rate", 20000.0), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertEquals((int)2, (int)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).size());
        Assertions.assertEquals((double)10001.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"producer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)20000.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"consumer_byte_rate")), (double)1.0E-6);
        alters.clear();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("producer_byte_rate", null), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertEquals((int)1, (int)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).size());
        Assertions.assertEquals((double)20000.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"consumer_byte_rate")), (double)1.0E-6);
        alters.clear();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("request_percentage", null), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertEquals((int)1, (int)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).size());
        Assertions.assertEquals((double)20000.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"consumer_byte_rate")), (double)1.0E-6);
        alters.clear();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("consumer_byte_rate", null), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertFalse((boolean)manager.clientQuotaData.containsKey((Object)userEntity));
        alters.clear();
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, ClientQuotaControlManagerTest.quotas("consumer_byte_rate", null), alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertFalse((boolean)manager.clientQuotaData.containsKey((Object)userEntity));
        alters.clear();
        HashMap<String, Double> quotas = new HashMap<String, Double>(4);
        quotas.put("request_percentage", 99.0);
        quotas.put("controller_mutation_rate", null);
        quotas.put("producer_byte_rate", 10002.0);
        quotas.put("consumer_byte_rate", 20001.0);
        ClientQuotaControlManagerTest.entityQuotaToAlterations(userEntity, quotas, alters::add);
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        Assertions.assertEquals((int)3, (int)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).size());
        Assertions.assertEquals((double)20001.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"consumer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)10002.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"producer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)99.0, (double)((Double)((TimelineHashMap)manager.clientQuotaData.get((Object)userEntity)).get((Object)"request_percentage")), (double)1.0E-6);
    }

    @Test
    public void testEntityTypes() throws Exception {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ClientQuotaControlManager manager = new ClientQuotaControlManager(snapshotRegistry);
        HashMap<ClientQuotaEntity, Map> quotasToTest = new HashMap<ClientQuotaEntity, Map>();
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity("user-1", "client-id-1"), ClientQuotaControlManagerTest.quotas("request_percentage", 50.5));
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity("user-2", "client-id-1"), ClientQuotaControlManagerTest.quotas("request_percentage", 51.51));
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity("user-3", "client-id-2"), ClientQuotaControlManagerTest.quotas("request_percentage", 52.52));
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity(null, "client-id-1"), ClientQuotaControlManagerTest.quotas("request_percentage", 53.53));
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity("user-1", null), ClientQuotaControlManagerTest.quotas("request_percentage", 54.54));
        quotasToTest.put(ClientQuotaControlManagerTest.userClientEntity("user-3", null), ClientQuotaControlManagerTest.quotas("request_percentage", 55.55));
        quotasToTest.put(ClientQuotaControlManagerTest.userEntity("user-1"), ClientQuotaControlManagerTest.quotas("request_percentage", 56.56));
        quotasToTest.put(ClientQuotaControlManagerTest.userEntity("user-2"), ClientQuotaControlManagerTest.quotas("request_percentage", 57.57));
        quotasToTest.put(ClientQuotaControlManagerTest.userEntity("user-3"), ClientQuotaControlManagerTest.quotas("request_percentage", 58.58));
        quotasToTest.put(ClientQuotaControlManagerTest.userEntity(null), ClientQuotaControlManagerTest.quotas("request_percentage", 59.59));
        quotasToTest.put(ClientQuotaControlManagerTest.clientEntity("client-id-2"), ClientQuotaControlManagerTest.quotas("request_percentage", 60.6));
        ArrayList<ClientQuotaAlteration> alters = new ArrayList<ClientQuotaAlteration>();
        quotasToTest.forEach((entity, quota) -> ClientQuotaControlManagerTest.entityQuotaToAlterations(entity, quota, alters::add));
        ClientQuotaControlManagerTest.alterQuotas(alters, manager);
        RecordTestUtils.assertBatchIteratorContains(Arrays.asList(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-1"), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName("client-id-1"))).setKey("request_percentage").setValue(50.5).setRemove(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-2"), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName("client-id-1"))).setKey("request_percentage").setValue(51.51).setRemove(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-3"), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName("client-id-2"))).setKey("request_percentage").setValue(52.52).setRemove(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName(null), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName("client-id-1"))).setKey("request_percentage").setValue(53.53).setRemove(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-1"), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName(null))).setKey("request_percentage").setValue(54.54).setRemove(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-3"), new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName(null))).setKey("request_percentage").setValue(55.55).setRemove(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-1"))).setKey("request_percentage").setValue(56.56).setRemove(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-2"))).setKey("request_percentage").setValue(57.57).setRemove(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user-3"))).setKey("request_percentage").setValue(58.58).setRemove(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName(null))).setKey("request_percentage").setValue(59.59).setRemove(false), 0)), Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("client-id").setEntityName("client-id-2"))).setKey("request_percentage").setValue(60.6).setRemove(false), 0))), (Iterator<List<ApiMessageAndVersion>>)manager.iterator(Long.MAX_VALUE));
    }

    static void entityQuotaToAlterations(ClientQuotaEntity entity, Map<String, Double> quota, Consumer<ClientQuotaAlteration> acceptor) {
        Collection ops = quota.entrySet().stream().map(quotaEntry -> new ClientQuotaAlteration.Op((String)quotaEntry.getKey(), (Double)quotaEntry.getValue())).collect(Collectors.toList());
        acceptor.accept(new ClientQuotaAlteration(entity, ops));
    }

    static void alterQuotas(List<ClientQuotaAlteration> alterations, ClientQuotaControlManager manager) {
        ControllerResult result = manager.alterClientQuotas(alterations);
        Assertions.assertTrue((boolean)((Map)result.response()).values().stream().allMatch(ApiError::isSuccess));
        result.records().forEach(apiMessageAndVersion -> manager.replay((ClientQuotaRecord)apiMessageAndVersion.message()));
    }

    static Map<String, Double> quotas(String key, Double value) {
        return Collections.singletonMap(key, value);
    }

    static Map<String, Double> quotas(String key1, Double value1, String key2, Double value2) {
        HashMap<String, Double> quotas = new HashMap<String, Double>(2);
        quotas.put(key1, value1);
        quotas.put(key2, value2);
        return quotas;
    }

    static ClientQuotaEntity entity(String type, String name) {
        return new ClientQuotaEntity(Collections.singletonMap(type, name));
    }

    static ClientQuotaEntity entity(String type1, String name1, String type2, String name2) {
        HashMap<String, String> entries = new HashMap<String, String>(2);
        entries.put(type1, name1);
        entries.put(type2, name2);
        return new ClientQuotaEntity(entries);
    }

    static ClientQuotaEntity userEntity(String user) {
        return new ClientQuotaEntity(Collections.singletonMap("user", user));
    }

    static ClientQuotaEntity clientEntity(String clientId) {
        return new ClientQuotaEntity(Collections.singletonMap("client-id", clientId));
    }

    static ClientQuotaEntity userClientEntity(String user, String clientId) {
        HashMap<String, String> entries = new HashMap<String, String>(2);
        entries.put("user", user);
        entries.put("client-id", clientId);
        return new ClientQuotaEntity(entries);
    }
}

