/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metalog.LocalLogManagerTestEnv;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.test.TestUtils;

public class QuorumControllerTestEnv
implements AutoCloseable {
    private final List<QuorumController> controllers;
    private final LocalLogManagerTestEnv logEnv;
    private final MockFaultHandler fatalFaultHandler = new MockFaultHandler("fatalFaultHandler");
    private final MockFaultHandler metadataFaultHandler = new MockFaultHandler("metadataFaultHandler");

    public QuorumControllerTestEnv(LocalLogManagerTestEnv logEnv, Consumer<QuorumController.Builder> builderConsumer) throws Exception {
        this(logEnv, builderConsumer, OptionalLong.empty(), OptionalLong.empty(), BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.latest(), (String)"test-provided version"));
    }

    public QuorumControllerTestEnv(LocalLogManagerTestEnv logEnv, Consumer<QuorumController.Builder> builderConsumer, OptionalLong sessionTimeoutMillis, OptionalLong leaderImbalanceCheckIntervalNs, MetadataVersion metadataVersion) throws Exception {
        this(logEnv, builderConsumer, sessionTimeoutMillis, leaderImbalanceCheckIntervalNs, BootstrapMetadata.fromVersion((MetadataVersion)metadataVersion, (String)"test-provided version"));
    }

    public QuorumControllerTestEnv(LocalLogManagerTestEnv logEnv, Consumer<QuorumController.Builder> builderConsumer, OptionalLong sessionTimeoutMillis, OptionalLong leaderImbalanceCheckIntervalNs, BootstrapMetadata bootstrapMetadata) throws Exception {
        this.logEnv = logEnv;
        int numControllers = logEnv.logManagers().size();
        this.controllers = new ArrayList<QuorumController>(numControllers);
        try {
            ApiVersions apiVersions = new ApiVersions();
            List nodeIds = IntStream.range(0, numControllers).boxed().collect(Collectors.toList());
            for (int i = 0; i < numControllers; ++i) {
                QuorumController.Builder builder = new QuorumController.Builder(i, logEnv.clusterId());
                builder.setRaftClient((RaftClient)logEnv.logManagers().get(i));
                builder.setBootstrapMetadata(bootstrapMetadata);
                builder.setLeaderImbalanceCheckIntervalNs(leaderImbalanceCheckIntervalNs);
                builder.setQuorumFeatures(new QuorumFeatures(i, apiVersions, QuorumFeatures.defaultFeatureMap(), nodeIds));
                sessionTimeoutMillis.ifPresent(timeout -> builder.setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)));
                builder.setFatalFaultHandler((FaultHandler)this.fatalFaultHandler);
                builder.setMetadataFaultHandler((FaultHandler)this.metadataFaultHandler);
                builderConsumer.accept(builder);
                this.controllers.add(builder.build());
            }
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    QuorumController activeController() throws InterruptedException {
        AtomicReference<Object> value = new AtomicReference<Object>(null);
        TestUtils.retryOnExceptionWithTimeout((long)20000L, (long)3L, () -> {
            LeaderAndEpoch leader = this.logEnv.leaderAndEpoch();
            for (QuorumController controller : this.controllers) {
                if (!OptionalInt.of(controller.nodeId()).equals(leader.leaderId()) || controller.curClaimEpoch() != leader.epoch()) continue;
                value.set(controller);
                break;
            }
            if (value.get() == null) {
                throw new RuntimeException(String.format("Expected to see %s as leader", leader));
            }
        });
        return value.get();
    }

    public List<QuorumController> controllers() {
        return this.controllers;
    }

    public MockFaultHandler fatalFaultHandler() {
        return this.fatalFaultHandler;
    }

    public MockFaultHandler metadataFaultHandler() {
        return this.metadataFaultHandler;
    }

    @Override
    public void close() throws InterruptedException {
        for (QuorumController controller : this.controllers) {
            controller.beginShutdown();
        }
        for (QuorumController controller : this.controllers) {
            controller.close();
        }
        this.fatalFaultHandler.maybeRethrowFirstException();
        this.metadataFaultHandler.maybeRethrowFirstException();
    }
}

