/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class KafkaConfigSchemaTest {
    public static final Map<ConfigResource.Type, ConfigDef> CONFIGS = new HashMap<ConfigResource.Type, ConfigDef>();

    @Test
    public void testIsSplittable() {
        KafkaConfigSchema schema = new KafkaConfigSchema(CONFIGS);
        Assertions.assertTrue((boolean)schema.isSplittable(ConfigResource.Type.BROKER, "foo.bar"));
        Assertions.assertFalse((boolean)schema.isSplittable(ConfigResource.Type.BROKER, "baz"));
        Assertions.assertFalse((boolean)schema.isSplittable(ConfigResource.Type.BROKER, "foo.baz.quux"));
        Assertions.assertFalse((boolean)schema.isSplittable(ConfigResource.Type.TOPIC, "baz"));
        Assertions.assertTrue((boolean)schema.isSplittable(ConfigResource.Type.TOPIC, "abc"));
    }

    @Test
    public void testGetConfigValueDefault() {
        KafkaConfigSchema schema = new KafkaConfigSchema(CONFIGS);
        Assertions.assertEquals((Object)"1", (Object)schema.getDefault(ConfigResource.Type.BROKER, "foo.bar"));
        Assertions.assertEquals(null, (Object)schema.getDefault(ConfigResource.Type.BROKER, "foo.baz.quux"));
        Assertions.assertEquals(null, (Object)schema.getDefault(ConfigResource.Type.TOPIC, "abc"));
        Assertions.assertEquals((Object)"true", (Object)schema.getDefault(ConfigResource.Type.TOPIC, "ghi"));
    }

    @Test
    public void testIsSensitive() {
        KafkaConfigSchema schema = new KafkaConfigSchema(CONFIGS);
        Assertions.assertFalse((boolean)schema.isSensitive(ConfigResource.Type.BROKER, "foo.bar"));
        Assertions.assertTrue((boolean)schema.isSensitive(ConfigResource.Type.BROKER, "quuux"));
        Assertions.assertTrue((boolean)schema.isSensitive(ConfigResource.Type.BROKER, "unknown.config.key"));
        Assertions.assertFalse((boolean)schema.isSensitive(ConfigResource.Type.TOPIC, "abc"));
    }

    static {
        CONFIGS.put(ConfigResource.Type.BROKER, new ConfigDef().define("foo.bar", ConfigDef.Type.LIST, (Object)"1", ConfigDef.Importance.HIGH, "foo bar").define("baz", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "baz").define("quux", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "quux").define("quuux", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "quuux"));
        CONFIGS.put(ConfigResource.Type.TOPIC, new ConfigDef().define("abc", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "abc").define("def", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "def").define("ghi", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.HIGH, "ghi").define("xyz", ConfigDef.Type.PASSWORD, (Object)"thedefault", ConfigDef.Importance.HIGH, "xyz"));
    }
}

