/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.Snapshot;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class SnapshotRegistryTest {
    @Test
    public void testEmptyRegistry() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        Assertions.assertThrows(RuntimeException.class, () -> registry.getSnapshot(0L));
        SnapshotRegistryTest.assertIteratorContains(registry.iterator(), new Snapshot[0]);
    }

    private static void assertIteratorContains(Iterator<Snapshot> iter, Snapshot ... snapshots) {
        ArrayList<Snapshot> expected = new ArrayList<Snapshot>();
        for (Snapshot snapshot : snapshots) {
            expected.add(snapshot);
        }
        ArrayList<Snapshot> actual = new ArrayList<Snapshot>();
        while (iter.hasNext()) {
            Snapshot snapshot = iter.next();
            actual.add(snapshot);
        }
        Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testCreateSnapshots() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        Snapshot snapshot123 = registry.getOrCreateSnapshot(123L);
        Assertions.assertEquals((Object)snapshot123, (Object)registry.getSnapshot(123L));
        Assertions.assertThrows(RuntimeException.class, () -> registry.getSnapshot(456L));
        SnapshotRegistryTest.assertIteratorContains(registry.iterator(), snapshot123);
        Assertions.assertEquals((Object)"Can't create a new snapshot at epoch 1 because there is already a snapshot with epoch 123", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> registry.getOrCreateSnapshot(1L))).getMessage());
        Snapshot snapshot456 = registry.getOrCreateSnapshot(456L);
        SnapshotRegistryTest.assertIteratorContains(registry.iterator(), snapshot123, snapshot456);
    }

    @Test
    public void testCreateAndDeleteSnapshots() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        Snapshot snapshot123 = registry.getOrCreateSnapshot(123L);
        Snapshot snapshot456 = registry.getOrCreateSnapshot(456L);
        Snapshot snapshot789 = registry.getOrCreateSnapshot(789L);
        registry.deleteSnapshot(snapshot456.epoch());
        SnapshotRegistryTest.assertIteratorContains(registry.iterator(), snapshot123, snapshot789);
    }

    @Test
    public void testDeleteSnapshotUpTo() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        registry.getOrCreateSnapshot(10L);
        registry.getOrCreateSnapshot(12L);
        Snapshot snapshot14 = registry.getOrCreateSnapshot(14L);
        registry.deleteSnapshotsUpTo(14L);
        SnapshotRegistryTest.assertIteratorContains(registry.iterator(), snapshot14);
    }

    @Test
    public void testCreateSnapshotOfLatest() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        registry.getOrCreateSnapshot(10L);
        Snapshot latest = registry.getOrCreateSnapshot(12L);
        Snapshot duplicate = registry.getOrCreateSnapshot(12L);
        Assertions.assertEquals((Object)latest, (Object)duplicate);
    }
}

