/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ConfigurationControlManager;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfigurationControlManagerTest {
    static final Map<ConfigResource.Type, ConfigDef> CONFIGS = new HashMap<ConfigResource.Type, ConfigDef>();
    static final ConfigResource BROKER0;
    static final ConfigResource MYTOPIC;

    private static <A, B> Map<A, B> toMap(Map.Entry ... entries) {
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    static <A, B> Map.Entry<A, B> entry(A a, B b) {
        return new AbstractMap.SimpleImmutableEntry<A, B>(a, b);
    }

    @Test
    public void testReplay() throws Exception {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS, Optional.empty(), ConfigurationValidator.NO_OP);
        Assertions.assertEquals(Collections.emptyMap(), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue("1,2"));
        Assertions.assertEquals(Collections.singletonMap("foo.bar", "1,2"), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue(null));
        Assertions.assertEquals(Collections.emptyMap(), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("x,y,z"));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("def").setValue("blah"));
        Assertions.assertEquals(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", "x,y,z"), ConfigurationControlManagerTest.entry("def", "blah")), (Object)manager.getConfigs(MYTOPIC));
        RecordTestUtils.assertBatchIteratorContains(Arrays.asList(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("x,y,z"), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("def").setValue("blah"), 0))), (Iterator<List<ApiMessageAndVersion>>)manager.iterator(Long.MAX_VALUE));
    }

    @Test
    public void testCheckConfigResource() {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Unsupported configuration resource type BROKER_LOGGER ").toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "kafka.server.FetchContext")).toString());
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Illegal topic name.").toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.TOPIC, "* @ invalid$")).toString());
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Illegal topic name.").toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.TOPIC, "")).toString());
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Illegal non-integral BROKER resource type name.").toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.BROKER, "bob")).toString());
        Assertions.assertEquals((Object)new ApiError(Errors.NONE, null).toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.BROKER, "")).toString());
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Unsupported configuration resource type UNKNOWN.").toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.UNKNOWN, "bob")).toString());
    }

    @Test
    public void testIncrementalAlterConfigs() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS, Optional.empty(), ConfigurationValidator.NO_OP);
        ControllerResult result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("baz", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SUBTRACT, "abc")), ConfigurationControlManagerTest.entry("quux", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "abc")))), ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.APPEND, "123"))))));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("123"), 0)), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, new ApiError(Errors.INVALID_CONFIG, "Can't SUBTRACT to key baz because its type is not LIST.")), ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue(null), 0)), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.DELETE, "xyz")))))));
    }

    @Test
    public void testIncrementalAlterConfigsWithPolicy() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        MockAlterConfigsPolicy policy = new MockAlterConfigsPolicy(Arrays.asList(new AlterConfigPolicy.RequestMetadata(MYTOPIC, Collections.emptyMap()), new AlterConfigPolicy.RequestMetadata(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("foo.bar", "123"), ConfigurationControlManagerTest.entry("quux", "456")))));
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS, Optional.of(policy), ConfigurationValidator.NO_OP);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue("123"), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("quux").setValue("456"), 0)), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, new ApiError(Errors.POLICY_VIOLATION, "Expected: AlterConfigPolicy.RequestMetadata(resource=ConfigResource(type=TOPIC, name='mytopic'), configs={}). Got: AlterConfigPolicy.RequestMetadata(resource=ConfigResource(type=TOPIC, name='mytopic'), configs={foo.bar=123})")), ConfigurationControlManagerTest.entry(BROKER0, ApiError.NONE))), (Object)manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("foo.bar", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "123")))), ConfigurationControlManagerTest.entry(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("foo.bar", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "123")), ConfigurationControlManagerTest.entry("quux", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "456")))))));
    }

    @Test
    public void testIsSplittable() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS, Optional.empty(), ConfigurationValidator.NO_OP);
        Assertions.assertTrue((boolean)manager.isSplittable(ConfigResource.Type.BROKER, "foo.bar"));
        Assertions.assertFalse((boolean)manager.isSplittable(ConfigResource.Type.BROKER, "baz"));
        Assertions.assertFalse((boolean)manager.isSplittable(ConfigResource.Type.BROKER, "foo.baz.quux"));
        Assertions.assertFalse((boolean)manager.isSplittable(ConfigResource.Type.TOPIC, "baz"));
        Assertions.assertTrue((boolean)manager.isSplittable(ConfigResource.Type.TOPIC, "abc"));
    }

    @Test
    public void testGetConfigValueDefault() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS, Optional.empty(), ConfigurationValidator.NO_OP);
        Assertions.assertEquals((Object)"1", (Object)manager.getConfigValueDefault(ConfigResource.Type.BROKER, "foo.bar"));
        Assertions.assertEquals(null, (Object)manager.getConfigValueDefault(ConfigResource.Type.BROKER, "foo.baz.quux"));
        Assertions.assertEquals(null, (Object)manager.getConfigValueDefault(ConfigResource.Type.TOPIC, "abc"));
        Assertions.assertEquals((Object)"true", (Object)manager.getConfigValueDefault(ConfigResource.Type.TOPIC, "ghi"));
    }

    @Test
    public void testLegacyAlterConfigs() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS, Optional.empty(), ConfigurationValidator.NO_OP);
        List<ApiMessageAndVersion> expectedRecords1 = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("456"), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("def").setValue("901"), 0));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(expectedRecords1, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.legacyAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", "456"), ConfigurationControlManagerTest.entry("def", "901"))))));
        for (ApiMessageAndVersion message : expectedRecords1) {
            manager.replay((ConfigRecord)message.message());
        }
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue(null), 0)), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.legacyAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("def", "901"))))));
    }

    static {
        CONFIGS.put(ConfigResource.Type.BROKER, new ConfigDef().define("foo.bar", ConfigDef.Type.LIST, (Object)"1", ConfigDef.Importance.HIGH, "foo bar").define("baz", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "baz").define("quux", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "quux"));
        CONFIGS.put(ConfigResource.Type.TOPIC, new ConfigDef().define("abc", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "abc").define("def", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "def").define("ghi", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.HIGH, "ghi"));
        BROKER0 = new ConfigResource(ConfigResource.Type.BROKER, "0");
        MYTOPIC = new ConfigResource(ConfigResource.Type.TOPIC, "mytopic");
    }

    private static class MockAlterConfigsPolicy
    implements AlterConfigPolicy {
        private final List<AlterConfigPolicy.RequestMetadata> expecteds;
        private final AtomicLong index = new AtomicLong(0L);

        MockAlterConfigsPolicy(List<AlterConfigPolicy.RequestMetadata> expecteds) {
            this.expecteds = expecteds;
        }

        public void validate(AlterConfigPolicy.RequestMetadata actual) throws PolicyViolationException {
            long curIndex = this.index.getAndIncrement();
            if (curIndex >= (long)this.expecteds.size()) {
                throw new PolicyViolationException("Unexpected config alteration: index out of range at " + curIndex);
            }
            AlterConfigPolicy.RequestMetadata expected = this.expecteds.get((int)curIndex);
            if (!expected.equals((Object)actual)) {
                throw new PolicyViolationException("Expected: " + expected + ". Got: " + actual);
            }
        }

        public void close() throws Exception {
        }

        public void configure(Map<String, ?> configs) {
        }
    }
}

