/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metalog;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metalog.MetaLogLeader;
import org.apache.kafka.metalog.MetaLogListener;

public class MockMetaLogManagerListener
implements MetaLogListener {
    public static final String COMMIT = "COMMIT";
    public static final String LAST_COMMITTED_OFFSET = "LAST_COMMITTED_OFFSET";
    public static final String NEW_LEADER = "NEW_LEADER";
    public static final String RENOUNCE = "RENOUNCE";
    public static final String SHUTDOWN = "SHUTDOWN";
    private final List<String> serializedEvents = new ArrayList<String>();

    public synchronized void handleCommits(long lastCommittedOffset, List<ApiMessage> messages) {
        for (ApiMessage message : messages) {
            StringBuilder bld = new StringBuilder();
            bld.append(COMMIT).append(" ").append(message.toString());
            this.serializedEvents.add(bld.toString());
        }
        StringBuilder bld = new StringBuilder();
        bld.append(LAST_COMMITTED_OFFSET).append(" ").append(lastCommittedOffset);
        this.serializedEvents.add(bld.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewLeader(MetaLogLeader leader) {
        StringBuilder bld = new StringBuilder();
        bld.append(NEW_LEADER).append(" ").append(leader.nodeId()).append(" ").append(leader.epoch());
        MockMetaLogManagerListener mockMetaLogManagerListener = this;
        synchronized (mockMetaLogManagerListener) {
            this.serializedEvents.add(bld.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRenounce(long epoch) {
        StringBuilder bld = new StringBuilder();
        bld.append(RENOUNCE).append(" ").append(epoch);
        MockMetaLogManagerListener mockMetaLogManagerListener = this;
        synchronized (mockMetaLogManagerListener) {
            this.serializedEvents.add(bld.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginShutdown() {
        StringBuilder bld = new StringBuilder();
        bld.append(SHUTDOWN);
        MockMetaLogManagerListener mockMetaLogManagerListener = this;
        synchronized (mockMetaLogManagerListener) {
            this.serializedEvents.add(bld.toString());
        }
    }

    public synchronized List<String> serializedEvents() {
        return new ArrayList<String>(this.serializedEvents);
    }
}

