/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.metadata.MetadataParseException;
import org.apache.kafka.metadata.MetadataParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=40L)
public class MetadataParserTest {
    private static final Logger log = LoggerFactory.getLogger(MetadataParserTest.class);

    @Test
    public void testRoundTrips() {
        MetadataParserTest.testRoundTrip(new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(2L), (short)0);
        MetadataParserTest.testRoundTrip(new ConfigRecord().setName("my.config.value").setResourceName("foo").setResourceType((byte)0).setValue("bar"), (short)0);
    }

    private static void testRoundTrip(ApiMessage message, short version) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = MetadataParser.size((ApiMessage)message, (short)version, (ObjectSerializationCache)cache);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        MetadataParser.write((ApiMessage)message, (short)version, (ObjectSerializationCache)cache, (ByteBuffer)buffer);
        buffer.flip();
        ApiMessage message2 = MetadataParser.read((ByteBuffer)buffer.duplicate());
        Assertions.assertEquals((Object)message, (Object)message2);
        Assertions.assertEquals((Object)message2, (Object)message);
        ObjectSerializationCache cache2 = new ObjectSerializationCache();
        int size2 = MetadataParser.size((ApiMessage)message2, (short)version, (ObjectSerializationCache)cache2);
        Assertions.assertEquals((int)size, (int)size2);
        ByteBuffer buffer2 = ByteBuffer.allocate(size);
        MetadataParser.write((ApiMessage)message2, (short)version, (ObjectSerializationCache)cache2, (ByteBuffer)buffer2);
        buffer2.flip();
        Assertions.assertEquals((Object)buffer.duplicate(), (Object)buffer2.duplicate());
    }

    @Test
    public void testMaxSerializedEventSizeCheck() {
        ArrayList<Integer> longReplicaList = new ArrayList<Integer>(0x800000);
        for (int i = 0; i < 0x800000; ++i) {
            longReplicaList.add(i);
        }
        PartitionRecord partitionRecord = new PartitionRecord().setReplicas(longReplicaList);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        Assertions.assertEquals((Object)"Event size would be 33554482, but the maximum serialized event size is 33554432", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> MetadataParser.size((ApiMessage)partitionRecord, (short)0, (ObjectSerializationCache)cache))).getMessage());
    }

    @Test
    public void testParsingMalformedMessageTypeVarint() {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.clear();
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.position(0);
        buffer.limit(64);
        MetadataParserTest.assertStartsWith("Failed to read variable-length type number", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> MetadataParser.read((ByteBuffer)buffer))).getMessage());
    }

    @Test
    public void testParsingMalformedMessageVersionVarint() {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.clear();
        buffer.put((byte)0);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.position(0);
        buffer.limit(64);
        MetadataParserTest.assertStartsWith("Failed to read variable-length version number", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> MetadataParser.read((ByteBuffer)buffer))).getMessage());
    }

    @Test
    public void testParsingRecordWithGarbageAtEnd() {
        RegisterBrokerRecord message = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(2L);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = MetadataParser.size((ApiMessage)message, (short)0, (ObjectSerializationCache)cache);
        ByteBuffer buffer = ByteBuffer.allocate(size + 1);
        MetadataParser.write((ApiMessage)message, (short)0, (ObjectSerializationCache)cache, (ByteBuffer)buffer);
        buffer.clear();
        MetadataParserTest.assertStartsWith("Found 1 byte(s) of garbage after", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> MetadataParser.read((ByteBuffer)buffer))).getMessage());
    }

    private static void assertStartsWith(String prefix, String str) {
        Assertions.assertTrue((boolean)str.startsWith(prefix), (String)("Expected string '" + str + "' to start with '" + prefix + "'"));
    }
}

