/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.metadata.FeatureMap;
import org.apache.kafka.metadata.FeatureMapAndEpoch;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class FeatureControlManagerTest {
    private static Map<String, VersionRange> rangeMap(Object ... args) {
        HashMap<String, VersionRange> result = new HashMap<String, VersionRange>();
        for (int i = 0; i < args.length; i += 3) {
            String feature = (String)args[i];
            Integer low = (Integer)args[i + 1];
            Integer high = (Integer)args[i + 2];
            result.put(feature, new VersionRange(low.shortValue(), high.shortValue()));
        }
        return result;
    }

    @Test
    public void testUpdateFeatures() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        snapshotRegistry.createSnapshot(-1L);
        FeatureControlManager manager = new FeatureControlManager(FeatureControlManagerTest.rangeMap("foo", 1, 2), snapshotRegistry);
        Assertions.assertEquals((Object)new FeatureMapAndEpoch(new FeatureMap(Collections.emptyMap()), -1L), (Object)manager.finalizedFeatures(-1L));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), Collections.singletonMap("foo", new ApiError(Errors.INVALID_UPDATE_VERSION, "The controller does not support the given feature range."))), (Object)manager.updateFeatures(FeatureControlManagerTest.rangeMap("foo", 1, 3), Collections.singleton("foo"), Collections.emptyMap()));
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.rangeMap("foo", 1, 2, "bar", 1, 1), Collections.emptySet(), Collections.emptyMap());
        HashMap<String, ApiError> expectedMap = new HashMap<String, ApiError>();
        expectedMap.put("foo", ApiError.NONE);
        expectedMap.put("bar", new ApiError(Errors.INVALID_UPDATE_VERSION, "The controller does not support the given feature range."));
        Assertions.assertEquals(expectedMap, (Object)result.response());
        ArrayList<ApiMessageAndVersion> expectedMessages = new ArrayList<ApiMessageAndVersion>();
        expectedMessages.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setMinFeatureLevel((short)1).setMaxFeatureLevel((short)2), 0));
        Assertions.assertEquals(expectedMessages, (Object)result.records());
    }

    @Test
    public void testReplay() {
        FeatureLevelRecord record = new FeatureLevelRecord().setName("foo").setMinFeatureLevel((short)1).setMaxFeatureLevel((short)2);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        snapshotRegistry.createSnapshot(-1L);
        FeatureControlManager manager = new FeatureControlManager(FeatureControlManagerTest.rangeMap("foo", 1, 2), snapshotRegistry);
        manager.replay(record, 123L);
        snapshotRegistry.createSnapshot(123L);
        Assertions.assertEquals((Object)new FeatureMapAndEpoch(new FeatureMap(FeatureControlManagerTest.rangeMap("foo", 1, 2)), 123L), (Object)manager.finalizedFeatures(123L));
    }

    @Test
    public void testUpdateFeaturesErrorCases() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager manager = new FeatureControlManager(FeatureControlManagerTest.rangeMap("foo", 1, 5, "bar", 1, 2), snapshotRegistry);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), Collections.singletonMap("foo", new ApiError(Errors.INVALID_UPDATE_VERSION, "Broker 5 does not support the given feature range."))), (Object)manager.updateFeatures(FeatureControlManagerTest.rangeMap("foo", 1, 3), Collections.singleton("foo"), Collections.singletonMap(5, FeatureControlManagerTest.rangeMap(new Object[0]))));
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.rangeMap("foo", 1, 3), Collections.emptySet(), Collections.emptyMap());
        Assertions.assertEquals(Collections.singletonMap("foo", ApiError.NONE), (Object)result.response());
        manager.replay((FeatureLevelRecord)((ApiMessageAndVersion)result.records().get(0)).message(), 3L);
        snapshotRegistry.createSnapshot(3L);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), Collections.singletonMap("foo", new ApiError(Errors.INVALID_UPDATE_VERSION, "Can't downgrade the maximum version of this feature without setting downgradable to true."))), (Object)manager.updateFeatures(FeatureControlManagerTest.rangeMap("foo", 1, 2), Collections.emptySet(), Collections.emptyMap()));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setMinFeatureLevel((short)1).setMaxFeatureLevel((short)2), 0)), Collections.singletonMap("foo", ApiError.NONE)), (Object)manager.updateFeatures(FeatureControlManagerTest.rangeMap("foo", 1, 2), Collections.singleton("foo"), Collections.emptyMap()));
    }
}

