/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.log4jappender;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.log4jappender.MockKafkaLog4jAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KafkaLog4jAppenderTest {
    private Logger logger = Logger.getLogger(KafkaLog4jAppenderTest.class);

    @Before
    public void setup() {
        LogLog.setInternalDebugging((boolean)true);
    }

    @Test
    public void testKafkaLog4jConfigs() {
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO");
        props.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.KafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.Topic", "test-topic");
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        try {
            PropertyConfigurator.configure((Properties)props);
            Assert.fail((String)"Missing properties exception was expected !");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        props = new Properties();
        props.put("log4j.rootLogger", "INFO");
        props.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.KafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.brokerList", "127.0.0.1:9093");
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        try {
            PropertyConfigurator.configure((Properties)props);
            Assert.fail((String)"Missing properties exception was expected !");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testSetSaslMechanism() {
        Properties props = this.getLog4jConfig(false);
        props.put("log4j.appender.KAFKA.SaslMechanism", "PLAIN");
        PropertyConfigurator.configure((Properties)props);
        MockKafkaLog4jAppender mockKafkaLog4jAppender = this.getMockKafkaLog4jAppender();
        MatcherAssert.assertThat((Object)mockKafkaLog4jAppender.getProducerProperties().getProperty("sasl.mechanism"), (Matcher)CoreMatchers.equalTo((Object)"PLAIN"));
    }

    @Test
    public void testSaslMechanismNotSet() {
        this.testProducerPropertyNotSet("sasl.mechanism");
    }

    @Test
    public void testSetJaasConfig() {
        Properties props = this.getLog4jConfig(false);
        props.put("log4j.appender.KAFKA.ClientJaasConf", "jaas-config");
        PropertyConfigurator.configure((Properties)props);
        MockKafkaLog4jAppender mockKafkaLog4jAppender = this.getMockKafkaLog4jAppender();
        MatcherAssert.assertThat((Object)mockKafkaLog4jAppender.getProducerProperties().getProperty("sasl.jaas.config"), (Matcher)CoreMatchers.equalTo((Object)"jaas-config"));
    }

    @Test
    public void testJaasConfigNotSet() {
        this.testProducerPropertyNotSet("sasl.jaas.config");
    }

    private void testProducerPropertyNotSet(String name) {
        PropertyConfigurator.configure((Properties)this.getLog4jConfig(false));
        MockKafkaLog4jAppender mockKafkaLog4jAppender = this.getMockKafkaLog4jAppender();
        MatcherAssert.assertThat(mockKafkaLog4jAppender.getProducerProperties().stringPropertyNames(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)name)));
    }

    @Test
    public void testLog4jAppends() {
        PropertyConfigurator.configure((Properties)this.getLog4jConfig(false));
        for (int i = 1; i <= 5; ++i) {
            this.logger.error((Object)this.getMessage(i));
        }
        Assert.assertEquals((long)5L, (long)this.getMockKafkaLog4jAppender().getHistory().size());
    }

    @Test(expected=RuntimeException.class)
    public void testLog4jAppendsWithSyncSendAndSimulateProducerFailShouldThrowException() {
        Properties props = this.getLog4jConfig(true);
        props.put("log4j.appender.KAFKA.IgnoreExceptions", "false");
        PropertyConfigurator.configure((Properties)props);
        MockKafkaLog4jAppender mockKafkaLog4jAppender = this.getMockKafkaLog4jAppender();
        this.replaceProducerWithMocked(mockKafkaLog4jAppender, false);
        this.logger.error((Object)this.getMessage(0));
    }

    @Test
    public void testLog4jAppendsWithSyncSendWithoutIgnoringExceptionsShouldNotThrowException() {
        Properties props = this.getLog4jConfig(true);
        props.put("log4j.appender.KAFKA.IgnoreExceptions", "false");
        PropertyConfigurator.configure((Properties)props);
        MockKafkaLog4jAppender mockKafkaLog4jAppender = this.getMockKafkaLog4jAppender();
        this.replaceProducerWithMocked(mockKafkaLog4jAppender, true);
        this.logger.error((Object)this.getMessage(0));
    }

    @Test
    public void testLog4jAppendsWithRealProducerConfigWithSyncSendShouldNotThrowException() {
        Properties props = this.getLog4jConfigWithRealProducer(true);
        PropertyConfigurator.configure((Properties)props);
        this.logger.error((Object)this.getMessage(0));
    }

    @Test(expected=RuntimeException.class)
    public void testLog4jAppendsWithRealProducerConfigWithSyncSendAndNotIgnoringExceptionsShouldThrowException() {
        Properties props = this.getLog4jConfigWithRealProducer(false);
        PropertyConfigurator.configure((Properties)props);
        this.logger.error((Object)this.getMessage(0));
    }

    private void replaceProducerWithMocked(MockKafkaLog4jAppender mockKafkaLog4jAppender, boolean success) {
        MockProducer producer = (MockProducer)EasyMock.niceMock(MockProducer.class);
        Future futureMock = (Future)EasyMock.niceMock(Future.class);
        try {
            if (!success) {
                EasyMock.expect(futureMock.get()).andThrow((Throwable)new ExecutionException("simulated timeout", new TimeoutException()));
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        EasyMock.expect((Object)producer.send((ProducerRecord)EasyMock.anyObject())).andReturn((Object)futureMock);
        EasyMock.replay((Object[])new Object[]{producer, futureMock});
        mockKafkaLog4jAppender.setKafkaProducer((MockProducer<byte[], byte[]>)producer);
        mockKafkaLog4jAppender.activateOptions();
    }

    private MockKafkaLog4jAppender getMockKafkaLog4jAppender() {
        return (MockKafkaLog4jAppender)Logger.getRootLogger().getAppender("KAFKA");
    }

    private byte[] getMessage(int i) {
        return ("test_" + i).getBytes(StandardCharsets.UTF_8);
    }

    private Properties getLog4jConfigWithRealProducer(boolean ignoreExceptions) {
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, KAFKA");
        props.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.KafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.BrokerList", "127.0.0.2:9093");
        props.put("log4j.appender.KAFKA.Topic", "test-topic");
        props.put("log4j.appender.KAFKA.RequiredNumAcks", "1");
        props.put("log4j.appender.KAFKA.SyncSend", "true");
        props.put("log4j.appender.KAFKA.maxBlockMs", "10");
        props.put("log4j.appender.KAFKA.IgnoreExceptions", Boolean.toString(ignoreExceptions));
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        return props;
    }

    private Properties getLog4jConfig(boolean syncSend) {
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, KAFKA");
        props.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.MockKafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.BrokerList", "127.0.0.1:9093");
        props.put("log4j.appender.KAFKA.Topic", "test-topic");
        props.put("log4j.appender.KAFKA.RequiredNumAcks", "1");
        props.put("log4j.appender.KAFKA.SyncSend", Boolean.toString(syncSend));
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        return props;
    }
}

