/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.log4jappender;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.log4jappender.MockKafkaLog4jAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class KafkaLog4jAppenderTest {
    private Logger logger = Logger.getLogger(KafkaLog4jAppenderTest.class);

    @BeforeEach
    public void setup() {
        LogLog.setInternalDebugging((boolean)true);
    }

    @AfterEach
    public void cleanup() {
        Logger rootLogger = Logger.getRootLogger();
        Appender appender = rootLogger.getAppender("KAFKA");
        if (appender != null) {
            rootLogger.removeAppender(appender);
            appender.close();
        }
    }

    @Test
    public void testKafkaLog4jConfigs() {
        Properties hostMissingProps = new Properties();
        hostMissingProps.put("log4j.rootLogger", "INFO");
        hostMissingProps.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.KafkaLog4jAppender");
        hostMissingProps.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        hostMissingProps.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        hostMissingProps.put("log4j.appender.KAFKA.Topic", "test-topic");
        hostMissingProps.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        Assertions.assertThrows(ConfigException.class, () -> PropertyConfigurator.configure((Properties)hostMissingProps), (String)"Missing properties exception was expected !");
        Properties topicMissingProps = new Properties();
        topicMissingProps.put("log4j.rootLogger", "INFO");
        topicMissingProps.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.KafkaLog4jAppender");
        topicMissingProps.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        topicMissingProps.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        topicMissingProps.put("log4j.appender.KAFKA.brokerList", "127.0.0.1:9093");
        topicMissingProps.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        Assertions.assertThrows(ConfigException.class, () -> PropertyConfigurator.configure((Properties)topicMissingProps), (String)"Missing properties exception was expected !");
    }

    @Test
    public void testSetSaslMechanism() {
        Properties props = this.getLog4jConfig(false);
        props.put("log4j.appender.KAFKA.SaslMechanism", "PLAIN");
        PropertyConfigurator.configure((Properties)props);
        MockKafkaLog4jAppender mockKafkaLog4jAppender = this.getMockKafkaLog4jAppender();
        Assertions.assertEquals((Object)mockKafkaLog4jAppender.getProducerProperties().getProperty("sasl.mechanism"), (Object)"PLAIN");
    }

    @Test
    public void testSaslMechanismNotSet() {
        this.testProducerPropertyNotSet("sasl.mechanism");
    }

    @Test
    public void testSetJaasConfig() {
        Properties props = this.getLog4jConfig(false);
        props.put("log4j.appender.KAFKA.ClientJaasConf", "jaas-config");
        PropertyConfigurator.configure((Properties)props);
        MockKafkaLog4jAppender mockKafkaLog4jAppender = this.getMockKafkaLog4jAppender();
        Assertions.assertEquals((Object)mockKafkaLog4jAppender.getProducerProperties().getProperty("sasl.jaas.config"), (Object)"jaas-config");
    }

    @Test
    public void testJaasConfigNotSet() {
        this.testProducerPropertyNotSet("sasl.jaas.config");
    }

    private void testProducerPropertyNotSet(String name) {
        PropertyConfigurator.configure((Properties)this.getLog4jConfig(false));
        MockKafkaLog4jAppender mockKafkaLog4jAppender = this.getMockKafkaLog4jAppender();
        MatcherAssert.assertThat(mockKafkaLog4jAppender.getProducerProperties().stringPropertyNames(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)name)));
    }

    @Test
    public void testLog4jAppends() {
        PropertyConfigurator.configure((Properties)this.getLog4jConfig(false));
        for (int i = 1; i <= 5; ++i) {
            this.logger.error((Object)this.getMessage(i));
        }
        Assertions.assertEquals((int)this.getMockKafkaLog4jAppender().getHistory().size(), (int)5);
    }

    @Test
    public void testSyncSendAndSimulateProducerFailShouldThrowException() {
        Properties props = this.getLog4jConfig(true);
        props.put("log4j.appender.KAFKA.IgnoreExceptions", "false");
        PropertyConfigurator.configure((Properties)props);
        MockKafkaLog4jAppender mockKafkaLog4jAppender = this.getMockKafkaLog4jAppender();
        this.replaceProducerWithMocked(mockKafkaLog4jAppender, false);
        Assertions.assertThrows(RuntimeException.class, () -> this.logger.error((Object)this.getMessage(0)));
    }

    @Test
    public void testSyncSendWithoutIgnoringExceptionsShouldNotThrowException() {
        Properties props = this.getLog4jConfig(true);
        props.put("log4j.appender.KAFKA.IgnoreExceptions", "false");
        PropertyConfigurator.configure((Properties)props);
        MockKafkaLog4jAppender mockKafkaLog4jAppender = this.getMockKafkaLog4jAppender();
        this.replaceProducerWithMocked(mockKafkaLog4jAppender, true);
        this.logger.error((Object)this.getMessage(0));
    }

    @Test
    public void testRealProducerConfigWithSyncSendShouldNotThrowException() {
        Properties props = this.getLog4jConfigWithRealProducer(true);
        PropertyConfigurator.configure((Properties)props);
        this.logger.error((Object)this.getMessage(0));
    }

    @Test
    public void testRealProducerConfigWithSyncSendAndNotIgnoringExceptionsShouldThrowException() {
        Properties props = this.getLog4jConfigWithRealProducer(false);
        PropertyConfigurator.configure((Properties)props);
        Assertions.assertThrows(RuntimeException.class, () -> this.logger.error((Object)this.getMessage(0)));
    }

    private void replaceProducerWithMocked(MockKafkaLog4jAppender mockKafkaLog4jAppender, boolean success) {
        MockProducer producer = (MockProducer)Mockito.mock(MockProducer.class);
        CompletableFuture<RecordMetadata> future = new CompletableFuture<RecordMetadata>();
        if (success) {
            future.complete(new RecordMetadata(new TopicPartition("tp", 0), 0L, 0, 0L, 0, 0));
        } else {
            future.completeExceptionally(new TimeoutException("simulated timeout"));
        }
        Mockito.when((Object)producer.send((ProducerRecord)ArgumentMatchers.any())).thenReturn(future);
        mockKafkaLog4jAppender.setKafkaProducer((MockProducer<byte[], byte[]>)producer);
        mockKafkaLog4jAppender.activateOptions();
    }

    private MockKafkaLog4jAppender getMockKafkaLog4jAppender() {
        return (MockKafkaLog4jAppender)Logger.getRootLogger().getAppender("KAFKA");
    }

    private byte[] getMessage(int i) {
        return ("test_" + i).getBytes(StandardCharsets.UTF_8);
    }

    private Properties getLog4jConfigWithRealProducer(boolean ignoreExceptions) {
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, KAFKA");
        props.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.KafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.BrokerList", "127.0.0.2:9093");
        props.put("log4j.appender.KAFKA.Topic", "test-topic");
        props.put("log4j.appender.KAFKA.RequiredNumAcks", "-1");
        props.put("log4j.appender.KAFKA.SyncSend", "true");
        props.put("log4j.appender.KAFKA.maxBlockMs", "10");
        props.put("log4j.appender.KAFKA.IgnoreExceptions", Boolean.toString(ignoreExceptions));
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        return props;
    }

    private Properties getLog4jConfig(boolean syncSend) {
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, KAFKA");
        props.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.MockKafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.BrokerList", "127.0.0.1:9093");
        props.put("log4j.appender.KAFKA.Topic", "test-topic");
        props.put("log4j.appender.KAFKA.RequiredNumAcks", "-1");
        props.put("log4j.appender.KAFKA.SyncSend", Boolean.toString(syncSend));
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        return props;
    }
}

