/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.log4jappender;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.log4jappender.MockKafkaLog4jAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.junit.Assert;
import org.junit.Test;

public class KafkaLog4jAppenderTest {
    Logger logger = Logger.getLogger(KafkaLog4jAppenderTest.class);

    @Test
    public void testKafkaLog4jConfigs() {
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO");
        props.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.KafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.Topic", "test-topic");
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        try {
            PropertyConfigurator.configure((Properties)props);
            Assert.fail((String)"Missing properties exception was expected !");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        props = new Properties();
        props.put("log4j.rootLogger", "INFO");
        props.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.KafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.brokerList", "127.0.0.1:9093");
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        try {
            PropertyConfigurator.configure((Properties)props);
            Assert.fail((String)"Missing properties exception was expected !");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testLog4jAppends() throws UnsupportedEncodingException {
        PropertyConfigurator.configure((Properties)this.getLog4jConfig());
        for (int i = 1; i <= 5; ++i) {
            this.logger.error((Object)this.getMessage(i));
        }
        KafkaLog4jAppenderTest kafkaLog4jAppenderTest = this;
        Assert.assertEquals((long)5L, (long)((MockKafkaLog4jAppender)kafkaLog4jAppenderTest.logger.getRootLogger().getAppender("KAFKA")).getHistory().size());
    }

    private byte[] getMessage(int i) throws UnsupportedEncodingException {
        return ("test_" + i).getBytes("UTF-8");
    }

    private Properties getLog4jConfig() {
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, KAFKA");
        props.put("log4j.appender.KAFKA", "org.apache.kafka.log4jappender.MockKafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.BrokerList", "127.0.0.1:9093");
        props.put("log4j.appender.KAFKA.Topic", "test-topic");
        props.put("log4j.appender.KAFKA.RequiredNumAcks", "1");
        props.put("log4j.appender.KAFKA.SyncSend", "false");
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        return props;
    }
}

