/*
 * Decompiled with CFR 0.152.
 */
package kafka.bridge.hadoop;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.bridge.hadoop.KafkaRecordWriter;
import kafka.common.KafkaException;
import kafka.javaapi.producer.Producer;
import kafka.producer.ProducerConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.log4j.Logger;

public class KafkaOutputFormat<K, V>
extends OutputFormat<K, V> {
    private Logger log = Logger.getLogger(KafkaOutputFormat.class);
    public static final String KAFKA_URL = "kafka.output.url";
    public static final int KAFKA_QUEUE_BYTES = 1000000;
    public static final String KAFKA_CONFIG_PREFIX = "kafka.output";
    private static final Map<String, String> kafkaConfigMap;

    public static void setOutputPath(Job job, Path outputUrl) {
        job.getConfiguration().set(KAFKA_URL, outputUrl.toString());
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapred.reduce.tasks.speculative.execution", false);
    }

    public static Path getOutputPath(JobContext job) {
        String name = job.getConfiguration().get(KAFKA_URL);
        return name == null ? null : new Path(name);
    }

    public void checkOutputSpecs(JobContext jobContext) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new FileOutputCommitter(new Path("/tmp/" + taskAttemptContext.getTaskAttemptID().getJobID().toString()), taskAttemptContext);
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        String brokerList;
        Path outputPath = KafkaOutputFormat.getOutputPath((JobContext)context);
        if (outputPath == null) {
            throw new KafkaException("no kafka output url specified");
        }
        URI uri = URI.create(outputPath.toString());
        Configuration job = context.getConfiguration();
        Properties props = new Properties();
        props.putAll(kafkaConfigMap);
        for (Map.Entry<Object, Object> m : job) {
            if (!((String)m.getKey()).startsWith(KAFKA_CONFIG_PREFIX) || ((String)m.getKey()).equals(KAFKA_URL)) continue;
            String kafkaKeyName = ((String)m.getKey()).substring(KAFKA_CONFIG_PREFIX.length() + 1);
            props.setProperty(kafkaKeyName, (String)m.getValue());
        }
        for (Map.Entry<Object, Object> m : props.entrySet()) {
            job.set("kafka.output." + m.getKey().toString(), m.getValue().toString());
        }
        int queueBytes = job.getInt("kafka.output.queue.bytes", 1000000);
        if (uri.getScheme().equals("kafka")) {
            brokerList = uri.getAuthority();
            props.setProperty("metadata.broker.list", brokerList);
            job.set("kafka.output.metadata.broker.list", brokerList);
            if (uri.getPath() == null || uri.getPath().length() <= 1) {
                throw new KafkaException("no topic specified in kafka uri");
            }
        } else {
            throw new KafkaException("missing scheme from kafka uri (must be kafka://)");
        }
        String topic = uri.getPath().substring(1);
        job.set("kafka.output.topic", topic);
        this.log.info((Object)String.format("using kafka broker %s (topic %s)", brokerList, topic));
        Producer producer = new Producer(new ProducerConfig(props));
        return new KafkaRecordWriter((Producer<Object, byte[]>)producer, topic, queueBytes);
    }

    static {
        HashMap<String, String> cMap = new HashMap<String, String>();
        cMap.put("producer.type", "sync");
        cMap.put("compression.codec", Integer.toString(1));
        cMap.put("request.required.acks", Integer.toString(1));
        kafkaConfigMap = Collections.unmodifiableMap(cMap);
    }
}

