/*
 * Decompiled with CFR 0.152.
 */
package kafka.etl.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import kafka.etl.KafkaETLKey;
import kafka.etl.KafkaETLUtils;
import kafka.message.Message;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class SimpleKafkaETLMapper
implements Mapper<KafkaETLKey, BytesWritable, LongWritable, Text> {
    protected long _count = 0L;

    protected Text getData(Message message) throws IOException {
        ByteBuffer buf = message.payload();
        if (buf == null) {
            return new Text();
        }
        byte[] array = new byte[buf.limit()];
        buf.get(array);
        Text text = new Text(new String(array, "UTF8"));
        return text;
    }

    public void map(KafkaETLKey key, BytesWritable val, OutputCollector<LongWritable, Text> collector, Reporter reporter) throws IOException {
        byte[] bytes = KafkaETLUtils.getBytes(val);
        Message message = new Message(ByteBuffer.wrap(bytes));
        long checksum = key.getChecksum();
        if (checksum != message.checksum()) {
            throw new IOException("Invalid message checksum " + message.checksum() + ". Expected " + key + ".");
        }
        Text data = this.getData(message);
        ++this._count;
        collector.collect((Object)new LongWritable(this._count), (Object)data);
    }

    public void configure(JobConf arg0) {
    }

    public void close() throws IOException {
    }
}

