/*
 * Decompiled with CFR 0.152.
 */
package kafka.etl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.common.KafkaException;
import kafka.etl.UndefinedPropertyException;
import org.apache.log4j.Logger;

public class Props
extends Properties {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Props.class);

    public Props() {
    }

    public Props(Props props) {
        if (props != null) {
            this.put(props);
        }
    }

    public Props(String ... files) throws FileNotFoundException, IOException {
        this(Arrays.asList(files));
    }

    public Props(List<String> files) throws FileNotFoundException, IOException {
        for (int i = 0; i < files.size(); ++i) {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(new File(files.get(i)).getAbsolutePath()));
            super.load(input);
            ((InputStream)input).close();
        }
    }

    public Props(InputStream ... inputStreams) throws IOException {
        for (InputStream stream : inputStreams) {
            super.load(stream);
        }
    }

    public Props(Map<String, String> ... props) {
        for (int i = props.length - 1; i >= 0; --i) {
            super.putAll(props[i]);
        }
    }

    public Props(Properties ... properties) {
        for (int i = properties.length - 1; i >= 0; --i) {
            this.put(properties[i]);
        }
    }

    public static Props of(String ... args) {
        if (args.length % 2 != 0) {
            throw new KafkaException("Must have an equal number of keys and values.");
        }
        HashMap<String, String> vals = new HashMap<String, String>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            vals.put(args[i], args[i + 1]);
        }
        return new Props(new Map[]{vals});
    }

    public void put(Properties properties) {
        for (String propName : properties.stringPropertyNames()) {
            super.put(propName, properties.getProperty(propName));
        }
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, "\\s*,\\s*");
    }

    public List<String> getStringList(String key, String sep) {
        String val = super.getProperty(key);
        if (val == null || val.trim().length() == 0) {
            return Collections.emptyList();
        }
        if (this.containsKey(key)) {
            return Arrays.asList(val.split(sep));
        }
        throw new UndefinedPropertyException("Missing required property '" + key + "'");
    }

    public List<String> getStringList(String key, List<String> defaultValue) {
        if (this.containsKey(key)) {
            return this.getStringList(key);
        }
        return defaultValue;
    }

    public List<String> getStringList(String key, List<String> defaultValue, String sep) {
        if (this.containsKey(key)) {
            return this.getStringList(key, sep);
        }
        return defaultValue;
    }

    protected <T> T getValue(String key, T defaultValue) throws Exception {
        if (this.containsKey(key)) {
            Object value = super.get(key);
            if (value.getClass().isInstance(defaultValue)) {
                return (T)value;
            }
            if (value instanceof String) {
                Constructor<?> ct = defaultValue.getClass().getConstructor(String.class);
                String v = ((String)value).trim();
                Object ret = ct.newInstance(v);
                return (T)ret;
            }
            throw new UndefinedPropertyException("Property " + key + ": cannot convert value of " + value.getClass().getName() + " to " + defaultValue.getClass().getName());
        }
        return defaultValue;
    }

    protected <T> T getValue(String key, Class<T> mclass) throws Exception {
        if (this.containsKey(key)) {
            Object value = super.get(key);
            if (value.getClass().equals(mclass)) {
                return (T)value;
            }
            if (value instanceof String) {
                Constructor<T> ct = mclass.getConstructor(String.class);
                String v = ((String)value).trim();
                T ret = ct.newInstance(v);
                return ret;
            }
            throw new UndefinedPropertyException("Property " + key + ": cannot convert value of " + value.getClass().getName() + " to " + mclass.getClass().getName());
        }
        throw new UndefinedPropertyException("Missing required property '" + key + "'");
    }

    public Boolean getBoolean(String key, Boolean defaultValue) throws Exception {
        return this.getValue(key, defaultValue);
    }

    public Boolean getBoolean(String key) throws Exception {
        return this.getValue(key, Boolean.class);
    }

    public Long getLong(String name, Long defaultValue) throws Exception {
        return this.getValue(name, defaultValue);
    }

    public Long getLong(String name) throws Exception {
        return this.getValue(name, Long.class);
    }

    public Integer getInt(String name, Integer defaultValue) throws Exception {
        return this.getValue(name, defaultValue);
    }

    public Integer getInt(String name) throws Exception {
        return this.getValue(name, Integer.class);
    }

    public Double getDouble(String name, double defaultValue) throws Exception {
        return this.getValue(name, defaultValue);
    }

    public double getDouble(String name) throws Exception {
        return this.getValue(name, Double.class);
    }

    public URI getUri(String name, URI defaultValue) throws Exception {
        return this.getValue(name, defaultValue);
    }

    public URI getUri(String name, String defaultValue) throws Exception {
        URI defaultV = new URI(defaultValue);
        return this.getValue(name, defaultV);
    }

    public URI getUri(String name) throws Exception {
        return this.getValue(name, URI.class);
    }

    public boolean equalsProps(Props p) {
        if (p == null) {
            return false;
        }
        Set<String> myKeySet = this.getKeySet();
        for (String s : myKeySet) {
            if (this.get(s).equals(p.get(s))) continue;
            return false;
        }
        return myKeySet.size() == p.getKeySet().size();
    }

    public Map<String, String> getMapByPrefix(String prefix) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String key : super.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            values.put(key.substring(prefix.length()), super.getProperty(key));
        }
        return values;
    }

    public void store(OutputStream out) throws IOException {
        super.store(out, null);
    }

    public Set<String> getKeySet() {
        return super.stringPropertyNames();
    }

    public void logProperties(String comment) {
        logger.info((Object)comment);
        for (String key : this.getKeySet()) {
            logger.info((Object)("  key=" + key + " value=" + this.get(key)));
        }
    }

    public static Props clone(Props p) {
        return new Props(p);
    }
}

