/*
 * Decompiled with CFR 0.152.
 */
package kafka.etl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class KafkaETLRequest {
    public static long DEFAULT_OFFSET = -1L;
    public static String DELIM = "\t";
    String _topic;
    URI _uri;
    int _partition;
    long _offset = DEFAULT_OFFSET;
    String _clientId = "KafkaHadoopETL";

    public KafkaETLRequest() {
    }

    public KafkaETLRequest(String input) throws IOException {
        String[] pieces = input.trim().split(DELIM);
        if (pieces.length != 4) {
            throw new IOException(input + " : input must be in the form 'url" + DELIM + "topic" + DELIM + "partition" + DELIM + "offset'");
        }
        try {
            this._uri = new URI(pieces[0]);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this._topic = pieces[1];
        this._partition = Integer.valueOf(pieces[2]);
        this._offset = Long.valueOf(pieces[3]);
    }

    public KafkaETLRequest(String node, String topic, String partition, String offset, Map<String, String> nodes) throws IOException {
        Integer nodeId = Integer.parseInt(node);
        String uri = nodes.get(nodeId.toString());
        if (uri == null) {
            throw new IOException("Cannot form node for id " + nodeId);
        }
        try {
            this._uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this._topic = topic;
        this._partition = Integer.valueOf(partition);
        this._offset = Long.valueOf(offset);
    }

    public KafkaETLRequest(String topic, String uri, int partition) throws URISyntaxException {
        this._topic = topic;
        this._uri = new URI(uri);
        this._partition = partition;
    }

    public void setDefaultOffset() {
        this._offset = DEFAULT_OFFSET;
    }

    public void setOffset(long offset) {
        this._offset = offset;
    }

    public String getTopic() {
        return this._topic;
    }

    public URI getURI() {
        return this._uri;
    }

    public int getPartition() {
        return this._partition;
    }

    public long getOffset() {
        return this._offset;
    }

    public String clientId() {
        return this._clientId;
    }

    public boolean isValidOffset() {
        return this._offset >= 0L;
    }

    public boolean equals(Object o) {
        if (!(o instanceof KafkaETLRequest)) {
            return false;
        }
        KafkaETLRequest r = (KafkaETLRequest)o;
        return this._topic.equals(r._topic) || this._uri.equals(r._uri) || this._partition == r._partition;
    }

    public int hashCode() {
        return this.toString(0L).hashCode();
    }

    public String toString() {
        return this.toString(this._offset);
    }

    public String toString(long offset) {
        return this._uri + DELIM + this._topic + DELIM + this._partition + DELIM + offset;
    }
}

