/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.share;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.ModernGroupMember;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.coordinator.group.modern.share.ShareGroup;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;

public class ShareGroupTest {
    @Test
    public void testType() {
        ShareGroup shareGroup = this.createShareGroup("foo");
        Assertions.assertEquals((Object)Group.GroupType.SHARE, (Object)shareGroup.type());
    }

    @Test
    public void testProtocolType() {
        ShareGroup shareGroup = this.createShareGroup("foo");
        Assertions.assertEquals((Object)"share", (Object)shareGroup.protocolType());
    }

    @Test
    public void testGetOrCreateMember() {
        ShareGroup shareGroup = this.createShareGroup("foo");
        ShareGroupMember member = shareGroup.getOrMaybeCreateMember("member-id", true);
        Assertions.assertEquals((Object)"member-id", (Object)member.memberId());
        shareGroup.updateMember(member);
        member = shareGroup.getOrMaybeCreateMember("member-id", false);
        Assertions.assertEquals((Object)"member-id", (Object)member.memberId());
        Assertions.assertThrows(UnknownMemberIdException.class, () -> shareGroup.getOrMaybeCreateMember("does-not-exist", false));
    }

    @Test
    public void testUpdateMember() {
        ShareGroup shareGroup = this.createShareGroup("foo");
        ShareGroupMember member = shareGroup.getOrMaybeCreateMember("member", true);
        member = new ShareGroupMember.Builder(member).setSubscribedTopicNames(Arrays.asList("foo", "bar")).build();
        shareGroup.updateMember(member);
        Assertions.assertEquals((Object)member, (Object)shareGroup.getOrMaybeCreateMember("member", false));
    }

    @Test
    public void testRemoveMember() {
        ShareGroup shareGroup = this.createShareGroup("foo");
        ShareGroupMember member = shareGroup.getOrMaybeCreateMember("member", true);
        shareGroup.updateMember(member);
        Assertions.assertTrue((boolean)shareGroup.hasMember("member"));
        shareGroup.removeMember("member");
        Assertions.assertFalse((boolean)shareGroup.hasMember("member"));
    }

    @Test
    public void testGroupState() {
        ShareGroup shareGroup = this.createShareGroup("foo");
        Assertions.assertEquals((Object)ShareGroup.ShareGroupState.EMPTY, (Object)shareGroup.state());
        Assertions.assertEquals((Object)"Empty", (Object)shareGroup.stateAsString());
        ShareGroupMember member1 = new ShareGroupMember.Builder("member1").setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).build();
        shareGroup.updateMember(member1);
        shareGroup.setGroupEpoch(1);
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)member1.state());
        Assertions.assertEquals((Object)ShareGroup.ShareGroupState.STABLE, (Object)shareGroup.state());
        Assertions.assertEquals((Object)"Stable", (Object)shareGroup.stateAsString());
    }

    @Test
    public void testGroupTypeFromString() {
        Assertions.assertEquals((Object)Group.GroupType.parse((String)"share"), (Object)Group.GroupType.SHARE);
        Assertions.assertEquals((Object)Group.GroupType.parse((String)"Share"), (Object)Group.GroupType.SHARE);
        Assertions.assertEquals((Object)Group.GroupType.parse((String)"SHare"), (Object)Group.GroupType.SHARE);
    }

    @Test
    public void testUpdateSubscriptionMetadata() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        Uuid zarTopicId = Uuid.randomUuid();
        MetadataImage image = new MetadataImageBuilder().addTopic(fooTopicId, "foo", 1).addTopic(barTopicId, "bar", 2).addTopic(zarTopicId, "zar", 3).addRacks().build();
        ShareGroupMember member1 = new ShareGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build();
        ShareGroupMember member2 = new ShareGroupMember.Builder("member2").setSubscribedTopicNames(Collections.singletonList("bar")).build();
        ShareGroupMember member3 = new ShareGroupMember.Builder("member3").setSubscribedTopicNames(Collections.singletonList("zar")).build();
        ShareGroup shareGroup = this.createShareGroup("group-foo");
        Assertions.assertEquals(Collections.emptyMap(), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(null, null), image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(null, (ModernGroupMember)member1), image.topics(), image.cluster()));
        shareGroup.updateMember(member1);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(null, null), image.topics(), image.cluster()));
        Assertions.assertEquals(Collections.emptyMap(), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames((ModernGroupMember)member1, null), image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(null, (ModernGroupMember)member2), image.topics(), image.cluster()));
        shareGroup.updateMember(member2);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(null, null), image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames((ModernGroupMember)member2, null), image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames((ModernGroupMember)member1, null), image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2)), Utils.mkEntry((Object)"zar", (Object)new TopicMetadata(zarTopicId, "zar", 3))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(null, (ModernGroupMember)member3), image.topics(), image.cluster()));
        shareGroup.updateMember(member3);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2)), Utils.mkEntry((Object)"zar", (Object)new TopicMetadata(zarTopicId, "zar", 3))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(null, null), image.topics(), image.cluster()));
        Assertions.assertEquals(Collections.emptyMap(), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(new HashSet<ShareGroupMember>(Arrays.asList(member1, member2, member3))), image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(new HashSet<ShareGroupMember>(Arrays.asList(member2, member3))), image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2)), Utils.mkEntry((Object)"zar", (Object)new TopicMetadata(zarTopicId, "zar", 3))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(Collections.singleton(member1)), image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2)), Utils.mkEntry((Object)"zar", (Object)new TopicMetadata(zarTopicId, "zar", 3))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(Collections.emptySet()), image.topics(), image.cluster()));
    }

    @Test
    public void testUpdateSubscribedTopicNamesAndSubscriptionType() {
        ShareGroupMember member1 = new ShareGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build();
        ShareGroupMember member2 = new ShareGroupMember.Builder("member2").setSubscribedTopicNames(Arrays.asList("bar", "foo")).build();
        ShareGroupMember member3 = new ShareGroupMember.Builder("member3").setSubscribedTopicNames(Arrays.asList("bar", "foo")).build();
        ShareGroup shareGroup = this.createShareGroup("group-foo");
        Assertions.assertEquals(Collections.emptyMap(), (Object)shareGroup.subscribedTopicNames());
        Assertions.assertEquals((Object)SubscriptionType.HOMOGENEOUS, (Object)shareGroup.subscriptionType());
        shareGroup.updateMember(member1);
        Assertions.assertEquals((Object)SubscriptionType.HOMOGENEOUS, (Object)shareGroup.subscriptionType());
        shareGroup.updateMember(member2);
        Assertions.assertEquals((Object)SubscriptionType.HETEROGENEOUS, (Object)shareGroup.subscriptionType());
        shareGroup.updateMember(member3);
        Assertions.assertEquals((Object)SubscriptionType.HETEROGENEOUS, (Object)shareGroup.subscriptionType());
        shareGroup.removeMember(member1.memberId());
        Assertions.assertEquals((Object)SubscriptionType.HOMOGENEOUS, (Object)shareGroup.subscriptionType());
        ShareGroupMember member4 = new ShareGroupMember.Builder("member2").setSubscribedTopicNames(Arrays.asList("bar", "foo", "zar")).build();
        shareGroup.updateMember(member4);
        Assertions.assertEquals((Object)SubscriptionType.HETEROGENEOUS, (Object)shareGroup.subscriptionType());
    }

    @Test
    public void testUpdateInvertedAssignment() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ShareGroup shareGroup = new ShareGroup(snapshotRegistry, "test-group");
        Uuid topicId = Uuid.randomUuid();
        String memberId1 = "member1";
        String memberId2 = "member2";
        Assignment initialAssignment = new Assignment(Collections.singletonMap(topicId, new HashSet<Integer>(Collections.singletonList(0))));
        shareGroup.updateTargetAssignment(memberId1, initialAssignment);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)memberId1)}))}), (Object)shareGroup.invertedTargetAssignment());
        Assignment newAssignment = new Assignment(Collections.singletonMap(topicId, new HashSet<Integer>(Collections.singletonList(1))));
        shareGroup.updateTargetAssignment(memberId1, newAssignment);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)1, (Object)memberId1)}))}), (Object)shareGroup.invertedTargetAssignment());
        Assignment newAssignment2 = new Assignment(Collections.singletonMap(topicId, new HashSet<Integer>(Collections.singletonList(1))));
        shareGroup.updateTargetAssignment(memberId2, newAssignment2);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)1, (Object)memberId2)}))}), (Object)shareGroup.invertedTargetAssignment());
        Assignment newAssignment1 = new Assignment(Collections.singletonMap(topicId, new HashSet<Integer>(Collections.singletonList(0))));
        shareGroup.updateTargetAssignment(memberId1, newAssignment1);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)memberId1), Utils.mkEntry((Object)1, (Object)memberId2)}))}), (Object)shareGroup.invertedTargetAssignment());
        shareGroup.removeTargetAssignment(memberId1);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)1, (Object)memberId2)}))}), (Object)shareGroup.invertedTargetAssignment());
    }

    @Test
    public void testMetadataRefreshDeadline() {
        MockTime time = new MockTime();
        ShareGroup shareGroup = this.createShareGroup("group-foo");
        Assertions.assertEquals((int)0, (int)shareGroup.groupEpoch());
        Assertions.assertTrue((boolean)shareGroup.hasMetadataExpired(time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)shareGroup.metadataRefreshDeadline().deadlineMs);
        Assertions.assertEquals((int)0, (int)shareGroup.metadataRefreshDeadline().epoch);
        shareGroup.setMetadataRefreshDeadline(time.milliseconds() + 1000L, shareGroup.groupEpoch());
        Assertions.assertFalse((boolean)shareGroup.hasMetadataExpired(time.milliseconds()));
        Assertions.assertEquals((long)(time.milliseconds() + 1000L), (long)shareGroup.metadataRefreshDeadline().deadlineMs);
        Assertions.assertEquals((int)shareGroup.groupEpoch(), (int)shareGroup.metadataRefreshDeadline().epoch);
        time.sleep(1001L);
        Assertions.assertTrue((boolean)shareGroup.hasMetadataExpired(time.milliseconds()));
        shareGroup.setMetadataRefreshDeadline(time.milliseconds() + 1000L, shareGroup.groupEpoch() + 1);
        Assertions.assertTrue((boolean)shareGroup.hasMetadataExpired(time.milliseconds()));
        Assertions.assertEquals((long)(time.milliseconds() + 1000L), (long)shareGroup.metadataRefreshDeadline().deadlineMs);
        Assertions.assertEquals((int)(shareGroup.groupEpoch() + 1), (int)shareGroup.metadataRefreshDeadline().epoch);
        shareGroup.setGroupEpoch(shareGroup.groupEpoch() + 1);
        shareGroup.setMetadataRefreshDeadline(time.milliseconds() + 1000L, shareGroup.groupEpoch());
        Assertions.assertFalse((boolean)shareGroup.hasMetadataExpired(time.milliseconds()));
        Assertions.assertEquals((long)(time.milliseconds() + 1000L), (long)shareGroup.metadataRefreshDeadline().deadlineMs);
        Assertions.assertEquals((int)shareGroup.groupEpoch(), (int)shareGroup.metadataRefreshDeadline().epoch);
        shareGroup.requestMetadataRefresh();
        Assertions.assertTrue((boolean)shareGroup.hasMetadataExpired(time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)shareGroup.metadataRefreshDeadline().deadlineMs);
        Assertions.assertEquals((int)0, (int)shareGroup.metadataRefreshDeadline().epoch);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_COMMIT)
    public void testValidateOffsetCommit(short version) {
        ShareGroup shareGroup = this.createShareGroup("group-foo");
        Assertions.assertThrows(GroupIdNotFoundException.class, () -> shareGroup.validateOffsetCommit(null, null, -1, false, version));
    }

    @Test
    public void testAsListedGroup() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ShareGroup shareGroup = new ShareGroup(snapshotRegistry, "group-foo");
        snapshotRegistry.idempotentCreateSnapshot(0L);
        Assertions.assertEquals((Object)ShareGroup.ShareGroupState.EMPTY, (Object)shareGroup.state(0L));
        Assertions.assertEquals((Object)"Empty", (Object)shareGroup.stateAsString(0L));
        shareGroup.updateMember(new ShareGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build());
        snapshotRegistry.idempotentCreateSnapshot(1L);
        Assertions.assertEquals((Object)ShareGroup.ShareGroupState.EMPTY, (Object)shareGroup.state(0L));
        Assertions.assertEquals((Object)"Empty", (Object)shareGroup.stateAsString(0L));
        Assertions.assertEquals((Object)ShareGroup.ShareGroupState.STABLE, (Object)shareGroup.state(1L));
        Assertions.assertEquals((Object)"Stable", (Object)shareGroup.stateAsString(1L));
    }

    @Test
    public void testOffsetExpirationCondition() {
        ShareGroup shareGroup = this.createShareGroup("group-foo");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((ShareGroup)shareGroup).offsetExpirationCondition());
    }

    @Test
    public void testValidateOffsetFetch() {
        ShareGroup shareGroup = this.createShareGroup("group-foo");
        Assertions.assertThrows(GroupIdNotFoundException.class, () -> shareGroup.validateOffsetFetch(null, -1, -1L));
    }

    @Test
    public void testValidateOffsetDelete() {
        ShareGroup shareGroup = this.createShareGroup("group-foo");
        Assertions.assertThrows(GroupIdNotFoundException.class, () -> ((ShareGroup)shareGroup).validateOffsetDelete());
    }

    @Test
    public void testValidateDeleteGroup() {
        ShareGroup shareGroup = this.createShareGroup("foo");
        Assertions.assertEquals((Object)ShareGroup.ShareGroupState.EMPTY, (Object)shareGroup.state());
        Assertions.assertDoesNotThrow(() -> ((ShareGroup)shareGroup).validateDeleteGroup());
        ShareGroupMember member1 = new ShareGroupMember.Builder("member1").setMemberEpoch(1).setPreviousMemberEpoch(0).build();
        shareGroup.updateMember(member1);
        Assertions.assertEquals((Object)ShareGroup.ShareGroupState.STABLE, (Object)shareGroup.state());
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ShareGroup)shareGroup).validateDeleteGroup());
        shareGroup.setGroupEpoch(1);
        Assertions.assertEquals((Object)ShareGroup.ShareGroupState.STABLE, (Object)shareGroup.state());
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ShareGroup)shareGroup).validateDeleteGroup());
        shareGroup.setTargetAssignmentEpoch(1);
        Assertions.assertEquals((Object)ShareGroup.ShareGroupState.STABLE, (Object)shareGroup.state());
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ShareGroup)shareGroup).validateDeleteGroup());
    }

    @Test
    public void testIsSubscribedToTopic() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        MetadataImage image = new MetadataImageBuilder().addTopic(fooTopicId, "foo", 1).addTopic(barTopicId, "bar", 2).addRacks().build();
        ShareGroupMember member1 = new ShareGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build();
        ShareGroupMember member2 = new ShareGroupMember.Builder("member2").setSubscribedTopicNames(Collections.singletonList("bar")).build();
        ShareGroup shareGroup = this.createShareGroup("group-foo");
        shareGroup.updateMember(member1);
        shareGroup.updateMember(member2);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2))}), (Object)shareGroup.computeSubscriptionMetadata(shareGroup.computeSubscribedTopicNames(null, null), image.topics(), image.cluster()));
        Assertions.assertTrue((boolean)shareGroup.isSubscribedToTopic("foo"));
        Assertions.assertTrue((boolean)shareGroup.isSubscribedToTopic("bar"));
        shareGroup.removeMember("member1");
        Assertions.assertFalse((boolean)shareGroup.isSubscribedToTopic("foo"));
        shareGroup.removeMember("member2");
        Assertions.assertFalse((boolean)shareGroup.isSubscribedToTopic("bar"));
    }

    @Test
    public void testAsDescribedGroup() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ShareGroup shareGroup = new ShareGroup(snapshotRegistry, "group-id-1");
        snapshotRegistry.idempotentCreateSnapshot(0L);
        Assertions.assertEquals((Object)ShareGroup.ShareGroupState.EMPTY.toString(), (Object)shareGroup.stateAsString(0L));
        shareGroup.updateMember(new ShareGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build());
        shareGroup.updateMember(new ShareGroupMember.Builder("member2").build());
        snapshotRegistry.idempotentCreateSnapshot(1L);
        ShareGroupDescribeResponseData.DescribedGroup expected = new ShareGroupDescribeResponseData.DescribedGroup().setGroupId("group-id-1").setGroupState(ShareGroup.ShareGroupState.STABLE.toString()).setGroupEpoch(0).setAssignmentEpoch(0).setAssignorName("assignorName").setMembers(Arrays.asList(new ShareGroupDescribeResponseData.Member().setMemberId("member1").setSubscribedTopicNames(Collections.singletonList("foo")), new ShareGroupDescribeResponseData.Member().setMemberId("member2")));
        ShareGroupDescribeResponseData.DescribedGroup actual = shareGroup.asDescribedGroup(1L, "assignorName", new MetadataImageBuilder().build().topics());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testIsInStatesCaseInsensitive() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ShareGroup shareGroup = new ShareGroup(snapshotRegistry, "group-foo");
        snapshotRegistry.idempotentCreateSnapshot(0L);
        Assertions.assertTrue((boolean)shareGroup.isInStates(Collections.singleton("empty"), 0L));
        Assertions.assertFalse((boolean)shareGroup.isInStates(Collections.singleton("Empty"), 0L));
        shareGroup.updateMember(new ShareGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build());
        snapshotRegistry.idempotentCreateSnapshot(1L);
        Assertions.assertTrue((boolean)shareGroup.isInStates(Collections.singleton("empty"), 0L));
        Assertions.assertTrue((boolean)shareGroup.isInStates(Collections.singleton("stable"), 1L));
        Assertions.assertFalse((boolean)shareGroup.isInStates(Collections.singleton("empty"), 1L));
    }

    private ShareGroup createShareGroup(String groupId) {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        return new ShareGroup(snapshotRegistry, groupId);
    }
}

