/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.share;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShareGroupConfigTest {
    @Test
    public void testConfigs() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("group.share.enable", true);
        configs.put("group.share.partition.max.record.locks", 200);
        configs.put("group.share.delivery.count.limit", 5);
        configs.put("group.share.max.groups", (short)10);
        configs.put("group.share.record.lock.duration.ms", 30000);
        configs.put("group.share.min.record.lock.duration.ms", 15000);
        configs.put("group.share.max.record.lock.duration.ms", 60000);
        configs.put("share.fetch.purgatory.purge.interval.requests", 1000);
        ShareGroupConfig config = ShareGroupConfigTest.createConfig(configs);
        Assertions.assertTrue((boolean)config.isShareGroupEnabled());
        Assertions.assertEquals((int)200, (int)config.shareGroupPartitionMaxRecordLocks());
        Assertions.assertEquals((int)5, (int)config.shareGroupDeliveryCountLimit());
        Assertions.assertEquals((int)10, (int)config.shareGroupMaxGroups());
        Assertions.assertEquals((int)30000, (int)config.shareGroupRecordLockDurationMs());
        Assertions.assertEquals((int)15000, (int)config.shareGroupMinRecordLockDurationMs());
        Assertions.assertEquals((int)60000, (int)config.shareGroupMaxRecordLockDurationMs());
        Assertions.assertEquals((int)1000, (int)config.shareFetchPurgatoryPurgeIntervalRequests());
    }

    @Test
    public void testInvalidConfigs() {
        HashMap<String, Number> configs = new HashMap<String, Number>();
        configs.put("group.share.max.record.lock.duration.ms", 60000);
        configs.put("group.share.min.record.lock.duration.ms", 15000);
        configs.put("group.share.record.lock.duration.ms", 10000);
        Assertions.assertEquals((Object)"group.share.record.lock.duration.ms must be greater than or equal to group.share.min.record.lock.duration.ms", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.share.max.record.lock.duration.ms", 50000);
        configs.put("group.share.min.record.lock.duration.ms", 15000);
        configs.put("group.share.record.lock.duration.ms", 60000);
        Assertions.assertEquals((Object)"group.share.max.record.lock.duration.ms must be greater than or equal to group.share.record.lock.duration.ms", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.share.delivery.count.limit", 1);
        Assertions.assertEquals((Object)"Invalid value 1 for configuration group.share.delivery.count.limit: Value must be at least 2", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> ShareGroupConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.share.delivery.count.limit", 11);
        Assertions.assertEquals((Object)"Invalid value 11 for configuration group.share.delivery.count.limit: Value must be no more than 10", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> ShareGroupConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.share.max.groups", 10);
        Assertions.assertEquals((Object)"Invalid value 10 for configuration group.share.max.groups: Expected value to be a 16-bit integer (short), but it was a java.lang.Integer", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> ShareGroupConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.share.max.groups", (short)0);
        Assertions.assertEquals((Object)"Invalid value 0 for configuration group.share.max.groups: Value must be at least 1", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> ShareGroupConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.share.max.groups", (short)110);
        Assertions.assertEquals((Object)"Invalid value 110 for configuration group.share.max.groups: Value must be no more than 100", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> ShareGroupConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.share.partition.max.record.locks", 50);
        Assertions.assertEquals((Object)"Invalid value 50 for configuration group.share.partition.max.record.locks: Value must be at least 100", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> ShareGroupConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.share.partition.max.record.locks", 20000);
        Assertions.assertEquals((Object)"Invalid value 20000 for configuration group.share.partition.max.record.locks: Value must be no more than 10000", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> ShareGroupConfigTest.createConfig(configs))).getMessage());
    }

    public static ShareGroupConfig createShareGroupConfig(boolean shareGroupEnable, int shareGroupPartitionMaxRecordLocks, int shareGroupDeliveryCountLimit, short shareGroupsMaxGroups, int shareGroupRecordLockDurationsMs, int shareGroupMinRecordLockDurationMs, int shareGroupMaxRecordLockDurationMs) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("group.share.enable", shareGroupEnable);
        configs.put("group.share.partition.max.record.locks", shareGroupPartitionMaxRecordLocks);
        configs.put("group.share.delivery.count.limit", shareGroupDeliveryCountLimit);
        configs.put("group.share.max.groups", shareGroupsMaxGroups);
        configs.put("group.share.record.lock.duration.ms", shareGroupRecordLockDurationsMs);
        configs.put("group.share.min.record.lock.duration.ms", shareGroupMinRecordLockDurationMs);
        configs.put("group.share.max.record.lock.duration.ms", shareGroupMaxRecordLockDurationMs);
        configs.put("group.coordinator.rebalance.protocols", "classic,consumer,share");
        configs.put("group.coordinator.new.enable", true);
        configs.put("group.coordinator.threads", 1);
        configs.put("group.coordinator.append.linger.ms", 10);
        return ShareGroupConfigTest.createConfig(configs);
    }

    private static ShareGroupConfig createConfig(Map<String, Object> configs) {
        return new ShareGroupConfig(new AbstractConfig(Utils.mergeConfigs(Arrays.asList(ShareGroupConfig.CONFIG_DEF, GroupCoordinatorConfig.GROUP_COORDINATOR_CONFIG_DEF)), configs, false));
    }
}

