/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.share;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;

public class ShareGroupBuilder {
    private final String groupId;
    private final int groupEpoch;
    private int assignmentEpoch;
    private final Map<String, ShareGroupMember> members = new HashMap<String, ShareGroupMember>();
    private final Map<String, Assignment> assignments = new HashMap<String, Assignment>();
    private Map<String, TopicMetadata> subscriptionMetadata;

    public ShareGroupBuilder(String groupId, int groupEpoch) {
        this.groupId = groupId;
        this.groupEpoch = groupEpoch;
        this.assignmentEpoch = 0;
    }

    public ShareGroupBuilder withMember(ShareGroupMember member) {
        this.members.put(member.memberId(), member);
        return this;
    }

    public ShareGroupBuilder withSubscriptionMetadata(Map<String, TopicMetadata> subscriptionMetadata) {
        this.subscriptionMetadata = subscriptionMetadata;
        return this;
    }

    public ShareGroupBuilder withAssignment(String memberId, Map<Uuid, Set<Integer>> assignment) {
        this.assignments.put(memberId, new Assignment(assignment));
        return this;
    }

    public ShareGroupBuilder withAssignmentEpoch(int assignmentEpoch) {
        this.assignmentEpoch = assignmentEpoch;
        return this;
    }

    public List<CoordinatorRecord> build(TopicsImage topicsImage) {
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        this.members.forEach((memberId, member) -> records.add(GroupCoordinatorRecordHelpers.newShareGroupMemberSubscriptionRecord((String)this.groupId, (ShareGroupMember)member)));
        if (this.subscriptionMetadata == null) {
            this.subscriptionMetadata = new HashMap<String, TopicMetadata>();
            this.members.forEach((memberId, member) -> member.subscribedTopicNames().forEach(topicName -> {
                TopicImage topicImage = topicsImage.getTopic(topicName);
                if (topicImage != null) {
                    this.subscriptionMetadata.put((String)topicName, new TopicMetadata(topicImage.id(), topicImage.name(), topicImage.partitions().size()));
                }
            }));
        }
        if (!this.subscriptionMetadata.isEmpty()) {
            records.add(GroupCoordinatorRecordHelpers.newShareGroupSubscriptionMetadataRecord((String)this.groupId, this.subscriptionMetadata));
        }
        records.add(GroupCoordinatorRecordHelpers.newShareGroupEpochRecord((String)this.groupId, (int)this.groupEpoch));
        this.assignments.forEach((memberId, assignment) -> records.add(GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentRecord((String)this.groupId, (String)memberId, (Map)assignment.partitions())));
        records.add(GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentEpochRecord((String)this.groupId, (int)this.assignmentEpoch));
        this.members.forEach((memberId, member) -> records.add(GroupCoordinatorRecordHelpers.newShareGroupCurrentAssignmentRecord((String)this.groupId, (ShareGroupMember)member)));
        return records;
    }
}

