/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.share;

import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupAssignmentBuilder;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShareGroupAssignmentBuilderTest {
    @Test
    public void testStableToStable() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ShareGroupMember member = new ShareGroupMember.Builder("member").setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6))).build();
        ShareGroupMember updatedMember = new ShareGroupAssignmentBuilder(member).withTargetAssignment(11, new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6)))).build();
        Assertions.assertEquals((Object)new ShareGroupMember.Builder("member").setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6))).build(), (Object)updatedMember);
    }

    @Test
    public void testStableToStableWithNewPartitions() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ShareGroupMember member = new ShareGroupMember.Builder("member").setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6))).build();
        ShareGroupMember updatedMember = new ShareGroupAssignmentBuilder(member).withTargetAssignment(11, new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3, 4), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6, 7)))).build();
        Assertions.assertEquals((Object)new ShareGroupMember.Builder("member").setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3, 4), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6, 7))).build(), (Object)updatedMember);
    }
}

