/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.consumer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.StaleMemberEpochException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.Assertions;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.OffsetExpirationConditionImpl;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.SubscriptionCount;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ResolvedRegularExpression;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.Mockito;

public class ConsumerGroupTest {
    private ConsumerGroup createConsumerGroup(String groupId) {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        return new ConsumerGroup(Time.SYSTEM, snapshotRegistry, groupId, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
    }

    @Test
    public void testGetOrCreateMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = consumerGroup.getOrMaybeCreateMember("member-id", true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"member-id", (Object)member.memberId());
        consumerGroup.updateMember(member);
        member = consumerGroup.getOrMaybeCreateMember("member-id", false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"member-id", (Object)member.memberId());
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> consumerGroup.getOrMaybeCreateMember("does-not-exist", false));
    }

    @Test
    public void testUpdateMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = consumerGroup.getOrMaybeCreateMember("member", true);
        member = new ConsumerGroupMember.Builder(member).setSubscribedTopicNames(Arrays.asList("foo", "bar")).build();
        consumerGroup.updateMember(member);
        org.junit.jupiter.api.Assertions.assertEquals((Object)member, (Object)consumerGroup.getOrMaybeCreateMember("member", false));
    }

    @Test
    public void testNoStaticMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        consumerGroup.getOrMaybeCreateMember("member", true);
        org.junit.jupiter.api.Assertions.assertNull((Object)consumerGroup.staticMember("instance-id"));
    }

    @Test
    public void testGetStaticMemberByInstanceId() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = consumerGroup.getOrMaybeCreateMember("member", true);
        member = new ConsumerGroupMember.Builder(member).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setInstanceId("instance").build();
        consumerGroup.updateMember(member);
        org.junit.jupiter.api.Assertions.assertEquals((Object)member, (Object)consumerGroup.staticMember("instance"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)member, (Object)consumerGroup.getOrMaybeCreateMember("member", false));
        org.junit.jupiter.api.Assertions.assertEquals((Object)member.memberId(), (Object)consumerGroup.staticMemberId("instance"));
    }

    @Test
    public void testRemoveMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = consumerGroup.getOrMaybeCreateMember("member", true);
        consumerGroup.updateMember(member);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.hasMember("member"));
        consumerGroup.removeMember("member");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.hasMember("member"));
    }

    @Test
    public void testRemoveStaticMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setInstanceId("instance").build();
        consumerGroup.updateMember(member);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.hasMember("member"));
        consumerGroup.removeMember("member");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.hasMember("member"));
        org.junit.jupiter.api.Assertions.assertNull((Object)consumerGroup.staticMember("instance"));
        org.junit.jupiter.api.Assertions.assertNull((Object)consumerGroup.staticMemberId("instance"));
    }

    @Test
    public void testUpdatingMemberUpdatesPartitionEpoch() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        Uuid zarTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))).build();
        consumerGroup.updateMember(member);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 7));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 8));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 9));
        member = new ConsumerGroupMember.Builder(member).setMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(zarTopicId, 4, 5, 6))).build();
        consumerGroup.updateMember(member);
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(barTopicId, 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(barTopicId, 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(barTopicId, 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 7));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 8));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 9));
    }

    @Test
    public void testUpdatingMemberUpdatesPartitionEpochWhenPartitionIsReassignedBeforeBeingRevoked() {
        Uuid fooTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setAssignedPartitions(Collections.emptyMap()).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        consumerGroup.updateMember(member);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 1));
        member = new ConsumerGroupMember.Builder(member).setMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).setPartitionsPendingRevocation(Collections.emptyMap()).build();
        consumerGroup.updateMember(member);
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 1));
    }

    @Test
    public void testUpdatingMemberUpdatesPartitionEpochWhenPartitionIsNotReleased() {
        Uuid fooTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember m1 = new ConsumerGroupMember.Builder("m1").setMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        consumerGroup.updateMember(m1);
        ConsumerGroupMember m2 = new ConsumerGroupMember.Builder("m2").setMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> consumerGroup.updateMember(m2));
    }

    @Test
    public void testRemovePartitionEpochs() {
        Uuid fooTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> consumerGroup.removePartitionEpochs(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1)), 10));
        ConsumerGroupMember m1 = new ConsumerGroupMember.Builder("m1").setMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        consumerGroup.updateMember(m1);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> consumerGroup.removePartitionEpochs(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1)), 11));
    }

    @Test
    public void testAddPartitionEpochs() {
        Uuid fooTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        consumerGroup.addPartitionEpochs(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1)), 10);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> consumerGroup.addPartitionEpochs(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1)), 11));
    }

    @Test
    public void testDeletingMemberRemovesPartitionEpoch() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        Uuid zarTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))).build();
        consumerGroup.updateMember(member);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 7));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 8));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 9));
        consumerGroup.removeMember(member.memberId());
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(barTopicId, 1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(barTopicId, 2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(barTopicId, 3));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 4));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 5));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 6));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 7));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 8));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 9));
    }

    @Test
    public void testWaitingOnUnreleasedPartition() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        Uuid zarTopicId = Uuid.randomUuid();
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        consumerGroup.updateTargetAssignment(memberId1, new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 7, 8, 9))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(10).setState(MemberState.UNRELEASED_PARTITIONS).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))).build();
        consumerGroup.updateMember(member1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.waitingOnUnreleasedPartition(member1));
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(10).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(zarTopicId, 7))).build();
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.waitingOnUnreleasedPartition(member1));
    }

    @Test
    public void testGroupState() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)consumerGroup.state());
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).build();
        consumerGroup.updateMember(member1);
        consumerGroup.setGroupEpoch(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.STABLE, (Object)member1.state());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)consumerGroup.state());
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).build();
        consumerGroup.updateMember(member2);
        consumerGroup.setGroupEpoch(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.STABLE, (Object)member2.state());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)consumerGroup.state());
        consumerGroup.setTargetAssignmentEpoch(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)consumerGroup.state());
        member1 = new ConsumerGroupMember.Builder(member1).setState(MemberState.STABLE).setMemberEpoch(2).setPreviousMemberEpoch(1).build();
        consumerGroup.updateMember(member1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.STABLE, (Object)member1.state());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)consumerGroup.state());
        member2 = new ConsumerGroupMember.Builder(member2).setState(MemberState.UNREVOKED_PARTITIONS).setMemberEpoch(2).setPreviousMemberEpoch(1).build();
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.UNREVOKED_PARTITIONS, (Object)member2.state());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)consumerGroup.state());
        member2 = new ConsumerGroupMember.Builder(member2).setState(MemberState.STABLE).setMemberEpoch(2).setPreviousMemberEpoch(1).build();
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.STABLE, (Object)member2.state());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)consumerGroup.state());
        consumerGroup.removeMember("member1");
        consumerGroup.removeMember("member2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)consumerGroup.state());
    }

    @Test
    public void testGroupTypeFromString() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)Group.GroupType.parse((String)"classic"), (Object)Group.GroupType.CLASSIC);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Group.GroupType.parse((String)"Consumer"), (Object)Group.GroupType.CONSUMER);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Group.GroupType.parse((String)"Invalid"), (Object)Group.GroupType.UNKNOWN);
    }

    @Test
    public void testPreferredServerAssignor() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setServerAssignorName("range").build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setServerAssignorName("range").build();
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member3").setServerAssignorName("uniform").build();
        org.junit.jupiter.api.Assertions.assertEquals(Optional.empty(), (Object)consumerGroup.preferredServerAssignor());
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("range"), (Object)consumerGroup.computePreferredServerAssignor(null, member1));
        consumerGroup.updateMember(member1);
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("range"), (Object)consumerGroup.preferredServerAssignor());
        org.junit.jupiter.api.Assertions.assertEquals(Optional.empty(), (Object)consumerGroup.computePreferredServerAssignor(member1, null));
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("range"), (Object)consumerGroup.computePreferredServerAssignor(null, member2));
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("range"), (Object)consumerGroup.preferredServerAssignor());
        consumerGroup.updateMember(member3);
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("range"), (Object)consumerGroup.preferredServerAssignor());
        ConsumerGroupMember updatedMember1 = new ConsumerGroupMember.Builder("member1").setServerAssignorName(null).build();
        ConsumerGroupMember updatedMember2 = new ConsumerGroupMember.Builder("member2").setServerAssignorName(null).build();
        ConsumerGroupMember updatedMember3 = new ConsumerGroupMember.Builder("member3").setServerAssignorName(null).build();
        Optional assignor = consumerGroup.computePreferredServerAssignor(member1, updatedMember1);
        org.junit.jupiter.api.Assertions.assertTrue((assignor.equals(Optional.of("range")) || assignor.equals(Optional.of("uniform")) ? 1 : 0) != 0);
        consumerGroup.updateMember(updatedMember1);
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("uniform"), (Object)consumerGroup.computePreferredServerAssignor(member2, updatedMember2));
        consumerGroup.updateMember(updatedMember2);
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("uniform"), (Object)consumerGroup.preferredServerAssignor());
        org.junit.jupiter.api.Assertions.assertEquals(Optional.empty(), (Object)consumerGroup.computePreferredServerAssignor(member3, updatedMember3));
        consumerGroup.updateMember(updatedMember3);
        org.junit.jupiter.api.Assertions.assertEquals(Optional.empty(), (Object)consumerGroup.preferredServerAssignor());
    }

    @Test
    public void testUpdateSubscriptionMetadata() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        Uuid zarTopicId = Uuid.randomUuid();
        MetadataImage image = new MetadataImageBuilder().addTopic(fooTopicId, "foo", 1).addTopic(barTopicId, "bar", 2).addTopic(zarTopicId, "zar", 3).addRacks().build();
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setSubscribedTopicNames(Collections.singletonList("bar")).build();
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member3").setSubscribedTopicNames(Collections.singletonList("zar")).build();
        ConsumerGroup consumerGroup = this.createConsumerGroup("group-foo");
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyMap(), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(null, null), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(null, member1), image.topics(), image.cluster()));
        consumerGroup.updateMember(member1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(null, null), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyMap(), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(member1, null), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(null, member2), image.topics(), image.cluster()));
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(null, null), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(member2, null), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(member1, null), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2)), Utils.mkEntry((Object)"zar", (Object)new TopicMetadata(zarTopicId, "zar", 3))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(null, member3), image.topics(), image.cluster()));
        consumerGroup.updateMember(member3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2)), Utils.mkEntry((Object)"zar", (Object)new TopicMetadata(zarTopicId, "zar", 3))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(null, null), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyMap(), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(new HashSet<ConsumerGroupMember>(Arrays.asList(member1, member2, member3))), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(new HashSet<ConsumerGroupMember>(Arrays.asList(member2, member3))), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2)), Utils.mkEntry((Object)"zar", (Object)new TopicMetadata(zarTopicId, "zar", 3))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(Collections.singleton(member1)), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2)), Utils.mkEntry((Object)"zar", (Object)new TopicMetadata(zarTopicId, "zar", 3))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(Collections.emptySet()), image.topics(), image.cluster()));
    }

    @Test
    public void testUpdateSubscribedTopicNamesAndSubscriptionType() {
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setSubscribedTopicNames(Arrays.asList("bar", "foo")).build();
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member3").setSubscribedTopicNames(Arrays.asList("bar", "foo")).build();
        ConsumerGroup consumerGroup = this.createConsumerGroup("group-foo");
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyMap(), (Object)consumerGroup.subscribedTopicNames());
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HOMOGENEOUS, (Object)consumerGroup.subscriptionType());
        consumerGroup.updateMember(member1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HOMOGENEOUS, (Object)consumerGroup.subscriptionType());
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HETEROGENEOUS, (Object)consumerGroup.subscriptionType());
        consumerGroup.updateMember(member3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HETEROGENEOUS, (Object)consumerGroup.subscriptionType());
        consumerGroup.removeMember(member1.memberId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HOMOGENEOUS, (Object)consumerGroup.subscriptionType());
        ConsumerGroupMember member4 = new ConsumerGroupMember.Builder("member2").setSubscribedTopicNames(Arrays.asList("bar", "foo", "zar")).build();
        consumerGroup.updateMember(member4);
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HETEROGENEOUS, (Object)consumerGroup.subscriptionType());
    }

    @Test
    public void testUpdateInvertedAssignment() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        GroupCoordinatorMetricsShard metricsShard = (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class);
        ConsumerGroup consumerGroup = new ConsumerGroup(Time.SYSTEM, snapshotRegistry, "test-group", metricsShard);
        Uuid topicId = Uuid.randomUuid();
        String memberId1 = "member1";
        String memberId2 = "member2";
        Assignment initialAssignment = new Assignment(Collections.singletonMap(topicId, new HashSet<Integer>(Collections.singletonList(0))));
        consumerGroup.updateTargetAssignment(memberId1, initialAssignment);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)memberId1)}))}), (Object)consumerGroup.invertedTargetAssignment());
        Assignment newAssignment = new Assignment(Collections.singletonMap(topicId, new HashSet<Integer>(Collections.singletonList(1))));
        consumerGroup.updateTargetAssignment(memberId1, newAssignment);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)1, (Object)memberId1)}))}), (Object)consumerGroup.invertedTargetAssignment());
        Assignment newAssignment2 = new Assignment(Collections.singletonMap(topicId, new HashSet<Integer>(Collections.singletonList(1))));
        consumerGroup.updateTargetAssignment(memberId2, newAssignment2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)1, (Object)memberId2)}))}), (Object)consumerGroup.invertedTargetAssignment());
        Assignment newAssignment1 = new Assignment(Collections.singletonMap(topicId, new HashSet<Integer>(Collections.singletonList(0))));
        consumerGroup.updateTargetAssignment(memberId1, newAssignment1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)memberId1), Utils.mkEntry((Object)1, (Object)memberId2)}))}), (Object)consumerGroup.invertedTargetAssignment());
        consumerGroup.removeTargetAssignment(memberId1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)1, (Object)memberId2)}))}), (Object)consumerGroup.invertedTargetAssignment());
    }

    @Test
    public void testMetadataRefreshDeadline() {
        MockTime time = new MockTime();
        ConsumerGroup group = this.createConsumerGroup("group-foo");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.groupEpoch());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMetadataExpired(time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)group.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.metadataRefreshDeadline().epoch);
        group.setMetadataRefreshDeadline(time.milliseconds() + 1000L, group.groupEpoch());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)group.hasMetadataExpired(time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)(time.milliseconds() + 1000L), (long)group.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)group.groupEpoch(), (int)group.metadataRefreshDeadline().epoch);
        time.sleep(1001L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMetadataExpired(time.milliseconds()));
        group.setMetadataRefreshDeadline(time.milliseconds() + 1000L, group.groupEpoch() + 1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMetadataExpired(time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)(time.milliseconds() + 1000L), (long)group.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)(group.groupEpoch() + 1), (int)group.metadataRefreshDeadline().epoch);
        group.setGroupEpoch(group.groupEpoch() + 1);
        group.setMetadataRefreshDeadline(time.milliseconds() + 1000L, group.groupEpoch());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)group.hasMetadataExpired(time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)(time.milliseconds() + 1000L), (long)group.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)group.groupEpoch(), (int)group.metadataRefreshDeadline().epoch);
        group.requestMetadataRefresh();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMetadataExpired(time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)group.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.metadataRefreshDeadline().epoch);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.TXN_OFFSET_COMMIT)
    public void testValidateTransactionalOffsetCommit(short version) {
        boolean isTransactional = true;
        ConsumerGroup group = this.createConsumerGroup("group-foo");
        group.validateOffsetCommit("", "", -1, isTransactional, version);
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetCommit("member-id", null, 0, isTransactional, version));
        group.updateMember(new ConsumerGroupMember.Builder("member-id").build());
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetCommit("", "", -1, isTransactional, version));
        org.junit.jupiter.api.Assertions.assertThrows(StaleMemberEpochException.class, () -> group.validateOffsetCommit("member-id", "", 10, isTransactional, version));
        group.validateOffsetCommit("member-id", "", 0, isTransactional, version);
        group.validateOffsetCommit("", null, -1, isTransactional, version);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_COMMIT)
    public void testValidateOffsetCommit(short version) {
        boolean isTransactional = false;
        ConsumerGroup group = this.createConsumerGroup("group-foo");
        group.validateOffsetCommit("", "", -1, isTransactional, version);
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetCommit("member-id", null, 0, isTransactional, version));
        group.updateMember(new ConsumerGroupMember.Builder("new-protocol-member-id").build());
        group.updateMember(new ConsumerGroupMember.Builder("old-protocol-member-id").setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata()).build());
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetCommit("", "", -1, isTransactional, version));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetCommit("", null, -1, isTransactional, version));
        if (version >= 9) {
            org.junit.jupiter.api.Assertions.assertThrows(StaleMemberEpochException.class, () -> group.validateOffsetCommit("new-protocol-member-id", "", 10, isTransactional, version));
        } else {
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedVersionException.class, () -> group.validateOffsetCommit("new-protocol-member-id", "", 10, isTransactional, version));
        }
        org.junit.jupiter.api.Assertions.assertThrows(IllegalGenerationException.class, () -> group.validateOffsetCommit("old-protocol-member-id", "", 10, isTransactional, version));
        if (version >= 9) {
            group.validateOffsetCommit("new-protocol-member-id", "", 0, isTransactional, version);
        } else {
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedVersionException.class, () -> group.validateOffsetCommit("new-protocol-member-id", "", 0, isTransactional, version));
        }
    }

    @Test
    public void testAsListedGroup() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        GroupCoordinatorMetricsShard metricsShard = new GroupCoordinatorMetricsShard(snapshotRegistry, Collections.emptyMap(), new TopicPartition("__consumer_offsets", 0));
        ConsumerGroup group = new ConsumerGroup(Time.SYSTEM, snapshotRegistry, "group-foo", metricsShard);
        snapshotRegistry.idempotentCreateSnapshot(0L);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY.toString(), (Object)group.stateAsString(0L));
        group.updateMember(new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build());
        snapshotRegistry.idempotentCreateSnapshot(1L);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY.toString(), (Object)group.stateAsString(0L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE.toString(), (Object)group.stateAsString(1L));
    }

    @Test
    public void testValidateOffsetFetch() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConsumerGroup group = new ConsumerGroup(Time.SYSTEM, snapshotRegistry, "group-foo", (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        group.validateOffsetFetch(null, -1, Long.MAX_VALUE);
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetFetch("member-id", 0, Long.MAX_VALUE));
        snapshotRegistry.idempotentCreateSnapshot(0L);
        group.updateMember(new ConsumerGroupMember.Builder("member-id").build());
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetFetch("member-id", 0, 0L));
        org.junit.jupiter.api.Assertions.assertThrows(StaleMemberEpochException.class, () -> group.validateOffsetFetch("member-id", 10, Long.MAX_VALUE));
        group.validateOffsetFetch("member-id", 0, Long.MAX_VALUE);
    }

    @Test
    public void testValidateDeleteGroup() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)consumerGroup.state());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((ConsumerGroup)consumerGroup).validateDeleteGroup());
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setMemberEpoch(1).setPreviousMemberEpoch(0).build();
        consumerGroup.updateMember(member1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)consumerGroup.state());
        org.junit.jupiter.api.Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ConsumerGroup)consumerGroup).validateDeleteGroup());
        consumerGroup.setGroupEpoch(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)consumerGroup.state());
        org.junit.jupiter.api.Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ConsumerGroup)consumerGroup).validateDeleteGroup());
        consumerGroup.setTargetAssignmentEpoch(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)consumerGroup.state());
        org.junit.jupiter.api.Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ConsumerGroup)consumerGroup).validateDeleteGroup());
    }

    @Test
    public void testOffsetExpirationCondition() {
        long currentTimestamp = 30000L;
        long commitTimestamp = 20000L;
        long offsetsRetentionMs = 10000L;
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(15000L, OptionalInt.empty(), "", commitTimestamp, OptionalLong.empty());
        ConsumerGroup group = new ConsumerGroup(Time.SYSTEM, new SnapshotRegistry(new LogContext()), "group-id", (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        Optional offsetExpirationCondition = group.offsetExpirationCondition();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)offsetExpirationCondition.isPresent());
        OffsetExpirationConditionImpl condition = (OffsetExpirationConditionImpl)offsetExpirationCondition.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)commitTimestamp, (Long)((Long)condition.baseTimestamp().apply(offsetAndMetadata)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)condition.isOffsetExpired(offsetAndMetadata, currentTimestamp, offsetsRetentionMs));
    }

    @Test
    public void testIsSubscribedToTopic() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        MetadataImage image = new MetadataImageBuilder().addTopic(fooTopicId, "foo", 1).addTopic(barTopicId, "bar", 2).addRacks().build();
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setSubscribedTopicNames(Collections.singletonList("bar")).build();
        ConsumerGroup consumerGroup = this.createConsumerGroup("group-foo");
        consumerGroup.updateMember(member1);
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1)), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2))}), (Object)consumerGroup.computeSubscriptionMetadata(consumerGroup.computeSubscribedTopicNames(null, null), image.topics(), image.cluster()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.isSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.isSubscribedToTopic("bar"));
        consumerGroup.removeMember("member1");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.isSubscribedToTopic("foo"));
        consumerGroup.removeMember("member2");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.isSubscribedToTopic("bar"));
    }

    @Test
    public void testAsDescribedGroup() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConsumerGroup group = new ConsumerGroup(Time.SYSTEM, snapshotRegistry, "group-id-1", (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        snapshotRegistry.idempotentCreateSnapshot(0L);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY.toString(), (Object)group.stateAsString(0L));
        group.updateMember(new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).setServerAssignorName("assignorName").build());
        group.updateMember(new ConsumerGroupMember.Builder("member2").build());
        snapshotRegistry.idempotentCreateSnapshot(1L);
        ConsumerGroupDescribeResponseData.DescribedGroup expected = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id-1").setGroupState(ConsumerGroup.ConsumerGroupState.STABLE.toString()).setGroupEpoch(0).setAssignmentEpoch(0).setAssignorName("assignorName").setMembers(Arrays.asList(new ConsumerGroupDescribeResponseData.Member().setMemberId("member1").setSubscribedTopicNames(Collections.singletonList("foo")).setSubscribedTopicRegex("").setMemberType((byte)1), new ConsumerGroupDescribeResponseData.Member().setMemberId("member2").setSubscribedTopicRegex("").setMemberType((byte)1)));
        ConsumerGroupDescribeResponseData.DescribedGroup actual = group.asDescribedGroup(1L, "", new MetadataImageBuilder().build().topics());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testIsInStatesCaseInsensitive() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        GroupCoordinatorMetricsShard metricsShard = new GroupCoordinatorMetricsShard(snapshotRegistry, Collections.emptyMap(), new TopicPartition("__consumer_offsets", 0));
        ConsumerGroup group = new ConsumerGroup(Time.SYSTEM, snapshotRegistry, "group-foo", metricsShard);
        snapshotRegistry.idempotentCreateSnapshot(0L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInStates(Collections.singleton("empty"), 0L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)group.isInStates(Collections.singleton("Empty"), 0L));
        group.updateMember(new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build());
        snapshotRegistry.idempotentCreateSnapshot(1L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInStates(Collections.singleton("empty"), 0L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInStates(Collections.singleton("stable"), 1L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)group.isInStates(Collections.singleton("empty"), 1L));
    }

    @Test
    public void testClassicMembersSupportedProtocols() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol> rangeProtocol = new ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol>();
        rangeProtocol.add(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(new byte[0]));
        ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol> roundRobinAndRangeProtocols = new ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol>();
        roundRobinAndRangeProtocols.add(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("roundrobin").setMetadata(new byte[0]));
        roundRobinAndRangeProtocols.add(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(new byte[0]));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member-1").setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(rangeProtocol)).build();
        consumerGroup.updateMember(member1);
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member-2").setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(roundRobinAndRangeProtocols)).build();
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (Integer)((Integer)consumerGroup.classicMembersSupportedProtocols().get("range")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (Integer)((Integer)consumerGroup.classicMembersSupportedProtocols().get("roundrobin")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.supportsClassicProtocols("consumer", new HashSet<String>(Arrays.asList("range", "sticky"))));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.supportsClassicProtocols("consumer", new HashSet<String>(Arrays.asList("sticky", "roundrobin"))));
        member2 = new ConsumerGroupMember.Builder(member2).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(rangeProtocol)).build();
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (Integer)((Integer)consumerGroup.classicMembersSupportedProtocols().get("range")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.classicMembersSupportedProtocols().containsKey("roundrobin"));
        member1 = new ConsumerGroupMember.Builder(member1).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(roundRobinAndRangeProtocols)).build();
        consumerGroup.updateMember(member1);
        member2 = new ConsumerGroupMember.Builder(member2).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(roundRobinAndRangeProtocols)).build();
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (Integer)((Integer)consumerGroup.classicMembersSupportedProtocols().get("range")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (Integer)((Integer)consumerGroup.classicMembersSupportedProtocols().get("roundrobin")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.supportsClassicProtocols("consumer", new HashSet<String>(Arrays.asList("sticky", "roundrobin"))));
    }

    @Test
    public void testNumClassicProtocolMembers() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = new ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol>();
        protocols.add(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(new byte[0]));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member-1").setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(protocols)).build();
        consumerGroup.updateMember(member1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)consumerGroup.numClassicProtocolMembers());
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member-2").build();
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)consumerGroup.numClassicProtocolMembers());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.allMembersUseClassicProtocolExcept(member1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.allMembersUseClassicProtocolExcept(member2));
        consumerGroup.removeMember(member1.memberId());
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member-3").build();
        consumerGroup.updateMember(member3);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numClassicProtocolMembers());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.allMembersUseClassicProtocolExcept(member2));
        consumerGroup.removeMember(member2.memberId());
        member2 = new ConsumerGroupMember.Builder("member-2").setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(protocols)).build();
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)consumerGroup.numClassicProtocolMembers());
    }

    @ParameterizedTest
    @CsvSource(value={"5, 5, 0, 0, false", "5, 5, 0, 4, false", "5, 5, 1, 4, false", "5, 5, 0, 5, true", "5, 5, 1, 5, true", "5, 5, 5, 5, true", "5, 0, 0, 0, true", "5, 0, 1, 0, true"})
    public void testAllMembersUseClassicProtocolExcept(int numClassicProtocolMembers, int numConsumerProtocolMembers, int numRemovedClassicProtocolMembers, int numRemovedConsumerProtocolMembers, boolean expectedResult) {
        int i;
        ConsumerGroupMember member;
        int i2;
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = new ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol>();
        protocols.add(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(new byte[0]));
        ArrayList<ConsumerGroupMember> classicProtocolMembers = new ArrayList<ConsumerGroupMember>();
        ArrayList<ConsumerGroupMember> consumerProtocolMembers = new ArrayList<ConsumerGroupMember>();
        for (i2 = 0; i2 < numClassicProtocolMembers; ++i2) {
            member = new ConsumerGroupMember.Builder("classic-member-" + i2).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(protocols)).build();
            classicProtocolMembers.add(member);
            consumerGroup.updateMember(member);
        }
        for (i2 = 0; i2 < numConsumerProtocolMembers; ++i2) {
            member = new ConsumerGroupMember.Builder("consumer-member-" + i2).build();
            consumerProtocolMembers.add(member);
            consumerGroup.updateMember(member);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)numClassicProtocolMembers, (int)consumerGroup.numClassicProtocolMembers());
        HashSet<ConsumerGroupMember> removedMembers = new HashSet<ConsumerGroupMember>();
        for (i = 0; i < numRemovedClassicProtocolMembers; ++i) {
            removedMembers.add((ConsumerGroupMember)classicProtocolMembers.get(i));
        }
        for (i = 0; i < numRemovedConsumerProtocolMembers; ++i) {
            removedMembers.add((ConsumerGroupMember)consumerProtocolMembers.get(i));
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)consumerGroup.allMembersUseClassicProtocolExcept(removedMembers));
    }

    @Test
    public void testFromClassicGroup() {
        MockTime time = new MockTime();
        LogContext logContext = new LogContext();
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 1).addTopic(barTopicId, barTopicName, 1).addRacks().build();
        ClassicGroup classicGroup = new ClassicGroup(logContext, groupId, ClassicGroupState.STABLE, (Time)time, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class), 10, Optional.of("consumer"), Optional.of("range"), Optional.empty(), Optional.of(time.milliseconds()));
        ClassicGroupMember member = new ClassicGroupMember(memberId, Optional.empty(), "client-id", "client-host", 5000, 500, "consumer", new JoinGroupRequestData.JoinGroupRequestProtocolCollection(Collections.singletonList(new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Arrays.asList(fooTopicName, barTopicName), null, Arrays.asList(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0))))))).iterator()), Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(Arrays.asList(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0))))));
        classicGroup.add(member);
        ConsumerGroup consumerGroup = ConsumerGroup.fromClassicGroup((SnapshotRegistry)new SnapshotRegistry(logContext), (GroupCoordinatorMetricsShard)((GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class)), (ClassicGroup)classicGroup, (TopicsImage)metadataImage.topics(), (Time)time, (ClusterImage)metadataImage.cluster());
        ConsumerGroup expectedConsumerGroup = new ConsumerGroup((Time)time, new SnapshotRegistry(logContext), groupId, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        expectedConsumerGroup.setGroupEpoch(10);
        expectedConsumerGroup.setTargetAssignmentEpoch(10);
        expectedConsumerGroup.updateTargetAssignment(memberId, new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))));
        expectedConsumerGroup.setSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 1), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1)));
        expectedConsumerGroup.updateMember(new ConsumerGroupMember.Builder(memberId).setMemberEpoch(classicGroup.generationId()).setState(MemberState.STABLE).setPreviousMemberEpoch(classicGroup.generationId()).setInstanceId(null).setRackId(null).setRebalanceTimeoutMs(member.rebalanceTimeoutMs()).setClientId(member.clientId()).setClientHost(member.clientHost()).setSubscribedTopicNames(Arrays.asList(fooTopicName, barTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(member.sessionTimeoutMs()).setSupportedProtocols(Collections.singletonList(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Arrays.asList(fooTopicName, barTopicName), null, Arrays.asList(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0))))))))).build());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedConsumerGroup.groupId(), (Object)consumerGroup.groupId());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedConsumerGroup.groupEpoch(), (int)consumerGroup.groupEpoch());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedConsumerGroup.state(), (Object)consumerGroup.state());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedConsumerGroup.preferredServerAssignor(), (Object)consumerGroup.preferredServerAssignor());
        org.junit.jupiter.api.Assertions.assertEquals(Map.copyOf(expectedConsumerGroup.subscriptionMetadata()), Map.copyOf(consumerGroup.subscriptionMetadata()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedConsumerGroup.members(), (Object)consumerGroup.members());
    }

    @Test
    public void testSubscribedRegularExpressionCount() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setSubscribedTopicRegex("regex1").build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setSubscribedTopicRegex("regex2").build();
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member3").setSubscribedTopicRegex("regex1").build();
        ConsumerGroupMember member4 = new ConsumerGroupMember.Builder("member4").build();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers(""));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex3"));
        consumerGroup.updateMember(member1);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers(""));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)consumerGroup.numSubscribedMembers("regex1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex3"));
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers(""));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)consumerGroup.numSubscribedMembers("regex1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)consumerGroup.numSubscribedMembers("regex2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex3"));
        consumerGroup.updateMember(member3);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers(""));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)consumerGroup.numSubscribedMembers("regex1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)consumerGroup.numSubscribedMembers("regex2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex3"));
        consumerGroup.updateMember(member4);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers(""));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)consumerGroup.numSubscribedMembers("regex1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)consumerGroup.numSubscribedMembers("regex2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex3"));
        member3 = new ConsumerGroupMember.Builder(member3).setSubscribedTopicRegex("regex2").build();
        consumerGroup.updateMember(member3);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers(""));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)consumerGroup.numSubscribedMembers("regex1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)consumerGroup.numSubscribedMembers("regex2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex3"));
        consumerGroup.removeMember(member1.memberId());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers(""));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)consumerGroup.numSubscribedMembers("regex2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex3"));
        consumerGroup.removeMember(member2.memberId());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers(""));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)consumerGroup.numSubscribedMembers("regex2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex3"));
        consumerGroup.removeMember(member3.memberId());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers(""));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)consumerGroup.numSubscribedMembers("regex3"));
    }

    @Test
    public void testUpdateAndRemoveRegularExpression() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Arrays.asList("foo", "bar", "zar")).build();
        consumerGroup.updateMember(member1);
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setSubscribedTopicNames(Arrays.asList("foo", "bar")).build();
        consumerGroup.updateMember(member2);
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(2, 0), "bar", new SubscriptionCount(2, 0), "zar", new SubscriptionCount(1, 0)), (Object)consumerGroup.subscribedTopicNames());
        consumerGroup.updateResolvedRegularExpression("foo|bar", new ResolvedRegularExpression(Set.of("foo", "bar"), 10L, 12345L));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(2, 1), "bar", new SubscriptionCount(2, 1), "zar", new SubscriptionCount(1, 0)), (Object)consumerGroup.subscribedTopicNames());
        consumerGroup.updateResolvedRegularExpression("foobar", new ResolvedRegularExpression(Set.of("foobar"), 10L, 12345L));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(2, 1), "bar", new SubscriptionCount(2, 1), "zar", new SubscriptionCount(1, 0), "foobar", new SubscriptionCount(0, 1)), (Object)consumerGroup.subscribedTopicNames());
        consumerGroup.updateResolvedRegularExpression("foo|bar", new ResolvedRegularExpression(Set.of("foo"), 10L, 12345L));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(2, 1), "bar", new SubscriptionCount(2, 0), "zar", new SubscriptionCount(1, 0), "foobar", new SubscriptionCount(0, 1)), (Object)consumerGroup.subscribedTopicNames());
        consumerGroup.removeResolvedRegularExpression("foo|bar");
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(2, 0), "bar", new SubscriptionCount(2, 0), "zar", new SubscriptionCount(1, 0), "foobar", new SubscriptionCount(0, 1)), (Object)consumerGroup.subscribedTopicNames());
        consumerGroup.removeResolvedRegularExpression("foobar");
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(2, 0), "bar", new SubscriptionCount(2, 0), "zar", new SubscriptionCount(1, 0)), (Object)consumerGroup.subscribedTopicNames());
    }

    @Test
    public void testComputeSubscribedTopicNamesWithoutDeletedMembers() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Arrays.asList("foo", "bar", "zar")).build();
        consumerGroup.updateMember(member1);
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setSubscribedTopicNames(Arrays.asList("foo", "bar")).build();
        consumerGroup.updateMember(member2);
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member3").setSubscribedTopicRegex("foo*").build();
        consumerGroup.updateMember(member3);
        ConsumerGroupMember member4 = new ConsumerGroupMember.Builder("member4").setSubscribedTopicRegex("foo*").build();
        consumerGroup.updateMember(member4);
        ConsumerGroupMember member5 = new ConsumerGroupMember.Builder("member5").setSubscribedTopicRegex("bar*").build();
        consumerGroup.updateMember(member5);
        ConsumerGroupMember member6 = new ConsumerGroupMember.Builder("member6").setSubscribedTopicRegex("bar*").build();
        consumerGroup.updateMember(member6);
        consumerGroup.updateResolvedRegularExpression("foo*", new ResolvedRegularExpression(Set.of("foo", "fooo"), 10L, 12345L));
        consumerGroup.updateResolvedRegularExpression("bar*", new ResolvedRegularExpression(Set.of("bar", "barr"), 10L, 12345L));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(2, 1), "fooo", new SubscriptionCount(0, 1), "bar", new SubscriptionCount(2, 1), "barr", new SubscriptionCount(0, 1), "zar", new SubscriptionCount(1, 0)), (Object)consumerGroup.subscribedTopicNames());
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(1, 0), "bar", new SubscriptionCount(1, 1), "barr", new SubscriptionCount(0, 1), "zar", new SubscriptionCount(1, 0)), (Object)consumerGroup.computeSubscribedTopicNamesWithoutDeletedMembers(Set.of(member2, member3, member4, member5), Set.of("foo*")));
    }

    @Test
    public void testComputeSubscribedTopicNames() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(List.of("foo", "bar", "zar")).build();
        consumerGroup.updateMember(member1);
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setSubscribedTopicNames(List.of("foo", "bar")).build();
        consumerGroup.updateMember(member2);
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member3").setSubscribedTopicNames(List.of("foo")).setSubscribedTopicRegex("foo*").build();
        consumerGroup.updateMember(member3);
        consumerGroup.updateResolvedRegularExpression("foo*", new ResolvedRegularExpression(Set.of("foo", "fooo"), 10L, 12345L));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(3, 1), "fooo", new SubscriptionCount(0, 1), "bar", new SubscriptionCount(2, 0), "zar", new SubscriptionCount(1, 0)), (Object)consumerGroup.subscribedTopicNames());
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(3, 1), "fooo", new SubscriptionCount(0, 1), "bar", new SubscriptionCount(2, 0), "zar", new SubscriptionCount(1, 0)), (Object)consumerGroup.computeSubscribedTopicNames(member3, member3));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(3, 0), "bar", new SubscriptionCount(2, 0), "zar", new SubscriptionCount(1, 0)), (Object)consumerGroup.computeSubscribedTopicNames(member3, new ConsumerGroupMember.Builder(member3).setSubscribedTopicRegex("").build()));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(2, 1), "fooo", new SubscriptionCount(0, 1), "bar", new SubscriptionCount(2, 0), "zar", new SubscriptionCount(1, 0)), (Object)consumerGroup.computeSubscribedTopicNames(member3, new ConsumerGroupMember.Builder(member3).setSubscribedTopicNames(Collections.emptyList()).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo", new SubscriptionCount(2, 0), "bar", new SubscriptionCount(2, 0), "zar", new SubscriptionCount(1, 0)), (Object)consumerGroup.computeSubscribedTopicNames(member3, new ConsumerGroupMember.Builder(member3).setSubscribedTopicNames(Collections.emptyList()).setSubscribedTopicRegex("").build()));
    }

    @Test
    public void testCreateGroupTombstoneRecords() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        consumerGroup.setGroupEpoch(10);
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setMemberEpoch(10).setSubscribedTopicNames(Arrays.asList("foo", "bar", "zar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))).build();
        consumerGroup.updateMember(member1);
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setMemberEpoch(10).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))).build();
        consumerGroup.updateMember(member2);
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member3").setMemberEpoch(10).setSubscribedTopicRegex("foo*").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))).build();
        consumerGroup.updateMember(member3);
        consumerGroup.updateResolvedRegularExpression("foo*", new ResolvedRegularExpression(Set.of("foo", "fooo"), 10L, 12345L));
        consumerGroup.updateTargetAssignment("member1", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))));
        consumerGroup.updateTargetAssignment("member2", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))));
        consumerGroup.updateTargetAssignment("member3", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))));
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        consumerGroup.createGroupTombstoneRecords(records);
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)"foo", (String)"member1"), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)"foo", (String)"member2"), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)"foo", (String)"member3")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)"foo", (String)"member1"), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)"foo", (String)"member2"), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)"foo", (String)"member3")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)"foo")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)"foo", (String)"member1"), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)"foo", (String)"member2"), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)"foo", (String)"member3")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)"foo", (String)"foo*")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)"foo")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)"foo"))), records);
    }

    @Test
    public void testCreateGroupTombstoneRecordsWithReplacedMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        consumerGroup.setGroupEpoch(10);
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setMemberEpoch(10).setSubscribedTopicNames(Arrays.asList("foo", "bar", "zar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))).build();
        consumerGroup.updateMember(member1);
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setMemberEpoch(10).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))).build();
        consumerGroup.updateMember(member2);
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member3").setMemberEpoch(10).setSubscribedTopicRegex("foo*").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))).build();
        consumerGroup.updateMember(member3);
        consumerGroup.updateResolvedRegularExpression("foo*", new ResolvedRegularExpression(Set.of("foo", "fooo"), 10L, 12345L));
        consumerGroup.updateTargetAssignment("member1", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))));
        consumerGroup.updateTargetAssignment("member2", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))));
        consumerGroup.updateTargetAssignment("member3", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))));
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        consumerGroup.createGroupTombstoneRecordsWithReplacedMember(records, "member3", "member4");
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)"foo", (String)"member1"), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)"foo", (String)"member2"), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)"foo", (String)"member4")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)"foo", (String)"member1"), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)"foo", (String)"member2"), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)"foo", (String)"member4")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)"foo")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)"foo", (String)"member1"), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)"foo", (String)"member2"), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)"foo", (String)"member4")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)"foo", (String)"foo*")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)"foo")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)"foo"))), records);
    }

    @Test
    public void testSubscriptionType() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HOMOGENEOUS, (Object)ConsumerGroup.subscriptionType(Collections.emptyMap(), Collections.emptyMap(), (int)0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HOMOGENEOUS, (Object)ConsumerGroup.subscriptionType(Collections.emptyMap(), Map.of("foo", new SubscriptionCount(5, 0)), (int)5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HETEROGENEOUS, (Object)ConsumerGroup.subscriptionType(Collections.emptyMap(), Map.of("foo", new SubscriptionCount(4, 0), "bar", new SubscriptionCount(1, 0)), (int)5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HOMOGENEOUS, (Object)ConsumerGroup.subscriptionType(Map.of("foo*", 5), Map.of("foo", new SubscriptionCount(0, 1)), (int)5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HOMOGENEOUS, (Object)ConsumerGroup.subscriptionType(Map.of("foo*", 5), Map.of("foo", new SubscriptionCount(0, 1), "food", new SubscriptionCount(0, 1)), (int)5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HETEROGENEOUS, (Object)ConsumerGroup.subscriptionType(Map.of("foo*", 5), Map.of("foo", new SubscriptionCount(1, 1)), (int)5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HETEROGENEOUS, (Object)ConsumerGroup.subscriptionType(Map.of("foo*", 5), Map.of("foo", new SubscriptionCount(0, 1), "bar", new SubscriptionCount(1, 0)), (int)5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)SubscriptionType.HETEROGENEOUS, (Object)ConsumerGroup.subscriptionType(Map.of("foo*", 4, "bar*", 1), Map.of("foo", new SubscriptionCount(0, 1), "bar", new SubscriptionCount(0, 1)), (int)5));
    }

    @Test
    public void testComputeSubscribedRegularExpressions() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        consumerGroup.setGroupEpoch(10);
        consumerGroup.updateMember(new ConsumerGroupMember.Builder("m1").setSubscribedTopicRegex("foo*").build());
        consumerGroup.updateMember(new ConsumerGroupMember.Builder("m2").setSubscribedTopicRegex("foo*").build());
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo*", 3), (Object)consumerGroup.computeSubscribedRegularExpressions(null, new ConsumerGroupMember.Builder("m3").setSubscribedTopicRegex("foo*").build()));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo*", 1), (Object)consumerGroup.computeSubscribedRegularExpressions(new ConsumerGroupMember.Builder("m2").setSubscribedTopicRegex("foo*").build(), null));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo*", 2, "bar*", 1), (Object)consumerGroup.computeSubscribedRegularExpressions(null, new ConsumerGroupMember.Builder("m4").setSubscribedTopicRegex("bar*").build()));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("foo*", 1, "bar*", 1), (Object)consumerGroup.computeSubscribedRegularExpressions(new ConsumerGroupMember.Builder("m2").setSubscribedTopicRegex("foo*").build(), new ConsumerGroupMember.Builder("m2").setSubscribedTopicRegex("bar*").build()));
    }
}

