/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.image.MetadataImage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ConsumerGroupMemberTest {
    @Test
    public void testNewMember() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member-id").setMemberEpoch(10).setPreviousMemberEpoch(9).setInstanceId("instance-id").setRackId("rack-id").setRebalanceTimeoutMs(5000).setClientId("client-id").setClientHost("hostname").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setSubscribedTopicRegex("regex").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(this.toClassicProtocolCollection("range"))).build();
        Assertions.assertEquals((Object)"member-id", (Object)member.memberId());
        Assertions.assertEquals((int)10, (int)member.memberEpoch());
        Assertions.assertEquals((int)9, (int)member.previousMemberEpoch());
        Assertions.assertEquals((Object)"instance-id", (Object)member.instanceId());
        Assertions.assertEquals((Object)"rack-id", (Object)member.rackId());
        Assertions.assertEquals((Object)"client-id", (Object)member.clientId());
        Assertions.assertEquals((Object)"hostname", (Object)member.clientHost());
        Assertions.assertEquals(Set.of("bar", "foo"), (Object)member.subscribedTopicNames());
        Assertions.assertEquals((Object)"regex", (Object)member.subscribedTopicRegex());
        Assertions.assertEquals((Object)"range", member.serverAssignorName().get());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3)), (Object)member.assignedPartitions());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6)), (Object)member.partitionsPendingRevocation());
        Assertions.assertEquals((Object)new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(this.toClassicProtocolCollection("range")), member.classicMemberMetadata().get());
        Assertions.assertEquals(this.toClassicProtocolCollection("range"), member.supportedClassicProtocols().get());
    }

    @Test
    public void testEquals() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member-id").setMemberEpoch(10).setPreviousMemberEpoch(9).setInstanceId("instance-id").setRackId("rack-id").setRebalanceTimeoutMs(5000).setClientId("client-id").setClientHost("hostname").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setSubscribedTopicRegex("regex").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(this.toClassicProtocolCollection("range"))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member-id").setMemberEpoch(10).setPreviousMemberEpoch(9).setInstanceId("instance-id").setRackId("rack-id").setRebalanceTimeoutMs(5000).setClientId("client-id").setClientHost("hostname").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setSubscribedTopicRegex("regex").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(this.toClassicProtocolCollection("range"))).build();
        Assertions.assertEquals((Object)member1, (Object)member2);
    }

    @Test
    public void testUpdateMember() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member-id").setMemberEpoch(10).setPreviousMemberEpoch(9).setInstanceId("instance-id").setRackId("rack-id").setRebalanceTimeoutMs(5000).setClientId("client-id").setClientHost("hostname").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setSubscribedTopicRegex("regex").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(this.toClassicProtocolCollection("range"))).build();
        ConsumerGroupMember updatedMember = new ConsumerGroupMember.Builder(member).maybeUpdateRackId(Optional.empty()).maybeUpdateInstanceId(Optional.empty()).maybeUpdateServerAssignorName(Optional.empty()).maybeUpdateSubscribedTopicNames(Optional.empty()).maybeUpdateSubscribedTopicRegex(Optional.empty()).maybeUpdateRebalanceTimeoutMs(OptionalInt.empty()).build();
        Assertions.assertEquals((Object)member, (Object)updatedMember);
        updatedMember = new ConsumerGroupMember.Builder(member).maybeUpdateRackId(Optional.of("new-rack-id")).maybeUpdateInstanceId(Optional.of("new-instance-id")).maybeUpdateServerAssignorName(Optional.of("new-assignor")).maybeUpdateSubscribedTopicNames(Optional.of(Collections.singletonList("zar"))).maybeUpdateSubscribedTopicRegex(Optional.of("new-regex")).maybeUpdateRebalanceTimeoutMs(OptionalInt.of(6000)).build();
        Assertions.assertEquals((Object)"new-instance-id", (Object)updatedMember.instanceId());
        Assertions.assertEquals((Object)"new-rack-id", (Object)updatedMember.rackId());
        Assertions.assertEquals(Set.of("zar"), (Object)updatedMember.subscribedTopicNames());
        Assertions.assertEquals((Object)"new-regex", (Object)updatedMember.subscribedTopicRegex());
        Assertions.assertEquals((Object)"new-assignor", updatedMember.serverAssignorName().get());
    }

    @Test
    public void testUpdateWithConsumerGroupMemberMetadataValue() {
        ConsumerGroupMemberMetadataValue record = new ConsumerGroupMemberMetadataValue().setServerAssignor("range").setClientId("client-id").setClientHost("host-id").setInstanceId("instance-id").setRackId("rack-id").setRebalanceTimeoutMs(1000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setSubscribedTopicRegex("regex").setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(this.toClassicProtocolCollection("range")));
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member-id").updateWith(record).build();
        Assertions.assertEquals((Object)"instance-id", (Object)member.instanceId());
        Assertions.assertEquals((Object)"rack-id", (Object)member.rackId());
        Assertions.assertEquals((Object)"client-id", (Object)member.clientId());
        Assertions.assertEquals((Object)"host-id", (Object)member.clientHost());
        Assertions.assertEquals(Set.of("bar", "foo"), (Object)member.subscribedTopicNames());
        Assertions.assertEquals((Object)"regex", (Object)member.subscribedTopicRegex());
        Assertions.assertEquals((Object)"range", member.serverAssignorName().get());
        Assertions.assertEquals((Object)new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(this.toClassicProtocolCollection("range")), member.classicMemberMetadata().get());
    }

    @Test
    public void testUpdateWithConsumerGroupCurrentMemberAssignmentValue() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupCurrentMemberAssignmentValue record = new ConsumerGroupCurrentMemberAssignmentValue().setMemberEpoch(10).setPreviousMemberEpoch(9).setAssignedPartitions(Collections.singletonList(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId1).setPartitions(Arrays.asList(0, 1, 2)))).setPartitionsPendingRevocation(Collections.singletonList(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId2).setPartitions(Arrays.asList(3, 4, 5))));
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member-id").updateWith(record).build();
        Assertions.assertEquals((int)10, (int)member.memberEpoch());
        Assertions.assertEquals((int)9, (int)member.previousMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 0, 1, 2)), (Object)member.assignedPartitions());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId2, 3, 4, 5)), (Object)member.partitionsPendingRevocation());
    }

    @ParameterizedTest(name="{displayName}.withClassicMemberMetadata={0}")
    @ValueSource(booleans={true, false})
    public void testAsConsumerGroupDescribeMember(boolean withClassicMemberMetadata) {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        Uuid topicId3 = Uuid.randomUuid();
        Uuid topicId4 = Uuid.randomUuid();
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(topicId1, "topic1", 3).addTopic(topicId2, "topic2", 3).addTopic(topicId3, "topic3", 3).addTopic(topicId4, "topic4", 3).build();
        List<Integer> assignedPartitions = Arrays.asList(0, 1, 2);
        int epoch = 10;
        ConsumerGroupCurrentMemberAssignmentValue record = new ConsumerGroupCurrentMemberAssignmentValue().setMemberEpoch(epoch).setPreviousMemberEpoch(epoch - 1).setAssignedPartitions(Collections.singletonList(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId1).setPartitions(assignedPartitions))).setPartitionsPendingRevocation(Collections.singletonList(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId2).setPartitions(Arrays.asList(3, 4, 5))));
        String memberId = Uuid.randomUuid().toString();
        String clientId = "clientId";
        String instanceId = "instanceId";
        String rackId = "rackId";
        String clientHost = "clientHost";
        List<String> subscribedTopicNames = Arrays.asList("topic1", "topic2");
        String subscribedTopicRegex = "topic.*";
        HashMap<Uuid, HashSet<Integer>> assignmentMap = new HashMap<Uuid, HashSet<Integer>>();
        assignmentMap.put(topicId4, new HashSet<Integer>(assignedPartitions));
        Assignment targetAssignment = new Assignment(assignmentMap);
        ConsumerGroupMember member = new ConsumerGroupMember.Builder(memberId).updateWith(record).setClientId(clientId).setInstanceId(instanceId).setRackId(rackId).setClientHost(clientHost).setSubscribedTopicNames(subscribedTopicNames).setSubscribedTopicRegex(subscribedTopicRegex).setClassicMemberMetadata(withClassicMemberMetadata ? new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(this.toClassicProtocolCollection("range")) : null).build();
        ConsumerGroupDescribeResponseData.Member actual = member.asConsumerGroupDescribeMember(targetAssignment, metadataImage.topics());
        ConsumerGroupDescribeResponseData.Member expected = new ConsumerGroupDescribeResponseData.Member().setMemberId(memberId).setMemberEpoch(epoch).setClientId(clientId).setInstanceId(instanceId).setRackId(rackId).setClientHost(clientHost).setSubscribedTopicNames(new ArrayList<String>(subscribedTopicNames)).setSubscribedTopicRegex(subscribedTopicRegex).setAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(topicId1).setTopicName("topic1").setPartitions(assignedPartitions)))).setTargetAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(targetAssignment.partitions().entrySet().stream().map(item -> new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId((Uuid)item.getKey()).setTopicName("topic4").setPartitions(new ArrayList((Collection)item.getValue()))).collect(Collectors.toList()))).setMemberType(withClassicMemberMetadata ? (byte)0 : 1);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAsConsumerGroupDescribeWithTargetAssignmentNull() {
        ConsumerGroupMember member = new ConsumerGroupMember.Builder(Uuid.randomUuid().toString()).build();
        ConsumerGroupDescribeResponseData.Member consumerGroupDescribeMember = member.asConsumerGroupDescribeMember(null, new MetadataImageBuilder().build().topics());
        Assertions.assertEquals((Object)new ConsumerGroupDescribeResponseData.Assignment(), (Object)consumerGroupDescribeMember.targetAssignment());
    }

    @Test
    public void testAsConsumerGroupDescribeWithTopicNameNotFound() {
        Uuid memberId = Uuid.randomUuid();
        ConsumerGroupCurrentMemberAssignmentValue record = new ConsumerGroupCurrentMemberAssignmentValue().setAssignedPartitions(Collections.singletonList(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(Uuid.randomUuid()).setPartitions(Arrays.asList(0, 1, 2))));
        ConsumerGroupMember member = new ConsumerGroupMember.Builder(memberId.toString()).updateWith(record).build();
        ConsumerGroupDescribeResponseData.Member expected = new ConsumerGroupDescribeResponseData.Member().setMemberId(memberId.toString()).setSubscribedTopicRegex("").setMemberType((byte)1);
        ConsumerGroupDescribeResponseData.Member actual = member.asConsumerGroupDescribeMember(null, new MetadataImageBuilder().addTopic(Uuid.randomUuid(), "foo", 3).build().topics());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testClassicProtocolListFromJoinRequestProtocolCollection() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.addAll(Arrays.asList(new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[]{1, 2, 3})));
        Assertions.assertEquals(this.toClassicProtocolCollection("range"), (Object)ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols));
    }

    private List<ConsumerGroupMemberMetadataValue.ClassicProtocol> toClassicProtocolCollection(String name) {
        ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = new ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol>();
        protocols.add(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName(name).setMetadata(new byte[]{1, 2, 3}));
        return protocols;
    }
}

