/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.consumer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ResolvedRegularExpression;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;

public class ConsumerGroupBuilder {
    private final String groupId;
    private final int groupEpoch;
    private int assignmentEpoch;
    private final Map<String, ConsumerGroupMember> members = new HashMap<String, ConsumerGroupMember>();
    private final Map<String, Assignment> assignments = new HashMap<String, Assignment>();
    private Map<String, TopicMetadata> subscriptionMetadata;
    private final Map<String, ResolvedRegularExpression> resolvedRegularExpressions = new HashMap<String, ResolvedRegularExpression>();

    public ConsumerGroupBuilder(String groupId, int groupEpoch) {
        this.groupId = groupId;
        this.groupEpoch = groupEpoch;
        this.assignmentEpoch = 0;
    }

    public ConsumerGroupBuilder withMember(ConsumerGroupMember member) {
        this.members.put(member.memberId(), member);
        return this;
    }

    public ConsumerGroupBuilder withResolvedRegularExpression(String regex, ResolvedRegularExpression resolvedRegularExpression) {
        this.resolvedRegularExpressions.put(regex, resolvedRegularExpression);
        return this;
    }

    public ConsumerGroupBuilder withSubscriptionMetadata(Map<String, TopicMetadata> subscriptionMetadata) {
        this.subscriptionMetadata = subscriptionMetadata;
        return this;
    }

    public ConsumerGroupBuilder withAssignment(String memberId, Map<Uuid, Set<Integer>> assignment) {
        this.assignments.put(memberId, new Assignment(assignment));
        return this;
    }

    public ConsumerGroupBuilder withAssignmentEpoch(int assignmentEpoch) {
        this.assignmentEpoch = assignmentEpoch;
        return this;
    }

    public List<CoordinatorRecord> build(TopicsImage topicsImage) {
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        this.members.forEach((memberId, member) -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)this.groupId, (ConsumerGroupMember)member)));
        this.resolvedRegularExpressions.forEach((regex, resolvedRegularExpression) -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)this.groupId, (String)regex, (ResolvedRegularExpression)resolvedRegularExpression)));
        if (this.subscriptionMetadata == null) {
            this.subscriptionMetadata = new HashMap<String, TopicMetadata>();
            this.members.forEach((memberId, member) -> member.subscribedTopicNames().forEach(topicName -> {
                TopicImage topicImage = topicsImage.getTopic(topicName);
                if (topicImage != null) {
                    this.subscriptionMetadata.put((String)topicName, new TopicMetadata(topicImage.id(), topicImage.name(), topicImage.partitions().size()));
                }
            }));
        }
        if (!this.subscriptionMetadata.isEmpty()) {
            records.add(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)this.groupId, this.subscriptionMetadata));
        }
        records.add(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)this.groupId, (int)this.groupEpoch));
        this.assignments.forEach((memberId, assignment) -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)this.groupId, (String)memberId, (Map)assignment.partitions())));
        records.add(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)this.groupId, (int)this.assignmentEpoch));
        this.members.forEach((memberId, member) -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)this.groupId, (ConsumerGroupMember)member)));
        return records;
    }
}

