/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AssignmentTest {
    @Test
    public void testPartitionsCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new Assignment(null));
    }

    @Test
    public void testAttributes() {
        Map<Uuid, Set<Integer>> partitions = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 1, 2, 3));
        Assignment assignment = new Assignment(partitions);
        Assertions.assertEquals(partitions, (Object)assignment.partitions());
    }

    @Test
    public void testFromTargetAssignmentRecord() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ArrayList<ConsumerGroupTargetAssignmentMemberValue.TopicPartition> partitions = new ArrayList<ConsumerGroupTargetAssignmentMemberValue.TopicPartition>();
        partitions.add(new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(topicId1).setPartitions(Arrays.asList(1, 2, 3)));
        partitions.add(new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(topicId2).setPartitions(Arrays.asList(4, 5, 6)));
        ConsumerGroupTargetAssignmentMemberValue record = new ConsumerGroupTargetAssignmentMemberValue().setTopicPartitions(partitions);
        Assignment assignment = Assignment.fromRecord((ConsumerGroupTargetAssignmentMemberValue)record);
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6)), (Object)assignment.partitions());
    }

    @Test
    public void testEquals() {
        Map<Uuid, Set<Integer>> partitions = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 1, 2, 3));
        Assertions.assertEquals((Object)new Assignment(partitions), (Object)new Assignment(partitions));
    }
}

