/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetrics;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorMetricsShardTest {
    @Test
    public void testTimelineGaugeCounters() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        TopicPartition tp = new TopicPartition("__consumer_offsets", 0);
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics(Time.SYSTEM, registry, metrics);
        GroupCoordinatorMetricsShard shard = coordinatorMetrics.newMetricsShard(snapshotRegistry, tp);
        shard.incrementNumOffsets();
        snapshotRegistry.idempotentCreateSnapshot(1000L);
        Assertions.assertEquals((long)0L, (long)shard.numOffsets());
        shard.commitUpTo(1000L);
        Assertions.assertEquals((long)1L, (long)shard.numOffsets());
        shard.decrementNumOffsets();
        snapshotRegistry.idempotentCreateSnapshot(2000L);
        shard.commitUpTo(2000L);
        Assertions.assertEquals((long)0L, (long)shard.numOffsets());
    }

    @Test
    public void testGroupGaugeCounters() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        TopicPartition tp = new TopicPartition("__consumer_offsets", 0);
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics(Time.SYSTEM, registry, metrics);
        GroupCoordinatorMetricsShard shard = coordinatorMetrics.newMetricsShard(snapshotRegistry, tp);
        Assertions.assertEquals((long)0L, (long)shard.numClassicGroups());
        Assertions.assertEquals((long)0L, (long)shard.numClassicGroups(ClassicGroupState.STABLE));
        Assertions.assertEquals((long)0L, (long)shard.numClassicGroups(ClassicGroupState.PREPARING_REBALANCE));
        Assertions.assertEquals((long)0L, (long)shard.numClassicGroups(ClassicGroupState.COMPLETING_REBALANCE));
        Assertions.assertEquals((long)0L, (long)shard.numClassicGroups(ClassicGroupState.EMPTY));
        Assertions.assertEquals((long)0L, (long)shard.numClassicGroups(ClassicGroupState.DEAD));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups());
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING));
        Assertions.assertEquals((long)0L, (long)shard.numMixedGroups());
        Assertions.assertEquals((long)0L, (long)shard.numMixedGroups(ConsumerGroup.ConsumerGroupState.STABLE));
        Assertions.assertEquals((long)0L, (long)shard.numMixedGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING));
        Assertions.assertEquals((long)0L, (long)shard.numMixedGroups(ConsumerGroup.ConsumerGroupState.RECONCILING));
        shard.setClassicGroupGauges(Map.of(ClassicGroupState.STABLE, 1L, ClassicGroupState.PREPARING_REBALANCE, 2L, ClassicGroupState.COMPLETING_REBALANCE, 3L, ClassicGroupState.EMPTY, 4L, ClassicGroupState.DEAD, 5L));
        shard.setConsumerGroupGauges(Map.of(ConsumerGroup.ConsumerGroupState.STABLE, 6L, ConsumerGroup.ConsumerGroupState.EMPTY, 7L, ConsumerGroup.ConsumerGroupState.ASSIGNING, 8L, ConsumerGroup.ConsumerGroupState.RECONCILING, 9L));
        shard.setMixedGroupGauges(Map.of(ConsumerGroup.ConsumerGroupState.STABLE, 10L, ConsumerGroup.ConsumerGroupState.ASSIGNING, 11L, ConsumerGroup.ConsumerGroupState.RECONCILING, 12L));
        Assertions.assertEquals((long)15L, (long)shard.numClassicGroups());
        Assertions.assertEquals((long)1L, (long)shard.numClassicGroups(ClassicGroupState.STABLE));
        Assertions.assertEquals((long)2L, (long)shard.numClassicGroups(ClassicGroupState.PREPARING_REBALANCE));
        Assertions.assertEquals((long)3L, (long)shard.numClassicGroups(ClassicGroupState.COMPLETING_REBALANCE));
        Assertions.assertEquals((long)4L, (long)shard.numClassicGroups(ClassicGroupState.EMPTY));
        Assertions.assertEquals((long)5L, (long)shard.numClassicGroups(ClassicGroupState.DEAD));
        Assertions.assertEquals((long)30L, (long)shard.numConsumerGroups());
        Assertions.assertEquals((long)6L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE));
        Assertions.assertEquals((long)7L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY));
        Assertions.assertEquals((long)8L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING));
        Assertions.assertEquals((long)9L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING));
        Assertions.assertEquals((long)33L, (long)shard.numMixedGroups());
        Assertions.assertEquals((long)10L, (long)shard.numMixedGroups(ConsumerGroup.ConsumerGroupState.STABLE));
        Assertions.assertEquals((long)11L, (long)shard.numMixedGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING));
        Assertions.assertEquals((long)12L, (long)shard.numMixedGroups(ConsumerGroup.ConsumerGroupState.RECONCILING));
    }
}

