/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.classic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.OffsetExpirationConditionImpl;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.mockito.Mockito;

public class ClassicGroupTest {
    private final String protocolType = "consumer";
    private final String groupInstanceId = "groupInstanceId";
    private final String memberId = "memberId";
    private final String clientId = "clientId";
    private final String clientHost = "clientHost";
    private final int rebalanceTimeoutMs = 60000;
    private final int sessionTimeoutMs = 10000;
    private final LogContext logContext = new LogContext();
    private final GroupCoordinatorMetricsShard metrics = new GroupCoordinatorMetricsShard(new SnapshotRegistry(this.logContext), Collections.emptyMap(), new TopicPartition("__consumer_offsets", 0));
    private ClassicGroup group = null;

    @BeforeEach
    public void initialize() {
        this.group = new ClassicGroup(this.logContext, "groupId", ClassicGroupState.EMPTY, Time.SYSTEM, this.metrics);
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assertions.assertTrue((boolean)this.group.canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        Assertions.assertTrue((boolean)this.group.canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertFalse((boolean)this.group.canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.EMPTY);
        this.group.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertFalse((boolean)this.group.canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.assertState(this.group, ClassicGroupState.PREPARING_REBALANCE);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group.transitionTo(ClassicGroupState.DEAD);
        this.assertState(this.group, ClassicGroupState.DEAD);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.assertState(this.group, ClassicGroupState.PREPARING_REBALANCE);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.DEAD);
        this.assertState(this.group, ClassicGroupState.DEAD);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.EMPTY);
        this.assertState(this.group, ClassicGroupState.EMPTY);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.EMPTY);
        this.group.transitionTo(ClassicGroupState.DEAD);
        this.assertState(this.group, ClassicGroupState.DEAD);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.STABLE);
        this.assertState(this.group, ClassicGroupState.STABLE);
    }

    @Test
    public void testEmptyToStableIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.transitionTo(ClassicGroupState.STABLE));
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.STABLE);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.transitionTo(ClassicGroupState.STABLE));
    }

    @Test
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.transitionTo(ClassicGroupState.STABLE));
    }

    @Test
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testDeadToDeadIllegalTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.DEAD);
        this.group.transitionTo(ClassicGroupState.DEAD);
        this.assertState(this.group, ClassicGroupState.DEAD);
    }

    @Test
    public void testDeadToStableIllegalTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.transitionTo(ClassicGroupState.STABLE));
    }

    @Test
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testSelectProtocol() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection member1Protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        member1Protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[0]));
        member1Protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member1 = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", member1Protocols);
        this.group.add(member1);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection member2Protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        member2Protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        member2Protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[0]));
        ClassicGroupMember member2 = new ClassicGroupMember("member2", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", member2Protocols);
        this.group.add(member2);
        Assertions.assertTrue((this.group.selectProtocol().equals("range") || this.group.selectProtocol().equals("roundrobin") ? 1 : 0) != 0);
        ClassicGroupMember member3 = new ClassicGroupMember("member3", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", member2Protocols);
        this.group.add(member3);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group.selectProtocol());
    }

    @Test
    public void testSelectProtocolRaisesIfNoMembers() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.selectProtocol());
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection member1Protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        member1Protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[0]));
        member1Protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member1 = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", member1Protocols);
        this.group.add(member1);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection member2Protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        member2Protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        member2Protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("foo").setMetadata(new byte[0]));
        ClassicGroupMember member2 = new ClassicGroupMember("member2", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", member2Protocols);
        this.group.add(member2);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group.selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection member1Protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        member1Protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[0]));
        member1Protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member1 = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", member1Protocols);
        Assertions.assertTrue((boolean)this.group.supportsProtocols("consumer", Set.of("range", "roundrobin")));
        this.group.add(member1);
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertTrue((boolean)this.group.supportsProtocols("consumer", Set.of("roundrobin", "foo")));
        Assertions.assertTrue((boolean)this.group.supportsProtocols("consumer", Set.of("range", "bar")));
        Assertions.assertFalse((boolean)this.group.supportsProtocols("consumer", Set.of("foo", "bar")));
    }

    @Test
    public void testSubscribedTopics() {
        Assertions.assertEquals(Optional.empty(), (Object)this.group.subscribedTopics());
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"))).array()));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.add(member);
        this.group.initNextGeneration();
        HashSet<String> expectedTopics = new HashSet<String>(Set.of("foo"));
        Assertions.assertEquals(expectedTopics, this.group.subscribedTopics().get());
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.remove("memberId");
        this.group.initNextGeneration();
        Assertions.assertEquals(Optional.of(Collections.emptySet()), (Object)this.group.subscribedTopics());
        protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[0]));
        ClassicGroupMember memberWithFaultyProtocol = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.add(memberWithFaultyProtocol);
        this.group.initNextGeneration();
        Assertions.assertEquals(Optional.empty(), (Object)this.group.subscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assertions.assertEquals(Optional.empty(), (Object)this.group.subscribedTopics());
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[0]));
        ClassicGroupMember memberWithNonConsumerProtocol = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "My Protocol", protocols);
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.add(memberWithNonConsumerProtocol);
        this.group.initNextGeneration();
        Assertions.assertEquals(Optional.empty(), (Object)this.group.subscribedTopics());
    }

    @Test
    public void testInitNextGeneration() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.add(member, new CompletableFuture());
        Assertions.assertEquals((int)0, (int)this.group.generationId());
        Assertions.assertNull(this.group.protocolName().orElse(null));
        this.group.initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group.generationId());
        Assertions.assertEquals((Object)"roundrobin", this.group.protocolName().orElse(null));
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assertions.assertEquals((Object)ClassicGroupState.EMPTY, (Object)this.group.currentState());
        Assertions.assertEquals((int)0, (int)this.group.generationId());
        Assertions.assertNull(this.group.protocolName().orElse(null));
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group.generationId());
        Assertions.assertNull(this.group.protocolName().orElse(null));
    }

    @Test
    public void testUpdateMember() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection newProtocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        newProtocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[0]));
        newProtocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        int newRebalanceTimeoutMs = 120000;
        int newSessionTimeoutMs = 20000;
        this.group.updateMember(member, newProtocols, newRebalanceTimeoutMs, newSessionTimeoutMs, null);
        Assertions.assertEquals((int)this.group.rebalanceTimeoutMs(), (int)newRebalanceTimeoutMs);
        Assertions.assertEquals((int)member.sessionTimeoutMs(), (int)newSessionTimeoutMs);
        Assertions.assertEquals((Object)newProtocols, (Object)member.supportedProtocols());
    }

    @Test
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.group.replaceStaticMember("groupInstanceId", "memberId", newMemberId));
    }

    @Test
    public void testReplaceGroupInstance() throws Exception {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.of("groupInstanceId"), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        CompletableFuture joinGroupFuture = new CompletableFuture();
        this.group.add(member, joinGroupFuture);
        CompletableFuture syncGroupFuture = new CompletableFuture();
        member.setAwaitingSyncFuture(syncGroupFuture);
        Assertions.assertTrue((boolean)this.group.isLeader("memberId"));
        Assertions.assertEquals((Object)"memberId", (Object)this.group.staticMemberId("groupInstanceId"));
        String newMemberId = "newMemberId";
        this.group.replaceStaticMember("groupInstanceId", "memberId", newMemberId);
        Assertions.assertTrue((boolean)this.group.isLeader(newMemberId));
        Assertions.assertEquals((Object)newMemberId, (Object)this.group.staticMemberId("groupInstanceId"));
        Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)((JoinGroupResponseData)joinGroupFuture.get()).errorCode());
        Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)((SyncGroupResponseData)syncGroupFuture.get()).errorCode());
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testCompleteJoinFuture() throws Exception {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        CompletableFuture joinGroupFuture = new CompletableFuture();
        this.group.add(member, joinGroupFuture);
        Assertions.assertTrue((boolean)this.group.hasAllMembersJoined());
        Assertions.assertTrue((boolean)this.group.completeJoinFuture(member, new JoinGroupResponseData().setMemberId(member.memberId()).setErrorCode(Errors.NONE.code())));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((JoinGroupResponseData)joinGroupFuture.get()).errorCode());
        Assertions.assertEquals((Object)"memberId", (Object)((JoinGroupResponseData)joinGroupFuture.get()).memberId());
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        Assertions.assertEquals((int)0, (int)this.group.numAwaitingJoinResponse());
    }

    @Test
    public void testNotCompleteJoinFuture() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        Assertions.assertFalse((boolean)this.group.completeJoinFuture(member, new JoinGroupResponseData().setMemberId(member.memberId()).setErrorCode(Errors.NONE.code())));
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testCompleteSyncFuture() throws Exception {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        CompletableFuture syncGroupFuture = new CompletableFuture();
        member.setAwaitingSyncFuture(syncGroupFuture);
        Assertions.assertTrue((boolean)this.group.completeSyncFuture(member, new SyncGroupResponseData().setErrorCode(Errors.NONE.code())));
        Assertions.assertEquals((int)0, (int)this.group.numAwaitingJoinResponse());
        Assertions.assertFalse((boolean)member.isAwaitingSync());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((SyncGroupResponseData)syncGroupFuture.get()).errorCode());
    }

    @Test
    public void testNotCompleteSyncFuture() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        Assertions.assertFalse((boolean)member.isAwaitingSync());
        Assertions.assertFalse((boolean)this.group.completeSyncFuture(member, new SyncGroupResponseData().setErrorCode(Errors.NONE.code())));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testCannotAddPendingMemberIfStable() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.addPendingMember("memberId"));
    }

    @Test
    public void testRemovalFromPendingAfterMemberIsStable() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        this.group.addPendingMember("memberId");
        Assertions.assertFalse((boolean)this.group.hasMember("memberId"));
        Assertions.assertTrue((boolean)this.group.isPendingMember("memberId"));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        Assertions.assertTrue((boolean)this.group.hasMember("memberId"));
        Assertions.assertFalse((boolean)this.group.isPendingMember("memberId"));
    }

    @Test
    public void testRemovalFromPendingWhenMemberIsRemoved() {
        this.group.addPendingMember("memberId");
        Assertions.assertFalse((boolean)this.group.hasMember("memberId"));
        Assertions.assertTrue((boolean)this.group.isPendingMember("memberId"));
        this.group.remove("memberId");
        Assertions.assertFalse((boolean)this.group.hasMember("memberId"));
        Assertions.assertFalse((boolean)this.group.isPendingMember("memberId"));
    }

    @Test
    public void testCannotAddStaticMemberIfAlreadyPresent() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.of("groupInstanceId"), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        Assertions.assertTrue((boolean)this.group.hasMember("memberId"));
        Assertions.assertTrue((boolean)this.group.hasStaticMember("groupInstanceId"));
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.add(member));
    }

    @Test
    public void testCannotAddPendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.addPendingSyncMember("memberId"));
    }

    @Test
    public void testCannotRemovePendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group.removePendingSyncMember("memberId"));
    }

    @Test
    public void testCanAddAndRemovePendingSyncMember() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        Assertions.assertTrue((boolean)this.group.addPendingSyncMember("memberId"));
        Assertions.assertEquals(Set.of("memberId"), (Object)this.group.allPendingSyncMembers());
        this.group.removePendingSyncMember("memberId");
        Assertions.assertEquals(Collections.emptySet(), (Object)this.group.allPendingSyncMembers());
    }

    @Test
    public void testRemovalFromPendingSyncWhenMemberIsRemoved() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.of("groupInstanceId"), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        Assertions.assertTrue((boolean)this.group.addPendingSyncMember("memberId"));
        Assertions.assertEquals(Set.of("memberId"), (Object)this.group.allPendingSyncMembers());
        this.group.remove("memberId");
        Assertions.assertEquals(Collections.emptySet(), (Object)this.group.allPendingSyncMembers());
    }

    @Test
    public void testNewGenerationClearsPendingSyncMembers() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertTrue((boolean)this.group.addPendingSyncMember("memberId"));
        Assertions.assertEquals(Set.of("memberId"), (Object)this.group.allPendingSyncMembers());
        this.group.initNextGeneration();
        Assertions.assertEquals(Collections.emptySet(), (Object)this.group.allPendingSyncMembers());
    }

    @Test
    public void testElectNewJoinedLeader() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember leader = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(leader);
        Assertions.assertTrue((boolean)this.group.isLeader("memberId"));
        Assertions.assertFalse((boolean)leader.isAwaitingJoin());
        ClassicGroupMember newLeader = new ClassicGroupMember("new-leader", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(newLeader, new CompletableFuture());
        ClassicGroupMember newMember = new ClassicGroupMember("new-member", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(newMember);
        Assertions.assertTrue((boolean)this.group.maybeElectNewJoinedLeader());
        Assertions.assertTrue((boolean)this.group.isLeader("new-leader"));
    }

    @Test
    public void testMaybeElectNewJoinedLeaderChooseExisting() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember leader = new ClassicGroupMember("memberId", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(leader, new CompletableFuture());
        Assertions.assertTrue((boolean)this.group.isLeader("memberId"));
        Assertions.assertTrue((boolean)leader.isAwaitingJoin());
        ClassicGroupMember newMember = new ClassicGroupMember("new-member", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(newMember);
        Assertions.assertTrue((boolean)this.group.maybeElectNewJoinedLeader());
        Assertions.assertTrue((boolean)this.group.isLeader("memberId"));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_COMMIT)
    public void testValidateOffsetCommit(short version) {
        this.group.validateOffsetCommit("", "", -1, false, version);
        this.group.add(new ClassicGroupMember("member-id", Optional.of("instance-id"), "", "", 100, 100, "consumer", new JoinGroupRequestData.JoinGroupRequestProtocolCollection(List.of(new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0])).iterator())));
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.initNextGeneration();
        Assertions.assertThrows(UnknownMemberIdException.class, () -> this.group.validateOffsetCommit("", "", -1, false, version));
        this.group.validateOffsetCommit("", null, -1, true, version);
        Assertions.assertThrows(UnknownMemberIdException.class, () -> this.group.validateOffsetCommit("unknown", "unknown", -1, false, version));
        Assertions.assertThrows(UnknownMemberIdException.class, () -> this.group.validateOffsetCommit("member-id", "unknown", -1, false, version));
        Assertions.assertThrows(IllegalGenerationException.class, () -> this.group.validateOffsetCommit("member-id", "instance-id", 0, false, version));
        Assertions.assertThrows(RebalanceInProgressException.class, () -> this.group.validateOffsetCommit("member-id", "instance-id", 1, false, version));
        this.group.transitionTo(ClassicGroupState.STABLE);
        this.group.validateOffsetCommit("member-id", "instance-id", 1, false, version);
        this.group.replaceStaticMember("instance-id", "member-id", "new-member-id");
        Assertions.assertThrows(FencedInstanceIdException.class, () -> this.group.validateOffsetCommit("member-id", "instance-id", 1, false, version));
        this.group.remove("new-instance-id");
        this.group.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertThrows(CoordinatorNotAvailableException.class, () -> this.group.validateOffsetCommit("member-id", "new-instance-id", 1, false, version));
    }

    @Test
    public void testValidateOffsetDelete() {
        Assertions.assertFalse((boolean)this.group.usesConsumerGroupProtocol());
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ClassicGroup)this.group).validateOffsetDelete());
        this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ClassicGroup)this.group).validateOffsetDelete());
        this.group.transitionTo(ClassicGroupState.STABLE);
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ClassicGroup)this.group).validateOffsetDelete());
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("memberId", Optional.of("groupInstanceId"), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        this.group.add(member);
        Assertions.assertTrue((boolean)this.group.usesConsumerGroupProtocol());
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertDoesNotThrow(() -> ((ClassicGroup)this.group).validateOffsetDelete());
        this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        Assertions.assertDoesNotThrow(() -> ((ClassicGroup)this.group).validateOffsetDelete());
        this.group.transitionTo(ClassicGroupState.STABLE);
        Assertions.assertDoesNotThrow(() -> ((ClassicGroup)this.group).validateOffsetDelete());
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.EMPTY);
        Assertions.assertDoesNotThrow(() -> ((ClassicGroup)this.group).validateOffsetDelete());
        this.group.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertThrows(GroupIdNotFoundException.class, () -> ((ClassicGroup)this.group).validateOffsetDelete());
    }

    @Test
    public void testValidateDeleteGroup() {
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ClassicGroup)this.group).validateDeleteGroup());
        this.group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ClassicGroup)this.group).validateDeleteGroup());
        this.group.transitionTo(ClassicGroupState.STABLE);
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ClassicGroup)this.group).validateDeleteGroup());
        this.group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.group.transitionTo(ClassicGroupState.EMPTY);
        Assertions.assertDoesNotThrow(() -> ((ClassicGroup)this.group).validateDeleteGroup());
        this.group.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertThrows(GroupIdNotFoundException.class, () -> ((ClassicGroup)this.group).validateDeleteGroup());
    }

    @Test
    public void testOffsetExpirationCondition() {
        long currentTimestamp = 30000L;
        long commitTimestamp = 20000L;
        long offsetsRetentionMs = 10000L;
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(15000L, OptionalInt.empty(), "", commitTimestamp, OptionalLong.empty());
        MockTime time = new MockTime();
        long currentStateTimestamp = time.milliseconds();
        ClassicGroup group = new ClassicGroup(new LogContext(), "groupId", ClassicGroupState.EMPTY, (Time)time, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        Optional offsetExpirationCondition = group.offsetExpirationCondition();
        Assertions.assertTrue((boolean)offsetExpirationCondition.isPresent());
        OffsetExpirationConditionImpl condition = (OffsetExpirationConditionImpl)offsetExpirationCondition.get();
        Assertions.assertEquals((long)commitTimestamp, (Long)((Long)condition.baseTimestamp().apply(offsetAndMetadata)));
        Assertions.assertTrue((boolean)condition.isOffsetExpired(offsetAndMetadata, currentTimestamp, offsetsRetentionMs));
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("topic"))).array()));
        ClassicGroupMember memberWithNonConsumerProtocol = new ClassicGroupMember("memberWithNonConsumerProtocol", Optional.empty(), "clientId", "clientHost", 60000, 10000, "My Protocol", protocols);
        group.add(memberWithNonConsumerProtocol);
        Assertions.assertEquals((Object)"My Protocol", group.protocolType().get());
        offsetExpirationCondition = group.offsetExpirationCondition();
        Assertions.assertTrue((boolean)offsetExpirationCondition.isPresent());
        condition = (OffsetExpirationConditionImpl)offsetExpirationCondition.get();
        Assertions.assertEquals((long)currentStateTimestamp, (Long)((Long)condition.baseTimestamp().apply(offsetAndMetadata)));
        Assertions.assertTrue((boolean)condition.isOffsetExpired(offsetAndMetadata, currentStateTimestamp + offsetsRetentionMs, offsetsRetentionMs));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        offsetExpirationCondition = group.offsetExpirationCondition();
        Assertions.assertFalse((boolean)offsetExpirationCondition.isPresent());
        group.remove("memberWithNonConsumerProtocol");
        ClassicGroupMember memberWithConsumerProtocol = new ClassicGroupMember("memberWithConsumerProtocol", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        group.add(memberWithConsumerProtocol);
        group.initNextGeneration();
        group.transitionTo(ClassicGroupState.STABLE);
        Assertions.assertTrue((boolean)((Set)group.subscribedTopics().get()).contains("topic"));
        offsetExpirationCondition = group.offsetExpirationCondition();
        Assertions.assertTrue((boolean)offsetExpirationCondition.isPresent());
        condition = (OffsetExpirationConditionImpl)offsetExpirationCondition.get();
        Assertions.assertEquals((long)commitTimestamp, (Long)((Long)condition.baseTimestamp().apply(offsetAndMetadata)));
        Assertions.assertTrue((boolean)condition.isOffsetExpired(offsetAndMetadata, currentTimestamp, offsetsRetentionMs));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        offsetExpirationCondition = group.offsetExpirationCondition();
        Assertions.assertFalse((boolean)offsetExpirationCondition.isPresent());
    }

    @Test
    public void testIsSubscribedToTopic() {
        ClassicGroup group = new ClassicGroup(new LogContext(), "groupId", ClassicGroupState.EMPTY, Time.SYSTEM, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        Assertions.assertFalse((boolean)group.isSubscribedToTopic("topic"));
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("topic"))).array()));
        ClassicGroupMember memberWithNonConsumerProtocol = new ClassicGroupMember("memberWithNonConsumerProtocol", Optional.empty(), "clientId", "clientHost", 60000, 10000, "My Protocol", protocols);
        group.add(memberWithNonConsumerProtocol);
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.initNextGeneration();
        Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        Assertions.assertEquals(Optional.empty(), (Object)group.computeSubscribedTopics());
        Assertions.assertFalse((boolean)group.isSubscribedToTopic("topic"));
        group.remove("memberWithNonConsumerProtocol");
        ClassicGroupMember memberWithConsumerProtocol = new ClassicGroupMember("memberWithConsumerProtocol", Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
        group.add(memberWithConsumerProtocol);
        group.remove("memberWithConsumerProtocol");
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.initNextGeneration();
        Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
        Assertions.assertEquals(Optional.of(Collections.emptySet()), (Object)group.computeSubscribedTopics());
        Assertions.assertTrue((boolean)group.usesConsumerGroupProtocol());
        Assertions.assertFalse((boolean)group.isSubscribedToTopic("topic"));
        group.add(memberWithConsumerProtocol);
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.initNextGeneration();
        Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        Assertions.assertEquals(Optional.of(Set.of("topic")), (Object)group.computeSubscribedTopics());
        Assertions.assertTrue((boolean)group.usesConsumerGroupProtocol());
        Assertions.assertTrue((boolean)group.isSubscribedToTopic("topic"));
    }

    @Test
    public void testIsInStates() {
        ClassicGroup group = new ClassicGroup(new LogContext(), "groupId", ClassicGroupState.EMPTY, Time.SYSTEM, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        Assertions.assertTrue((boolean)group.isInStates(Set.of("empty"), 0L));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertTrue((boolean)group.isInStates(Set.of("preparingrebalance"), 0L));
        Assertions.assertFalse((boolean)group.isInStates(Set.of("PreparingRebalance"), 0L));
        group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        Assertions.assertTrue((boolean)group.isInStates(new HashSet<String>(List.of("completingrebalance")), 0L));
        group.transitionTo(ClassicGroupState.STABLE);
        Assertions.assertTrue((boolean)group.isInStates(Set.of("stable"), 0L));
        Assertions.assertFalse((boolean)group.isInStates(Set.of("empty"), 0L));
        group.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertTrue((boolean)group.isInStates(new HashSet<String>(List.of("dead", " ")), 0L));
    }

    @Test
    public void testCompleteAllJoinFutures() throws ExecutionException, InterruptedException {
        int i;
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ArrayList<ClassicGroupMember> memberList = new ArrayList<ClassicGroupMember>();
        for (int i2 = 0; i2 < 3; ++i2) {
            memberList.add(new ClassicGroupMember("memberId" + i2, Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols));
        }
        ArrayList joinGroupFutureList = new ArrayList();
        for (i = 0; i < 3; ++i) {
            CompletableFuture future = new CompletableFuture();
            this.group.add((ClassicGroupMember)memberList.get(i), future);
            joinGroupFutureList.add(future);
        }
        Assertions.assertEquals((int)3, (int)this.group.numAwaitingJoinResponse());
        this.group.completeAllJoinFutures(Errors.REBALANCE_IN_PROGRESS);
        for (i = 0; i < 3; ++i) {
            Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)((JoinGroupResponseData)((CompletableFuture)joinGroupFutureList.get(i)).get()).errorCode());
            Assertions.assertEquals((Object)("memberId" + i), (Object)((JoinGroupResponseData)((CompletableFuture)joinGroupFutureList.get(i)).get()).memberId());
            Assertions.assertFalse((boolean)((ClassicGroupMember)memberList.get(i)).isAwaitingJoin());
        }
        Assertions.assertEquals((int)0, (int)this.group.numAwaitingJoinResponse());
    }

    @Test
    public void testCompleteAllSyncFutures() throws ExecutionException, InterruptedException {
        int i;
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ArrayList<ClassicGroupMember> memberList = new ArrayList<ClassicGroupMember>();
        for (int i2 = 0; i2 < 3; ++i2) {
            ClassicGroupMember member = new ClassicGroupMember("memberId" + i2, Optional.empty(), "clientId", "clientHost", 60000, 10000, "consumer", protocols);
            memberList.add(member);
            this.group.add(member);
        }
        ArrayList syncGroupFutureList = new ArrayList();
        for (i = 0; i < 3; ++i) {
            CompletableFuture syncGroupFuture = new CompletableFuture();
            syncGroupFutureList.add(syncGroupFuture);
            ((ClassicGroupMember)memberList.get(i)).setAwaitingSyncFuture(syncGroupFuture);
        }
        this.group.completeAllSyncFutures(Errors.REBALANCE_IN_PROGRESS);
        for (i = 0; i < 3; ++i) {
            Assertions.assertFalse((boolean)((ClassicGroupMember)memberList.get(i)).isAwaitingSync());
            Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)((SyncGroupResponseData)((CompletableFuture)syncGroupFutureList.get(i)).get()).errorCode());
        }
    }

    @Test
    public void testFromConsumerGroupWithJoiningMember() {
        MockTime time = new MockTime();
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String newMemberId2 = Uuid.randomUuid().toString();
        String instanceId2 = "instance-id-2";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addRacks().build();
        ConsumerGroup consumerGroup = new ConsumerGroup((Time)time, new SnapshotRegistry(this.logContext), groupId, this.metrics);
        consumerGroup.setGroupEpoch(10);
        consumerGroup.setTargetAssignmentEpoch(10);
        consumerGroup.updateTargetAssignment(memberId1, new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))));
        consumerGroup.updateTargetAssignment(memberId2, new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))));
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols1 = List.of(this.createClassicProtocol("range", List.of(fooTopicName), List.of(new TopicPartition(fooTopicName, 0))));
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols2 = List.of(this.createClassicProtocol("range", List.of(fooTopicName), List.of(new TopicPartition(fooTopicName, 1))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName)).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols1)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).build();
        consumerGroup.updateMember(member1);
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setInstanceId(instanceId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName)).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        consumerGroup.updateMember(member2);
        ConsumerGroupMember newMember2 = new ConsumerGroupMember.Builder(member2, newMemberId2).setMemberEpoch(10).setPreviousMemberEpoch(0).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName)).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols2)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        ClassicGroup classicGroup = ClassicGroup.fromConsumerGroup((ConsumerGroup)consumerGroup, Collections.emptySet(), (ConsumerGroupMember)newMember2, (LogContext)this.logContext, (Time)time, (GroupCoordinatorMetricsShard)this.metrics, (MetadataImage)metadataImage);
        ClassicGroup expectedClassicGroup = new ClassicGroup(this.logContext, groupId, ClassicGroupState.STABLE, (Time)time, this.metrics, 10, Optional.of("consumer"), Optional.of("range"), Optional.empty(), Optional.of(time.milliseconds()));
        expectedClassicGroup.add(new ClassicGroupMember(memberId1, Optional.empty(), member1.clientId(), member1.clientHost(), member1.rebalanceTimeoutMs(), ((Integer)member1.classicProtocolSessionTimeout().get()).intValue(), "consumer", new JoinGroupRequestData.JoinGroupRequestProtocolCollection(List.of(new JoinGroupRequestData.JoinGroupRequestProtocol().setName(protocols1.get(0).name()).setMetadata(protocols1.get(0).metadata())).iterator()), Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0)))))));
        expectedClassicGroup.add(new ClassicGroupMember(newMemberId2, Optional.of(instanceId2), newMember2.clientId(), newMember2.clientHost(), newMember2.rebalanceTimeoutMs(), ((Integer)newMember2.classicProtocolSessionTimeout().get()).intValue(), "consumer", new JoinGroupRequestData.JoinGroupRequestProtocolCollection(List.of(new JoinGroupRequestData.JoinGroupRequestProtocol().setName(protocols2.get(0).name()).setMetadata(protocols2.get(0).metadata())).iterator()), Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 1)))))));
        this.assertClassicGroupEquals(expectedClassicGroup, classicGroup);
    }

    @Test
    public void testFromConsumerGroupWithoutJoiningMember() {
        MockTime time = new MockTime();
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String instanceId2 = "instance-id-2";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addRacks().build();
        ConsumerGroup consumerGroup = new ConsumerGroup((Time)time, new SnapshotRegistry(this.logContext), groupId, this.metrics);
        consumerGroup.setGroupEpoch(10);
        consumerGroup.setTargetAssignmentEpoch(10);
        consumerGroup.updateTargetAssignment(memberId1, new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))));
        consumerGroup.updateTargetAssignment(memberId2, new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))));
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols1 = List.of(this.createClassicProtocol("range", List.of(fooTopicName), List.of(new TopicPartition(fooTopicName, 0))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName)).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols1)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).build();
        consumerGroup.updateMember(member1);
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setInstanceId(instanceId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName)).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        consumerGroup.updateMember(member2);
        ClassicGroup classicGroup = ClassicGroup.fromConsumerGroup((ConsumerGroup)consumerGroup, Set.of(member2), null, (LogContext)this.logContext, (Time)time, (GroupCoordinatorMetricsShard)this.metrics, (MetadataImage)metadataImage);
        ClassicGroup expectedClassicGroup = new ClassicGroup(this.logContext, groupId, ClassicGroupState.STABLE, (Time)time, this.metrics, 10, Optional.of("consumer"), Optional.of("range"), Optional.empty(), Optional.of(time.milliseconds()));
        expectedClassicGroup.add(new ClassicGroupMember(memberId1, Optional.empty(), member1.clientId(), member1.clientHost(), member1.rebalanceTimeoutMs(), ((Integer)member1.classicProtocolSessionTimeout().get()).intValue(), "consumer", new JoinGroupRequestData.JoinGroupRequestProtocolCollection(List.of(new JoinGroupRequestData.JoinGroupRequestProtocol().setName(protocols1.get(0).name()).setMetadata(protocols1.get(0).metadata())).iterator()), Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0)))))));
        this.assertClassicGroupEquals(expectedClassicGroup, classicGroup);
    }

    private void assertState(ClassicGroup group, ClassicGroupState targetState) {
        HashSet<ClassicGroupState> otherStates = new HashSet<ClassicGroupState>();
        otherStates.add(ClassicGroupState.STABLE);
        otherStates.add(ClassicGroupState.PREPARING_REBALANCE);
        otherStates.add(ClassicGroupState.COMPLETING_REBALANCE);
        otherStates.add(ClassicGroupState.DEAD);
        otherStates.remove(targetState);
        otherStates.forEach(otherState -> Assertions.assertFalse((boolean)group.isInState(otherState)));
        Assertions.assertTrue((boolean)group.isInState(targetState));
    }

    @Test
    public void testRebalanceStartTimestampMs() {
        MockTime time = new MockTime();
        ClassicGroup group = new ClassicGroup(new LogContext(), "groupId", ClassicGroupState.EMPTY, (Time)time, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        Assertions.assertFalse((boolean)group.rebalanceStartTimestampMs.isPresent());
        time.sleep(100L);
        Optional<Long> expectedRebalanceStartTimestamp = Optional.of(time.milliseconds());
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertEquals(expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestampMs);
        time.sleep(100L);
        group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        Assertions.assertEquals(expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestampMs);
        time.sleep(100L);
        group.transitionTo(ClassicGroupState.STABLE);
        Assertions.assertFalse((boolean)group.rebalanceStartTimestampMs.isPresent());
        time.sleep(100L);
        expectedRebalanceStartTimestamp = Optional.of(time.milliseconds());
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertEquals(expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestampMs);
        time.sleep(100L);
        group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        Assertions.assertEquals(expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestampMs);
        time.sleep(100L);
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        Assertions.assertEquals(expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestampMs);
        group.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertFalse((boolean)group.rebalanceStartTimestampMs.isPresent());
    }

    private void assertClassicGroupEquals(ClassicGroup expected, ClassicGroup actual) {
        Assertions.assertEquals((Object)expected.groupId(), (Object)actual.groupId());
        Assertions.assertEquals((Object)expected.protocolName(), (Object)actual.protocolName());
        Assertions.assertEquals((Object)expected.protocolType(), (Object)actual.protocolType());
        Assertions.assertEquals((Object)expected.leaderOrNull(), (Object)actual.leaderOrNull());
        Assertions.assertEquals((Object)expected.stateAsString(), (Object)actual.stateAsString());
        Assertions.assertEquals((int)expected.generationId(), (int)actual.generationId());
        Assertions.assertEquals((int)expected.allMembers().size(), (int)actual.allMembers().size());
        expected.allMembers().forEach(expectedMember -> this.assertClassicGroupMemberEquals((ClassicGroupMember)expectedMember, actual.member(expectedMember.memberId())));
    }

    private void assertClassicGroupMemberEquals(ClassicGroupMember expected, ClassicGroupMember actual) {
        Assertions.assertEquals((Object)expected.memberId(), (Object)actual.memberId());
        Assertions.assertEquals((Object)expected.groupInstanceId(), (Object)actual.groupInstanceId());
        Assertions.assertEquals((Object)expected.clientId(), (Object)actual.clientId());
        Assertions.assertEquals((Object)expected.clientHost(), (Object)actual.clientHost());
        Assertions.assertEquals((int)expected.rebalanceTimeoutMs(), (int)actual.rebalanceTimeoutMs());
        Assertions.assertEquals((int)expected.sessionTimeoutMs(), (int)actual.sessionTimeoutMs());
        Assertions.assertEquals((Object)expected.protocolType(), (Object)actual.protocolType());
        Assertions.assertEquals((Object)expected.supportedProtocols(), (Object)actual.supportedProtocols());
        Assertions.assertArrayEquals((byte[])expected.assignment(), (byte[])actual.assignment());
    }

    private ConsumerGroupMemberMetadataValue.ClassicProtocol createClassicProtocol(String protocolName, List<String> subscribedTopics, List<TopicPartition> assignedTopicPartitions) {
        return new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName(protocolName).setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(subscribedTopics, null, assignedTopicPartitions))));
    }
}

