/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.assignor.SimpleAssignor;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.GroupSpecImpl;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.SubscribedTopicDescriberImpl;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleAssignorTest {
    private static final Uuid TOPIC_1_UUID = Uuid.randomUuid();
    private static final Uuid TOPIC_2_UUID = Uuid.randomUuid();
    private static final Uuid TOPIC_3_UUID = Uuid.randomUuid();
    private static final String TOPIC_1_NAME = "topic1";
    private static final String TOPIC_3_NAME = "topic3";
    private static final String MEMBER_A = "A";
    private static final String MEMBER_B = "B";
    private final SimpleAssignor assignor = new SimpleAssignor();

    @Test
    public void testName() {
        Assertions.assertEquals((Object)"simple", (Object)this.assignor.name());
    }

    @Test
    public void testAssignWithEmptyMembers() {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.emptyMap());
        GroupSpecImpl groupSpec = new GroupSpecImpl(Collections.emptyMap(), SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        GroupAssignment groupAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        Assertions.assertEquals(Collections.emptyMap(), (Object)groupAssignment.members());
    }

    @Test
    public void testAssignWithNoSubscribedTopic() {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.singletonMap(TOPIC_1_UUID, new TopicMetadata(TOPIC_1_UUID, TOPIC_1_NAME, 3)));
        Map<String, MemberSubscriptionAndAssignmentImpl> members = Collections.singletonMap(MEMBER_A, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.emptySet(), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        GroupAssignment groupAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        Assertions.assertEquals(Collections.emptyMap(), (Object)groupAssignment.members());
    }

    @Test
    public void testAssignWithSubscribedToNonExistentTopic() {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.singletonMap(TOPIC_1_UUID, new TopicMetadata(TOPIC_1_UUID, TOPIC_1_NAME, 3)));
        Map<String, MemberSubscriptionAndAssignmentImpl> members = Collections.singletonMap(MEMBER_A, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(TOPIC_2_UUID), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        Assertions.assertThrows(PartitionAssignorException.class, () -> this.lambda$testAssignWithSubscribedToNonExistentTopic$0((GroupSpec)groupSpec, subscribedTopicMetadata));
    }

    @Test
    public void testAssignWithTwoMembersAndTwoTopicsHomogeneous() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(TOPIC_1_UUID, new TopicMetadata(TOPIC_1_UUID, TOPIC_1_NAME, 3));
        topicMetadata.put(TOPIC_3_UUID, new TopicMetadata(TOPIC_3_UUID, TOPIC_3_NAME, 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put(MEMBER_A, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(TOPIC_1_UUID, TOPIC_3_UUID), Assignment.EMPTY));
        members.put(MEMBER_B, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(TOPIC_1_UUID, TOPIC_3_UUID), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put(MEMBER_A, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(TOPIC_1_UUID, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(TOPIC_3_UUID, 0, 1)));
        expectedAssignment.put(MEMBER_B, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(TOPIC_1_UUID, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(TOPIC_3_UUID, 0, 1)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testAssignWithThreeMembersThreeTopicsHeterogeneous() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(TOPIC_1_UUID, new TopicMetadata(TOPIC_1_UUID, TOPIC_1_NAME, 3));
        topicMetadata.put(TOPIC_2_UUID, new TopicMetadata(TOPIC_2_UUID, "topic2", 3));
        topicMetadata.put(TOPIC_3_UUID, new TopicMetadata(TOPIC_3_UUID, TOPIC_3_NAME, 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put(MEMBER_A, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(TOPIC_1_UUID, TOPIC_2_UUID), Assignment.EMPTY));
        members.put(MEMBER_B, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(TOPIC_3_UUID), Assignment.EMPTY));
        String memberC = "C";
        members.put(memberC, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(TOPIC_2_UUID, TOPIC_3_UUID), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, Collections.emptyMap());
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put(MEMBER_A, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(TOPIC_1_UUID, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(TOPIC_2_UUID, 0, 1, 2)));
        expectedAssignment.put(MEMBER_B, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(TOPIC_3_UUID, 0, 1)));
        expectedAssignment.put(memberC, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(TOPIC_2_UUID, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(TOPIC_3_UUID, 0, 1)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testAssignWithOneMemberNoAssignedTopicHeterogeneous() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(TOPIC_1_UUID, new TopicMetadata(TOPIC_1_UUID, TOPIC_1_NAME, 3));
        topicMetadata.put(TOPIC_2_UUID, new TopicMetadata(TOPIC_2_UUID, "topic2", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put(MEMBER_A, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(TOPIC_1_UUID, TOPIC_2_UUID), Assignment.EMPTY));
        members.put(MEMBER_B, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.emptySet(), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, Collections.emptyMap());
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put(MEMBER_A, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(TOPIC_1_UUID, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(TOPIC_2_UUID, 0, 1)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    private void assertAssignment(Map<String, Map<Uuid, Set<Integer>>> expectedAssignment, GroupAssignment computedGroupAssignment) {
        Assertions.assertEquals((int)expectedAssignment.size(), (int)computedGroupAssignment.members().size());
        for (String memberId : computedGroupAssignment.members().keySet()) {
            Map computedAssignmentForMember = ((MemberAssignment)computedGroupAssignment.members().get(memberId)).partitions();
            Assertions.assertEquals(expectedAssignment.get(memberId), (Object)computedAssignmentForMember);
        }
    }

    private /* synthetic */ void lambda$testAssignWithSubscribedToNonExistentTopic$0(GroupSpec groupSpec, SubscribedTopicDescriberImpl subscribedTopicMetadata) throws Throwable {
        this.assignor.assign(groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
    }
}

