/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.kafka.coordinator.group.assignor.RangeSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RangeSetTest {
    @Test
    void testSize() {
        RangeSet rangeSet = new RangeSet(5, 10);
        Assertions.assertEquals((int)5, (int)rangeSet.size());
    }

    @Test
    void testIsEmpty() {
        RangeSet rangeSet = new RangeSet(5, 5);
        Assertions.assertTrue((boolean)rangeSet.isEmpty());
    }

    @Test
    void testContains() {
        RangeSet rangeSet = new RangeSet(5, 10);
        Assertions.assertTrue((boolean)rangeSet.contains((Object)5));
        Assertions.assertTrue((boolean)rangeSet.contains((Object)9));
        Assertions.assertFalse((boolean)rangeSet.contains((Object)10));
        Assertions.assertFalse((boolean)rangeSet.contains((Object)4));
    }

    @Test
    void testIterator() {
        RangeSet rangeSet = new RangeSet(5, 10);
        Iterator iterator = rangeSet.iterator();
        for (int i = 5; i < 10; ++i) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertEquals((int)i, (Integer)((Integer)iterator.next()));
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, iterator::next);
    }

    @Test
    void testUnsupportedOperations() {
        RangeSet rangeSet = new RangeSet(5, 10);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> rangeSet.add(Integer.valueOf(5)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> rangeSet.remove((Object)5));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> rangeSet.addAll(null));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> rangeSet.retainAll(null));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> rangeSet.removeAll(null));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((RangeSet)rangeSet).clear());
    }

    @Test
    void testToArray() {
        RangeSet rangeSet = new RangeSet(5, 10);
        Object[] expectedArray = new Object[]{5, 6, 7, 8, 9};
        Assertions.assertArrayEquals((Object[])expectedArray, (Object[])rangeSet.toArray());
    }

    @Test
    void testToArrayWithArrayParameter() {
        RangeSet rangeSet = new RangeSet(5, 10);
        Object[] inputArray = new Integer[5];
        Object[] expectedArray = new Integer[]{5, 6, 7, 8, 9};
        Assertions.assertArrayEquals((Object[])expectedArray, (Object[])rangeSet.toArray(inputArray));
    }

    @Test
    void testContainsAll() {
        RangeSet rangeSet = new RangeSet(5, 10);
        Assertions.assertTrue((boolean)rangeSet.containsAll(Set.of(Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9))));
        Assertions.assertFalse((boolean)rangeSet.containsAll(Set.of(Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(10))));
    }

    @Test
    void testToString() {
        RangeSet rangeSet = new RangeSet(5, 8);
        Assertions.assertEquals((Object)"RangeSet(from=5 (inclusive), to=8 (exclusive))", (Object)rangeSet.toString());
    }

    @Test
    void testEquals() {
        RangeSet rangeSet1 = new RangeSet(5, 10);
        RangeSet rangeSet2 = new RangeSet(5, 10);
        RangeSet rangeSet3 = new RangeSet(6, 10);
        Set<Integer> set = Set.of(Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9));
        HashSet<Integer> hashSet = new HashSet<Integer>(Set.of(Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9)));
        Assertions.assertEquals((Object)rangeSet1, (Object)rangeSet2);
        Assertions.assertNotEquals((Object)rangeSet1, (Object)rangeSet3);
        Assertions.assertEquals((Object)rangeSet1, set);
        Assertions.assertEquals((Object)rangeSet3, hashSet);
        Assertions.assertNotEquals((Object)rangeSet1, (Object)new Object());
    }

    @Test
    void testHashCode() {
        RangeSet rangeSet1 = new RangeSet(5, 10);
        RangeSet rangeSet2 = new RangeSet(5, 10);
        RangeSet rangeSet3 = new RangeSet(6, 10);
        Assertions.assertEquals((int)rangeSet1.hashCode(), (int)rangeSet2.hashCode());
        Assertions.assertNotEquals((int)rangeSet1.hashCode(), (int)rangeSet3.hashCode());
    }
}

