/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.assignor.RangeAssignor;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.GroupSpecImpl;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.SubscribedTopicDescriberImpl;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RangeAssignorTest {
    private final RangeAssignor assignor = new RangeAssignor();
    private final Uuid topic1Uuid = Uuid.randomUuid();
    private final String topic1Name = "topic1";
    private final Uuid topic2Uuid = Uuid.randomUuid();
    private final String topic2Name = "topic2";
    private final Uuid topic3Uuid = Uuid.randomUuid();
    private final String topic3Name = "topic3";
    private final String memberA = "A";
    private final String memberB = "B";
    private final String memberC = "C";

    @Test
    public void testOneMemberNoTopic() {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3)));
        Map<String, MemberSubscriptionAndAssignmentImpl> members = Collections.singletonMap("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.emptySet(), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        GroupAssignment groupAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        Map<String, MemberAssignmentImpl> expectedAssignment = Collections.singletonMap("A", new MemberAssignmentImpl(Collections.emptyMap()));
        Assertions.assertEquals(expectedAssignment, (Object)groupAssignment.members());
    }

    @Test
    public void testOneMemberSubscribedToNonExistentTopic() {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3)));
        Map<String, MemberSubscriptionAndAssignmentImpl> members = Collections.singletonMap("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic2Uuid), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        Assertions.assertThrows(PartitionAssignorException.class, () -> this.lambda$testOneMemberSubscribedToNonExistentTopic$0((GroupSpec)groupSpec, subscribedTopicMetadata));
    }

    @Test
    public void testFirstAssignmentTwoMembersTwoTopicsSameSubscriptions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic3Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic3Uuid), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testFirstAssignmentThreeMembersThreeTopicsDifferentSubscriptions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic3Uuid), Assignment.EMPTY));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic2Uuid, this.topic3Uuid), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testFirstAssignmentNumMembersGreaterThanNumPartitions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic3Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic3Uuid), Assignment.EMPTY));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic3Uuid), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testStaticMembership() throws PartitionAssignorException {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3)));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.of("instanceA"), Collections.singleton(this.topic1Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.of("instanceB"), Collections.singleton(this.topic1Uuid), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        GroupAssignment initialAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        members.remove("A");
        members.put("memberA1", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.of("instanceA"), Collections.singleton(this.topic1Uuid), Assignment.EMPTY));
        groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        GroupAssignment reassignedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        Assertions.assertEquals((Object)((MemberAssignment)initialAssignment.members().get("A")).partitions(), (Object)((MemberAssignment)reassignedAssignment.members().get("memberA1")).partitions());
        Assertions.assertEquals((Object)((MemberAssignment)initialAssignment.members().get("B")).partitions(), (Object)((MemberAssignment)reassignedAssignment.members().get("B")).partitions());
    }

    @Test
    public void testMixedStaticMembership() throws PartitionAssignorException {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 5)));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.of("instanceA"), Collections.singleton(this.topic1Uuid), Assignment.EMPTY));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.of("instanceC"), Collections.singleton(this.topic1Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic1Uuid), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        GroupAssignment initialAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        members.remove("A");
        members.put("memberA1", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.of("instanceA"), Collections.singleton(this.topic1Uuid), Assignment.EMPTY));
        groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        GroupAssignment reassignedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        Assertions.assertEquals((Object)((MemberAssignment)initialAssignment.members().get("A")).partitions(), (Object)((MemberAssignment)reassignedAssignment.members().get("memberA1")).partitions());
        Assertions.assertEquals((Object)((MemberAssignment)initialAssignment.members().get("B")).partitions(), (Object)((MemberAssignment)reassignedAssignment.members().get("B")).partitions());
        Assertions.assertEquals((Object)((MemberAssignment)initialAssignment.members().get("C")).partitions(), (Object)((MemberAssignment)reassignedAssignment.members().get("C")).partitions());
    }

    @Test
    public void testReassignmentNumMembersGreaterThanNumPartitionsWhenOneMemberAdded() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 2));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)))));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        expectedAssignment.put("C", Collections.emptyMap());
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOnePartitionAddedForTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 4));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 4));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)))));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2, 3), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2, 3)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberAddedAfterInitialAssignmentWithTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)))));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberAddedAndOnePartitionAfterInitialAssignmentWithTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 4));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)))));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 3)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberRemovedAfterInitialAssignmentWithTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)))));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenMultipleSubscriptionsRemovedAfterInitialAssignmentWithThreeMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)))));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)))));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    private void assertAssignment(Map<String, Map<Uuid, Set<Integer>>> expectedAssignment, GroupAssignment computedGroupAssignment) {
        Assertions.assertEquals((int)expectedAssignment.size(), (int)computedGroupAssignment.members().size());
        for (String memberId : computedGroupAssignment.members().keySet()) {
            Map computedAssignmentForMember = ((MemberAssignment)computedGroupAssignment.members().get(memberId)).partitions();
            Assertions.assertEquals(expectedAssignment.get(memberId), (Object)computedAssignmentForMember);
        }
    }

    private /* synthetic */ void lambda$testOneMemberSubscribedToNonExistentTopic$0(GroupSpec groupSpec, SubscribedTopicDescriberImpl subscribedTopicMetadata) throws Throwable {
        this.assignor.assign(groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
    }
}

