/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.assignor.UniformAssignor;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.GroupSpecImpl;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.SubscribedTopicDescriberImpl;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptimizedUniformAssignmentBuilderTest {
    private final UniformAssignor assignor = new UniformAssignor();
    private final Uuid topic1Uuid = Uuid.fromString((String)"T1-A4s3VTwiI5CTbEp6POw");
    private final Uuid topic2Uuid = Uuid.fromString((String)"T2-B4s3VTwiI5YHbPp6YUe");
    private final Uuid topic3Uuid = Uuid.fromString((String)"T3-CU8fVTLCz5YMkLoDQsa");
    private final String topic1Name = "topic1";
    private final String topic2Name = "topic2";
    private final String topic3Name = "topic3";
    private final String memberA = "A";
    private final String memberB = "B";
    private final String memberC = "C";

    @Test
    public void testOneMemberNoTopicSubscription() {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3)));
        Map<String, MemberSubscriptionAndAssignmentImpl> members = Collections.singletonMap("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.emptySet(), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        GroupAssignment groupAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        Assertions.assertEquals(Collections.emptyMap(), (Object)groupAssignment.members());
    }

    @Test
    public void testOneMemberSubscribedToNonexistentTopic() {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3)));
        Map<String, MemberSubscriptionAndAssignmentImpl> members = Collections.singletonMap("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic2Uuid), Assignment.EMPTY));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        Assertions.assertThrows(PartitionAssignorException.class, () -> this.lambda$testOneMemberSubscribedToNonexistentTopic$0((GroupSpec)groupSpec, subscribedTopicMetadata));
    }

    @Test
    public void testFirstAssignmentTwoMembersTwoTopicsNoMemberRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic3Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic3Uuid), Assignment.EMPTY));
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2)));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testFirstAssignmentNumMembersGreaterThanTotalNumPartitions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic3Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic3Uuid), Assignment.EMPTY));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic3Uuid), Assignment.EMPTY));
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", Collections.emptyMap());
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testValidityAndBalanceForLargeSampleSet() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        for (int i = 1; i < 100; ++i) {
            Uuid topicId = Uuid.randomUuid();
            topicMetadata.put(topicId, new TopicMetadata(topicId, "topic-" + i, 3));
        }
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        for (int i = 1; i < 50; ++i) {
            members.put("member" + i, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), topicMetadata.keySet(), Assignment.EMPTY));
        }
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, Collections.emptyMap());
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentForTwoMembersTwoTopicsGivenUnbalancedPrevAssignment() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkOrderedAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkOrderedAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)))));
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentWhenPartitionsAreAddedForTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 6));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 5));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkOrderedAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkOrderedAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)))));
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 3, 4)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberAddedAfterInitialAssignmentWithTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkOrderedAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkOrderedAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)))));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), Assignment.EMPTY));
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 2)));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberRemovedAfterInitialAssignmentWithThreeMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)))));
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneSubscriptionRemovedAfterInitialAssignmentWithTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 2));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)))));
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentStickinessWhenAlreadyBalanced() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 5));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 3)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1)))));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2, 4)))));
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 3)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2, 4)));
        GroupSpecImpl groupSpec = new GroupSpecImpl(members, SubscriptionType.HOMOGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    private void checkValidityAndBalance(Map<String, MemberSubscriptionAndAssignmentImpl> memberSubscriptionSpec, GroupAssignment computedGroupAssignment) {
        ArrayList membersList = new ArrayList(computedGroupAssignment.members().keySet());
        int numMembers = membersList.size();
        ArrayList totalAssignmentSizesOfAllMembers = new ArrayList(membersList.size());
        membersList.forEach(member -> {
            Map computedAssignmentForMember = ((MemberAssignment)computedGroupAssignment.members().get(member)).partitions();
            int sum = computedAssignmentForMember.values().stream().mapToInt(Set::size).sum();
            totalAssignmentSizesOfAllMembers.add(sum);
        });
        for (int i = 0; i < numMembers; ++i) {
            String memberId = (String)membersList.get(i);
            Map computedAssignmentForMember = ((MemberAssignment)computedGroupAssignment.members().get(memberId)).partitions();
            computedAssignmentForMember.keySet().forEach(topicId -> Assertions.assertTrue((boolean)((MemberSubscriptionAndAssignmentImpl)memberSubscriptionSpec.get(memberId)).subscribedTopicIds().contains(topicId), (String)("Error: Partitions for topic " + String.valueOf(topicId) + " are assigned to member " + memberId + " but it is not part of the members subscription ")));
            for (int j = i + 1; j < numMembers; ++j) {
                String otherMemberId = (String)membersList.get(j);
                Map computedAssignmentForOtherMember = ((MemberAssignment)computedGroupAssignment.members().get(otherMemberId)).partitions();
                computedAssignmentForMember.keySet().forEach(topicId -> {
                    HashSet intersection = new HashSet();
                    if (computedAssignmentForOtherMember.containsKey(topicId)) {
                        intersection = new HashSet((Collection)computedAssignmentForMember.get(topicId));
                        intersection.retainAll((Collection)computedAssignmentForOtherMember.get(topicId));
                    }
                    Assertions.assertTrue((boolean)intersection.isEmpty(), (String)("Error : Member 1 " + memberId + " and Member 2 " + otherMemberId + "have common partitions assigned to them " + String.valueOf(computedAssignmentForOtherMember.get(topicId))));
                });
                int size1 = (Integer)totalAssignmentSizesOfAllMembers.get(i);
                int size2 = (Integer)totalAssignmentSizesOfAllMembers.get(j);
                Assertions.assertTrue((Math.abs(size1 - size2) <= 1 ? 1 : 0) != 0, (String)("Size of one assignment is greater than the other assignment by more than one partition " + size1 + " " + size2 + "abs = " + Math.abs(size1 - size2)));
            }
        }
    }

    private /* synthetic */ void lambda$testOneMemberSubscribedToNonexistentTopic$0(GroupSpec groupSpec, SubscribedTopicDescriberImpl subscribedTopicMetadata) throws Throwable {
        this.assignor.assign(groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
    }
}

