/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.time.Duration;
import java.time.Instant;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.coordinator.group.ShareGroupAutoOffsetResetStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShareGroupAutoOffsetResetStrategyTest {
    @Test
    public void testFromString() {
        Assertions.assertEquals((Object)ShareGroupAutoOffsetResetStrategy.EARLIEST, (Object)ShareGroupAutoOffsetResetStrategy.fromString((String)"earliest"));
        Assertions.assertEquals((Object)ShareGroupAutoOffsetResetStrategy.LATEST, (Object)ShareGroupAutoOffsetResetStrategy.fromString((String)"latest"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupAutoOffsetResetStrategy.fromString((String)"invalid"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupAutoOffsetResetStrategy.fromString((String)"by_duration:invalid"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupAutoOffsetResetStrategy.fromString((String)"by_duration:-PT1H"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupAutoOffsetResetStrategy.fromString((String)"by_duration:"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupAutoOffsetResetStrategy.fromString((String)"by_duration"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupAutoOffsetResetStrategy.fromString((String)"LATEST"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupAutoOffsetResetStrategy.fromString((String)"EARLIEST"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupAutoOffsetResetStrategy.fromString((String)"NONE"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupAutoOffsetResetStrategy.fromString((String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareGroupAutoOffsetResetStrategy.fromString(null));
        ShareGroupAutoOffsetResetStrategy strategy = ShareGroupAutoOffsetResetStrategy.fromString((String)"by_duration:PT1H");
        Assertions.assertEquals((Object)"by_duration", (Object)strategy.name());
    }

    @Test
    public void testValidator() {
        ShareGroupAutoOffsetResetStrategy.Validator validator = new ShareGroupAutoOffsetResetStrategy.Validator();
        Assertions.assertDoesNotThrow(() -> validator.ensureValid("test", (Object)"earliest"));
        Assertions.assertDoesNotThrow(() -> validator.ensureValid("test", (Object)"latest"));
        Assertions.assertDoesNotThrow(() -> validator.ensureValid("test", (Object)"by_duration:PT1H"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"invalid"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"by_duration:invalid"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"by_duration:-PT1H"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"by_duration:"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"by_duration"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"LATEST"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"EARLIEST"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"NONE"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)""));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", null));
    }

    @Test
    public void testEqualsAndHashCode() {
        ShareGroupAutoOffsetResetStrategy earliest1 = ShareGroupAutoOffsetResetStrategy.fromString((String)"earliest");
        ShareGroupAutoOffsetResetStrategy earliest2 = ShareGroupAutoOffsetResetStrategy.fromString((String)"earliest");
        ShareGroupAutoOffsetResetStrategy latest1 = ShareGroupAutoOffsetResetStrategy.fromString((String)"latest");
        ShareGroupAutoOffsetResetStrategy duration1 = ShareGroupAutoOffsetResetStrategy.fromString((String)"by_duration:P2D");
        ShareGroupAutoOffsetResetStrategy duration2 = ShareGroupAutoOffsetResetStrategy.fromString((String)"by_duration:P2D");
        Assertions.assertEquals((Object)earliest1, (Object)earliest2);
        Assertions.assertNotEquals((Object)earliest1, (Object)latest1);
        Assertions.assertEquals((int)earliest1.hashCode(), (int)earliest2.hashCode());
        Assertions.assertNotEquals((int)earliest1.hashCode(), (int)latest1.hashCode());
        Assertions.assertNotEquals((Object)latest1, (Object)duration2);
        Assertions.assertEquals((Object)duration1, (Object)duration2);
    }

    @Test
    public void testTimestamp() {
        ShareGroupAutoOffsetResetStrategy earliest1 = ShareGroupAutoOffsetResetStrategy.fromString((String)"earliest");
        ShareGroupAutoOffsetResetStrategy earliest2 = ShareGroupAutoOffsetResetStrategy.fromString((String)"earliest");
        Assertions.assertEquals((long)-2L, (Long)earliest1.timestamp());
        Assertions.assertEquals((Object)earliest1, (Object)earliest2);
        ShareGroupAutoOffsetResetStrategy latest1 = ShareGroupAutoOffsetResetStrategy.fromString((String)"latest");
        ShareGroupAutoOffsetResetStrategy latest2 = ShareGroupAutoOffsetResetStrategy.fromString((String)"latest");
        Assertions.assertEquals((long)-1L, (Long)latest1.timestamp());
        Assertions.assertEquals((Object)latest1, (Object)latest2);
        ShareGroupAutoOffsetResetStrategy byDuration1 = ShareGroupAutoOffsetResetStrategy.fromString((String)"by_duration:PT1H");
        Long timestamp = byDuration1.timestamp();
        Assertions.assertTrue((timestamp <= Instant.now().toEpochMilli() - Duration.ofHours(1L).toMillis() ? 1 : 0) != 0);
        ShareGroupAutoOffsetResetStrategy byDuration2 = ShareGroupAutoOffsetResetStrategy.fromString((String)"by_duration:PT1H");
        ShareGroupAutoOffsetResetStrategy byDuration3 = ShareGroupAutoOffsetResetStrategy.fromString((String)"by_duration:PT2H");
        Assertions.assertEquals((Object)byDuration1, (Object)byDuration2);
        Assertions.assertNotEquals((Object)byDuration1, (Object)byDuration3);
    }
}

