/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.OffsetExpirationConditionImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OffsetExpirationConditionImplTest {
    @Test
    public void testIsOffsetExpired() {
        long currentTimestamp = 1500L;
        long commitTimestamp = 500L;
        OptionalLong expireTimestampMs = OptionalLong.of(1500L);
        long offsetsRetentionMs = 500L;
        OffsetExpirationConditionImpl condition = new OffsetExpirationConditionImpl(__ -> commitTimestamp);
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(100L, OptionalInt.of(1), "metadata", commitTimestamp, expireTimestampMs);
        Assertions.assertTrue((boolean)condition.isOffsetExpired(offsetAndMetadata, currentTimestamp, offsetsRetentionMs));
        currentTimestamp = 499L;
        Assertions.assertFalse((boolean)condition.isOffsetExpired(offsetAndMetadata, currentTimestamp, offsetsRetentionMs));
        offsetAndMetadata = new OffsetAndMetadata(100L, OptionalInt.of(1), "metadata", commitTimestamp, OptionalLong.empty());
        currentTimestamp = 1000L;
        Assertions.assertTrue((boolean)condition.isOffsetExpired(offsetAndMetadata, currentTimestamp, offsetsRetentionMs));
        currentTimestamp = 999L;
        Assertions.assertFalse((boolean)condition.isOffsetExpired(offsetAndMetadata, currentTimestamp, offsetsRetentionMs));
    }
}

