/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfigTest;
import org.apache.kafka.coordinator.group.HighestOffsetCommitRateGroupsLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HighestOffsetCommitRateGroupsLoggerTest {
    private final HighestOffsetCommitRateGroupsLogger logger = new HighestOffsetCommitRateGroupsLogger(this.createGroupCoordinatorConfig());

    private GroupCoordinatorConfig createGroupCoordinatorConfig() {
        return GroupCoordinatorConfigTest.createGroupCoordinatorConfig(4096, 1000L, 1440);
    }

    @Test
    public void testNoGroups() {
        Assertions.assertEquals((Object)"Top 0 groups with highest offset commit rate:", (Object)this.logger.logHighestOffsetCommitRateGroups(3));
    }

    @Test
    public void testTopN() {
        int i;
        for (int group = 0; group < 100; ++group) {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.logger.onOffsetCommit("group" + group);
            }
        }
        for (i = 0; i < 300; ++i) {
            this.logger.onTransactionalOffsetCommit("group1");
            this.logger.onTransactionalOffsetCommit("group72");
            this.logger.onTransactionalOffsetCommit("group99");
        }
        for (i = 0; i < 3000; ++i) {
            this.logger.onOffsetCommit("group1");
            this.logger.onOffsetCommit("group99");
            this.logger.onOffsetCommit("group99");
        }
        Assertions.assertEquals((Object)"Top 3 groups with highest offset commit rate:\n     21.01/s group99\n     11.01/s group1\n      1.01/s group72", (Object)this.logger.logHighestOffsetCommitRateGroups(3));
    }

    @Test
    public void testResetAfterLog() {
        for (int i = 0; i < 6; ++i) {
            this.logger.onOffsetCommit("group1");
        }
        Assertions.assertEquals((Object)"Top 1 groups with highest offset commit rate:\n      0.02/s group1", (Object)this.logger.logHighestOffsetCommitRateGroups(3));
        Assertions.assertEquals((Object)"Top 0 groups with highest offset commit rate:", (Object)this.logger.logHighestOffsetCommitRateGroups(3));
    }
}

