/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetrics;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetricsShard;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.common.runtime.CoordinatorTimer;
import org.apache.kafka.coordinator.common.runtime.MockCoordinatorTimer;
import org.apache.kafka.coordinator.common.runtime.TestUtil;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfigTest;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.GroupCoordinatorShard;
import org.apache.kafka.coordinator.group.GroupMetadataManager;
import org.apache.kafka.coordinator.group.OffsetMetadataManager;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.LegacyOffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.LegacyOffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataValue;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GroupCoordinatorShardTest {
    @Test
    public void testConsumerGroupHeartbeat() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        RequestContext context = TestUtil.requestContext((ApiKeys)ApiKeys.CONSUMER_GROUP_HEARTBEAT);
        ConsumerGroupHeartbeatRequestData request = new ConsumerGroupHeartbeatRequestData();
        CoordinatorResult result = new CoordinatorResult(Collections.emptyList(), (Object)new ConsumerGroupHeartbeatResponseData());
        Mockito.when((Object)groupMetadataManager.consumerGroupHeartbeat(context, request)).thenReturn((Object)result);
        Assertions.assertEquals((Object)result, (Object)coordinator.consumerGroupHeartbeat(context, request));
    }

    @Test
    public void testCommitOffset() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        RequestContext context = TestUtil.requestContext((ApiKeys)ApiKeys.OFFSET_COMMIT);
        OffsetCommitRequestData request = new OffsetCommitRequestData();
        CoordinatorResult result = new CoordinatorResult(Collections.emptyList(), (Object)new OffsetCommitResponseData());
        Mockito.when((Object)offsetMetadataManager.commitOffset(context, request)).thenReturn((Object)result);
        Assertions.assertEquals((Object)result, (Object)coordinator.commitOffset(context, request));
    }

    @Test
    public void testCommitTransactionalOffset() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer((Time)new MockTime()), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        RequestContext context = TestUtil.requestContext((ApiKeys)ApiKeys.TXN_OFFSET_COMMIT);
        TxnOffsetCommitRequestData request = new TxnOffsetCommitRequestData();
        CoordinatorResult result = new CoordinatorResult(Collections.emptyList(), (Object)new TxnOffsetCommitResponseData());
        Mockito.when((Object)offsetMetadataManager.commitTransactionalOffset(context, request)).thenReturn((Object)result);
        Assertions.assertEquals((Object)result, (Object)coordinator.commitTransactionalOffset(context, request));
    }

    @Test
    public void testDeleteGroups() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class), (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class));
        RequestContext context = TestUtil.requestContext((ApiKeys)ApiKeys.DELETE_GROUPS);
        List<String> groupIds = Arrays.asList("group-id-1", "group-id-2");
        DeleteGroupsResponseData.DeletableGroupResultCollection expectedResultCollection = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        ArrayList<CoordinatorRecord> expectedRecords = new ArrayList<CoordinatorRecord>();
        for (String groupId : groupIds) {
            expectedResultCollection.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId));
            expectedRecords.addAll(Arrays.asList(GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord((String)groupId, (String)"topic-name", (int)0), GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)groupId)));
        }
        CoordinatorResult expectedResult = new CoordinatorResult(expectedRecords, (Object)expectedResultCollection);
        Mockito.when((Object)offsetMetadataManager.deleteAllOffsets(ArgumentMatchers.anyString(), ArgumentMatchers.anyList())).thenAnswer(invocation -> {
            String groupId = (String)invocation.getArgument(0);
            List records = (List)invocation.getArgument(1);
            records.add(GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord((String)groupId, (String)"topic-name", (int)0));
            return 1;
        });
        ((GroupMetadataManager)Mockito.doAnswer(invocation -> {
            String groupId = (String)invocation.getArgument(0);
            List records = (List)invocation.getArgument(1);
            records.add(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)groupId));
            return null;
        }).when((Object)groupMetadataManager)).createGroupTombstoneRecords(ArgumentMatchers.anyString(), ArgumentMatchers.anyList());
        CoordinatorResult coordinatorResult = coordinator.deleteGroups(context, groupIds);
        for (String groupId : groupIds) {
            ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).validateDeleteGroup((String)ArgumentMatchers.eq((Object)groupId));
            ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).createGroupTombstoneRecords((String)ArgumentMatchers.eq((Object)groupId), ArgumentMatchers.anyList());
            ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).deleteAllOffsets((String)ArgumentMatchers.eq((Object)groupId), ArgumentMatchers.anyList());
        }
        Assertions.assertEquals((Object)expectedResult, (Object)coordinatorResult);
    }

    @Test
    public void testDeleteGroupsInvalidGroupId() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class), (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class));
        RequestContext context = TestUtil.requestContext((ApiKeys)ApiKeys.DELETE_GROUPS);
        List<String> groupIds = Arrays.asList("group-id-1", "group-id-2", "group-id-3");
        DeleteGroupsResponseData.DeletableGroupResultCollection expectedResultCollection = new DeleteGroupsResponseData.DeletableGroupResultCollection(Arrays.asList(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-id-1"), new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-id-2").setErrorCode(Errors.INVALID_GROUP_ID.code()), new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-id-3")).iterator());
        List<CoordinatorRecord> expectedRecords = Arrays.asList(GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord((String)"group-id-1", (String)"topic-name", (int)0), GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id-1"), GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord((String)"group-id-3", (String)"topic-name", (int)0), GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id-3"));
        CoordinatorResult expectedResult = new CoordinatorResult(expectedRecords, (Object)expectedResultCollection);
        ((GroupMetadataManager)Mockito.doThrow((Throwable[])new Throwable[]{Errors.INVALID_GROUP_ID.exception()}).when((Object)groupMetadataManager)).validateDeleteGroup((String)ArgumentMatchers.eq((Object)"group-id-2"));
        ((OffsetMetadataManager)Mockito.doAnswer(invocation -> {
            String groupId = (String)invocation.getArgument(0);
            List records = (List)invocation.getArgument(1);
            records.add(GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord((String)groupId, (String)"topic-name", (int)0));
            return null;
        }).when((Object)offsetMetadataManager)).deleteAllOffsets(ArgumentMatchers.anyString(), ArgumentMatchers.anyList());
        ((GroupMetadataManager)Mockito.doAnswer(invocation -> {
            String groupId = (String)invocation.getArgument(0);
            List records = (List)invocation.getArgument(1);
            records.add(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)groupId));
            return null;
        }).when((Object)groupMetadataManager)).createGroupTombstoneRecords(ArgumentMatchers.anyString(), ArgumentMatchers.anyList());
        CoordinatorResult coordinatorResult = coordinator.deleteGroups(context, groupIds);
        for (String groupId : groupIds) {
            ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).validateDeleteGroup((String)ArgumentMatchers.eq((Object)groupId));
            if (groupId.equals("group-id-2")) continue;
            ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).createGroupTombstoneRecords((String)ArgumentMatchers.eq((Object)groupId), ArgumentMatchers.anyList());
            ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).deleteAllOffsets((String)ArgumentMatchers.eq((Object)groupId), ArgumentMatchers.anyList());
        }
        Assertions.assertEquals((Object)expectedResult, (Object)coordinatorResult);
    }

    @Test
    public void testReplayOffsetCommit() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        OffsetCommitKey key = new OffsetCommitKey().setGroup("goo").setTopic("foo").setPartition(0);
        OffsetCommitValue value = new OffsetCommitValue().setOffset(100L).setCommitTimestamp(12345L).setExpireTimestamp(6789L).setMetadata("Metadata").setLeaderEpoch(10);
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)new LegacyOffsetCommitKey().setGroup("goo").setTopic("foo").setPartition(0), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new LegacyOffsetCommitValue().setOffset(100L).setCommitTimestamp(12345L).setMetadata("Metadata"), 0)));
        coordinator.replay(1L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(0L, -1L, new OffsetCommitKey().setGroup("goo").setTopic("foo").setPartition(0), new OffsetCommitValue().setOffset(100L).setCommitTimestamp(12345L).setMetadata("Metadata"));
        ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(1L, -1L, key, value);
    }

    @Test
    public void testReplayTransactionalOffsetCommit() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer((Time)new MockTime()), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        OffsetCommitKey key = new OffsetCommitKey().setGroup("goo").setTopic("foo").setPartition(0);
        OffsetCommitValue value = new OffsetCommitValue().setOffset(100L).setCommitTimestamp(12345L).setExpireTimestamp(6789L).setMetadata("Metadata").setLeaderEpoch(10);
        coordinator.replay(0L, 100L, (short)0, CoordinatorRecord.record((ApiMessage)new LegacyOffsetCommitKey().setGroup("goo").setTopic("foo").setPartition(0), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new LegacyOffsetCommitValue().setOffset(100L).setCommitTimestamp(12345L).setMetadata("Metadata"), 0)));
        coordinator.replay(1L, 101L, (short)1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(0L, 100L, new OffsetCommitKey().setGroup("goo").setTopic("foo").setPartition(0), new OffsetCommitValue().setOffset(100L).setCommitTimestamp(12345L).setMetadata("Metadata"));
        ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(1L, 101L, key, value);
    }

    @Test
    public void testReplayOffsetCommitWithNullValue() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        OffsetCommitKey key = new OffsetCommitKey().setGroup("goo").setTopic("foo").setPartition(0);
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)new LegacyOffsetCommitKey().setGroup("goo").setTopic("foo").setPartition(0)));
        coordinator.replay(1L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(0L, -1L, key, null);
        ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(1L, -1L, key, null);
    }

    @Test
    public void testReplayConsumerGroupMetadata() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupMetadataKey key = new ConsumerGroupMetadataKey();
        ConsumerGroupMetadataValue value = new ConsumerGroupMetadataValue();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, value);
    }

    @Test
    public void testReplayConsumerGroupMetadataWithNullValue() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupMetadataKey key = new ConsumerGroupMetadataKey();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, null);
    }

    @Test
    public void testReplayConsumerGroupPartitionMetadata() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupPartitionMetadataKey key = new ConsumerGroupPartitionMetadataKey();
        ConsumerGroupPartitionMetadataValue value = new ConsumerGroupPartitionMetadataValue();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, value);
    }

    @Test
    public void testReplayConsumerGroupPartitionMetadataWithNullValue() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupPartitionMetadataKey key = new ConsumerGroupPartitionMetadataKey();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, null);
    }

    @Test
    public void testReplayConsumerGroupMemberMetadata() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupMemberMetadataKey key = new ConsumerGroupMemberMetadataKey();
        ConsumerGroupMemberMetadataValue value = new ConsumerGroupMemberMetadataValue();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, value);
    }

    @Test
    public void testReplayConsumerGroupMemberMetadataWithNullValue() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupMemberMetadataKey key = new ConsumerGroupMemberMetadataKey();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, null);
    }

    @Test
    public void testReplayConsumerGroupTargetAssignmentMetadata() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupTargetAssignmentMetadataKey key = new ConsumerGroupTargetAssignmentMetadataKey();
        ConsumerGroupTargetAssignmentMetadataValue value = new ConsumerGroupTargetAssignmentMetadataValue();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, value);
    }

    @Test
    public void testReplayConsumerGroupTargetAssignmentMetadataWithNullValue() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupTargetAssignmentMetadataKey key = new ConsumerGroupTargetAssignmentMetadataKey();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, null);
    }

    @Test
    public void testReplayConsumerGroupTargetAssignmentMember() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupTargetAssignmentMemberKey key = new ConsumerGroupTargetAssignmentMemberKey();
        ConsumerGroupTargetAssignmentMemberValue value = new ConsumerGroupTargetAssignmentMemberValue();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, value);
    }

    @Test
    public void testReplayConsumerGroupTargetAssignmentMemberKeyWithNullValue() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupTargetAssignmentMemberKey key = new ConsumerGroupTargetAssignmentMemberKey();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, null);
    }

    @Test
    public void testReplayConsumerGroupCurrentMemberAssignment() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupCurrentMemberAssignmentKey key = new ConsumerGroupCurrentMemberAssignmentKey();
        ConsumerGroupCurrentMemberAssignmentValue value = new ConsumerGroupCurrentMemberAssignmentValue();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, value);
    }

    @Test
    public void testReplayConsumerGroupCurrentMemberAssignmentWithNullValue() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupCurrentMemberAssignmentKey key = new ConsumerGroupCurrentMemberAssignmentKey();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, null);
    }

    @Test
    public void testReplayKeyCannotBeNull() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        Assertions.assertThrows(NullPointerException.class, () -> coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record(null, null)));
    }

    @Test
    public void testOnLoaded() {
        MetadataImage image = MetadataImage.EMPTY;
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        coordinator.onLoaded(image);
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).onNewMetadataImage((MetadataImage)ArgumentMatchers.eq((Object)image), (MetadataDelta)ArgumentMatchers.any());
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).onLoaded();
    }

    @Test
    public void testReplayGroupMetadata() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        GroupMetadataKey key = new GroupMetadataKey();
        GroupMetadataValue value = new GroupMetadataValue();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 4)));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, value);
    }

    @Test
    public void testReplayGroupMetadataWithNullValue() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        GroupMetadataKey key = new GroupMetadataKey();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, null);
    }

    @Test
    public void testScheduleCleanupGroupMetadata() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        MockTime mockTime = new MockTime();
        MockCoordinatorTimer timer = new MockCoordinatorTimer((Time)mockTime);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, (Time)mockTime, (CoordinatorTimer)timer, GroupCoordinatorConfigTest.createGroupCoordinatorConfig(4096, 1000L, 1440), (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class), (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class));
        MetadataImage image = MetadataImage.EMPTY;
        coordinator.onLoaded(image);
        Assertions.assertTrue((boolean)timer.contains("expire-group-metadata"));
        mockTime.sleep(1000L);
        List tasks = timer.poll();
        Assertions.assertEquals((int)1, (int)tasks.size());
        Assertions.assertTrue((boolean)timer.contains("expire-group-metadata"));
        coordinator.onUnloaded();
        Assertions.assertFalse((boolean)timer.contains("expire-group-metadata"));
    }

    @Test
    public void testCleanupGroupMetadata() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        MockTime mockTime = new MockTime();
        MockCoordinatorTimer timer = new MockCoordinatorTimer((Time)mockTime);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, (Time)mockTime, (CoordinatorTimer)timer, (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class), (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class));
        CoordinatorRecord offsetCommitTombstone = GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord((String)"group-id", (String)"topic", (int)0);
        CoordinatorRecord groupMetadataTombstone = GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id");
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(List.class);
        Mockito.when((Object)groupMetadataManager.groupIds()).thenReturn(Set.of("group-id", "other-group-id"));
        Mockito.when((Object)offsetMetadataManager.cleanupExpiredOffsets((String)ArgumentMatchers.eq((Object)"group-id"), (List)recordsCapture.capture())).thenAnswer(invocation -> {
            List records = (List)recordsCapture.getValue();
            records.add(offsetCommitTombstone);
            return true;
        });
        Mockito.when((Object)offsetMetadataManager.cleanupExpiredOffsets("other-group-id", Collections.emptyList())).thenReturn((Object)false);
        ((GroupMetadataManager)Mockito.doAnswer(invocation -> {
            List records = (List)recordsCapture.getValue();
            records.add(groupMetadataTombstone);
            return null;
        }).when((Object)groupMetadataManager)).maybeDeleteGroup((String)ArgumentMatchers.eq((Object)"group-id"), (List)recordsCapture.capture());
        Assertions.assertFalse((boolean)timer.contains("expire-group-metadata"));
        CoordinatorResult result = coordinator.cleanupGroupMetadata();
        Assertions.assertTrue((boolean)timer.contains("expire-group-metadata"));
        List<CoordinatorRecord> expectedRecords = Arrays.asList(offsetCommitTombstone, groupMetadataTombstone);
        Assertions.assertEquals(expectedRecords, (Object)result.records());
        Assertions.assertNull((Object)result.response());
        Assertions.assertNull((Object)result.appendFuture());
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).groupIds();
        ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).cleanupExpiredOffsets((String)ArgumentMatchers.eq((Object)"group-id"), (List)ArgumentMatchers.any());
        ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).cleanupExpiredOffsets((String)ArgumentMatchers.eq((Object)"other-group-id"), (List)ArgumentMatchers.any());
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).maybeDeleteGroup((String)ArgumentMatchers.eq((Object)"group-id"), (List)ArgumentMatchers.any());
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)0))).maybeDeleteGroup((String)ArgumentMatchers.eq((Object)"other-group-id"), (List)ArgumentMatchers.any());
    }

    @Test
    public void testScheduleGroupMetricsUpdateTask() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        MockTime time = new MockTime();
        MockCoordinatorTimer timer = new MockCoordinatorTimer((Time)time);
        GroupCoordinatorConfig config = (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class);
        Mockito.when((Object)config.offsetsRetentionCheckIntervalMs()).thenReturn((Object)3600000L);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)timer, config, coordinatorMetrics, metricsShard);
        coordinator.onLoaded(MetadataImage.EMPTY);
        Assertions.assertEquals((long)60000L, (long)(timer.timeout((String)"group-metrics-update-task").deadlineMs - time.milliseconds()));
        time.sleep(60001L);
        timer.poll();
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).updateGroupMetrics();
        Assertions.assertEquals((long)60000L, (long)(timer.timeout((String)"group-metrics-update-task").deadlineMs - time.milliseconds()));
    }

    @ParameterizedTest
    @EnumSource(value=TransactionResult.class)
    public void testReplayEndTransactionMarker(TransactionResult result) {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        coordinator.replayEndTransactionMarker(100L, (short)5, result);
        ((OffsetMetadataManager)Mockito.verify((Object)offsetMetadataManager, (VerificationMode)Mockito.times((int)1))).replayEndTransactionMarker(100L, result);
    }

    @Test
    public void testOnPartitionsDeleted() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        List<CoordinatorRecord> records = Collections.singletonList(GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord((String)"group", (String)"foo", (int)0));
        Mockito.when((Object)offsetMetadataManager.onPartitionsDeleted(Collections.singletonList(new TopicPartition("foo", 0)))).thenReturn(records);
        CoordinatorResult result = coordinator.onPartitionsDeleted(Collections.singletonList(new TopicPartition("foo", 0)));
        Assertions.assertEquals(records, (Object)result.records());
        Assertions.assertNull((Object)result.response());
    }

    @Test
    public void testOnUnloaded() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        MockTime mockTime = new MockTime();
        MockCoordinatorTimer timer = new MockCoordinatorTimer((Time)mockTime);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, (Time)mockTime, (CoordinatorTimer)timer, GroupCoordinatorConfigTest.createGroupCoordinatorConfig(4096, 1000L, 1440), (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class), (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class));
        coordinator.onUnloaded();
        Assertions.assertEquals((int)0, (int)timer.size());
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).onUnloaded();
    }

    @Test
    public void testShareGroupHeartbeat() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        RequestContext context = TestUtil.requestContext((ApiKeys)ApiKeys.SHARE_GROUP_HEARTBEAT);
        ShareGroupHeartbeatRequestData request = new ShareGroupHeartbeatRequestData();
        CoordinatorResult result = new CoordinatorResult(Collections.emptyList(), (Object)new ShareGroupHeartbeatResponseData());
        Mockito.when((Object)groupMetadataManager.shareGroupHeartbeat(context, request)).thenReturn((Object)result);
        Assertions.assertEquals((Object)result, (Object)coordinator.shareGroupHeartbeat(context, request));
    }

    @Test
    public void testReplayShareGroupMetadata() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ShareGroupMetadataKey key = new ShareGroupMetadataKey();
        ShareGroupMetadataValue value = new ShareGroupMetadataValue();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, value);
    }

    @Test
    public void testReplayShareGroupMetadataWithNullValue() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ShareGroupMetadataKey key = new ShareGroupMetadataKey();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, null);
    }

    @Test
    public void testReplayShareGroupMemberMetadata() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ShareGroupMemberMetadataKey key = new ShareGroupMemberMetadataKey();
        ShareGroupMemberMetadataValue value = new ShareGroupMemberMetadataValue();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, value);
    }

    @Test
    public void testReplayShareGroupMemberMetadataWithNullValue() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ShareGroupMemberMetadataKey key = new ShareGroupMemberMetadataKey();
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, null);
    }

    @Test
    public void testReplayConsumerGroupRegularExpression() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupRegularExpressionKey key = new ConsumerGroupRegularExpressionKey().setGroupId("group").setRegularExpression("ab*");
        ConsumerGroupRegularExpressionValue value = new ConsumerGroupRegularExpressionValue().setTopics(Arrays.asList("abc", "abcd")).setVersion(10L).setTimestamp(12345L);
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.record((ApiMessage)key, (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0)));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, value);
    }

    @Test
    public void testReplayConsumerGroupRegularExpressionTombstone() {
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)Mockito.mock(GroupMetadataManager.class);
        OffsetMetadataManager offsetMetadataManager = (OffsetMetadataManager)Mockito.mock(OffsetMetadataManager.class);
        CoordinatorMetrics coordinatorMetrics = (CoordinatorMetrics)Mockito.mock(CoordinatorMetrics.class);
        CoordinatorMetricsShard metricsShard = (CoordinatorMetricsShard)Mockito.mock(CoordinatorMetricsShard.class);
        GroupCoordinatorShard coordinator = new GroupCoordinatorShard(new LogContext(), groupMetadataManager, offsetMetadataManager, Time.SYSTEM, (CoordinatorTimer)new MockCoordinatorTimer(Time.SYSTEM), (GroupCoordinatorConfig)Mockito.mock(GroupCoordinatorConfig.class), coordinatorMetrics, metricsShard);
        ConsumerGroupRegularExpressionKey key = new ConsumerGroupRegularExpressionKey().setGroupId("group").setRegularExpression("ab*");
        coordinator.replay(0L, -1L, (short)-1, CoordinatorRecord.tombstone((ApiMessage)key));
        ((GroupMetadataManager)Mockito.verify((Object)groupMetadataManager, (VerificationMode)Mockito.times((int)1))).replay(key, null);
    }
}

