/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.net.InetAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.InvalidFetchSizeException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRuntime;
import org.apache.kafka.coordinator.common.runtime.TestUtil;
import org.apache.kafka.coordinator.group.GroupConfigManagerTest;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfigTest;
import org.apache.kafka.coordinator.group.GroupCoordinatorService;
import org.apache.kafka.coordinator.group.GroupCoordinatorShard;
import org.apache.kafka.coordinator.group.GroupMetadataManagerTestContext;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetrics;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.FutureUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GroupCoordinatorServiceTest {
    private CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> mockRuntime() {
        return (CoordinatorRuntime)Mockito.mock(CoordinatorRuntime.class);
    }

    private GroupCoordinatorConfig createConfig() {
        return GroupCoordinatorConfigTest.createGroupCoordinatorConfig(4096, 600000L, 24);
    }

    @Test
    public void testStartupShutdown() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        service.shutdown();
        ((CoordinatorRuntime)Mockito.verify(runtime, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testConsumerGroupHeartbeatWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        ConsumerGroupHeartbeatRequestData request = new ConsumerGroupHeartbeatRequestData().setGroupId("foo");
        CompletableFuture future = service.consumerGroupHeartbeat(TestUtil.requestContext((ApiKeys)ApiKeys.CONSUMER_GROUP_HEARTBEAT), request);
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()), future.get());
    }

    @Test
    public void testConsumerGroupHeartbeat() throws ExecutionException, InterruptedException, TimeoutException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        ConsumerGroupHeartbeatRequestData request = new ConsumerGroupHeartbeatRequestData().setGroupId("foo");
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"consumer-group-heartbeat"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(new ConsumerGroupHeartbeatResponseData()));
        CompletableFuture future = service.consumerGroupHeartbeat(TestUtil.requestContext((ApiKeys)ApiKeys.CONSUMER_GROUP_HEARTBEAT), request);
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData(), future.get(5L, TimeUnit.SECONDS));
    }

    private static Stream<Arguments> testGroupHeartbeatWithExceptionSource() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{new UnknownTopicOrPartitionException(), Errors.COORDINATOR_NOT_AVAILABLE.code(), null}), Arguments.arguments((Object[])new Object[]{new NotEnoughReplicasException(), Errors.COORDINATOR_NOT_AVAILABLE.code(), null}), Arguments.arguments((Object[])new Object[]{new org.apache.kafka.common.errors.TimeoutException(), Errors.COORDINATOR_NOT_AVAILABLE.code(), null}), Arguments.arguments((Object[])new Object[]{new NotLeaderOrFollowerException(), Errors.NOT_COORDINATOR.code(), null}), Arguments.arguments((Object[])new Object[]{new KafkaStorageException(), Errors.NOT_COORDINATOR.code(), null}), Arguments.arguments((Object[])new Object[]{new RecordTooLargeException(), Errors.UNKNOWN_SERVER_ERROR.code(), null}), Arguments.arguments((Object[])new Object[]{new RecordBatchTooLargeException(), Errors.UNKNOWN_SERVER_ERROR.code(), null}), Arguments.arguments((Object[])new Object[]{new InvalidFetchSizeException(""), Errors.UNKNOWN_SERVER_ERROR.code(), null}), Arguments.arguments((Object[])new Object[]{new InvalidRequestException("Invalid"), Errors.INVALID_REQUEST.code(), "Invalid"}));
    }

    @ParameterizedTest
    @MethodSource(value={"testGroupHeartbeatWithExceptionSource"})
    public void testConsumerGroupHeartbeatWithException(Throwable exception, short expectedErrorCode, String expectedErrorMessage) throws ExecutionException, InterruptedException, TimeoutException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        ConsumerGroupHeartbeatRequestData request = new ConsumerGroupHeartbeatRequestData().setGroupId("foo");
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"consumer-group-heartbeat"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)exception));
        CompletableFuture future = service.consumerGroupHeartbeat(TestUtil.requestContext((ApiKeys)ApiKeys.CONSUMER_GROUP_HEARTBEAT), request);
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setErrorCode(expectedErrorCode).setErrorMessage(expectedErrorMessage), future.get(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testPartitionFor() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        Assertions.assertThrows(CoordinatorNotAvailableException.class, () -> service.partitionFor("foo"));
        service.startup(() -> 10);
        Assertions.assertEquals((int)(Utils.abs((int)"foo".hashCode()) % 10), (int)service.partitionFor("foo"));
    }

    @Test
    public void testGroupMetadataTopicConfigs() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        Properties expectedProperties = new Properties();
        expectedProperties.put("cleanup.policy", "compact");
        expectedProperties.put("compression.type", BrokerCompressionType.PRODUCER.name);
        expectedProperties.put("segment.bytes", "1000");
        expectedProperties.put("delete.retention.ms", "86400000");
        expectedProperties.put("min.cleanable.dirty.ratio", "0.5");
        expectedProperties.put("max.compaction.lag.ms", "86400000");
        Assertions.assertEquals((Object)expectedProperties, (Object)service.groupMetadataTopicConfigs());
    }

    @Test
    public void testOnElection() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        Assertions.assertThrows(CoordinatorNotAvailableException.class, () -> service.onElection(5, 10));
        service.startup(() -> 1);
        service.onElection(5, 10);
        ((CoordinatorRuntime)Mockito.verify(runtime, (VerificationMode)Mockito.times((int)1))).scheduleLoadOperation(new TopicPartition("__consumer_offsets", 5), 10);
    }

    @Test
    public void testOnResignation() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        Assertions.assertThrows(CoordinatorNotAvailableException.class, () -> service.onResignation(5, OptionalInt.of(10)));
        service.startup(() -> 1);
        service.onResignation(5, OptionalInt.of(10));
        ((CoordinatorRuntime)Mockito.verify(runtime, (VerificationMode)Mockito.times((int)1))).scheduleUnloadOperation(new TopicPartition("__consumer_offsets", 5), OptionalInt.of(10));
    }

    @Test
    public void testOnResignationWithEmptyLeaderEpoch() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        service.onResignation(5, OptionalInt.empty());
        ((CoordinatorRuntime)Mockito.verify(runtime, (VerificationMode)Mockito.times((int)1))).scheduleUnloadOperation(new TopicPartition("__consumer_offsets", 5), OptionalInt.empty());
    }

    @Test
    public void testJoinGroup() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        JoinGroupRequestData request = new JoinGroupRequestData().setGroupId("foo").setSessionTimeoutMs(1000);
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"classic-group-join"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(new JoinGroupResponseData()));
        CompletableFuture responseFuture = service.joinGroup(TestUtil.requestContext((ApiKeys)ApiKeys.JOIN_GROUP), request, BufferSupplier.NO_CACHING);
        Assertions.assertFalse((boolean)responseFuture.isDone());
    }

    @Test
    public void testJoinGroupWithException() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        JoinGroupRequestData request = new JoinGroupRequestData().setGroupId("foo").setSessionTimeoutMs(1000);
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"classic-group-join"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new IllegalStateException()));
        CompletableFuture future = service.joinGroup(TestUtil.requestContext((ApiKeys)ApiKeys.JOIN_GROUP), request, BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)new JoinGroupResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()), future.get(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testJoinGroupInvalidGroupId() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        JoinGroupRequestData request = new JoinGroupRequestData().setGroupId(null).setMemberId("");
        RequestContext context = new RequestContext(new RequestHeader(ApiKeys.JOIN_GROUP, ApiKeys.JOIN_GROUP.latestVersion(), "client", 0), "1", InetAddress.getLoopbackAddress(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        CompletableFuture response = service.joinGroup(context, request, BufferSupplier.NO_CACHING);
        Assertions.assertTrue((boolean)response.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code()).setMemberId("");
        Assertions.assertEquals((Object)expectedResponse, response.get());
    }

    @Test
    public void testJoinGroupWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        JoinGroupRequestData request = new JoinGroupRequestData().setGroupId("foo");
        CompletableFuture future = service.joinGroup(TestUtil.requestContext((ApiKeys)ApiKeys.JOIN_GROUP), request, BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)new JoinGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()), future.get());
    }

    @ParameterizedTest
    @ValueSource(ints={119, 50001})
    public void testJoinGroupInvalidSessionTimeout(int sessionTimeoutMs) throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorConfig config = this.createConfig();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), config, runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withSessionTimeoutMs(sessionTimeoutMs).build();
        CompletableFuture future = service.joinGroup(TestUtil.requestContext((ApiKeys)ApiKeys.JOIN_GROUP), request, BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)new JoinGroupResponseData().setErrorCode(Errors.INVALID_SESSION_TIMEOUT.code()), future.get());
    }

    @Test
    public void testSyncGroup() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        SyncGroupRequestData request = new SyncGroupRequestData().setGroupId("foo");
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"classic-group-sync"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(new SyncGroupResponseData()));
        CompletableFuture responseFuture = service.syncGroup(TestUtil.requestContext((ApiKeys)ApiKeys.SYNC_GROUP), request, BufferSupplier.NO_CACHING);
        Assertions.assertFalse((boolean)responseFuture.isDone());
    }

    @Test
    public void testSyncGroupWithException() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        SyncGroupRequestData request = new SyncGroupRequestData().setGroupId("foo");
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"classic-group-sync"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new IllegalStateException()));
        CompletableFuture future = service.syncGroup(TestUtil.requestContext((ApiKeys)ApiKeys.SYNC_GROUP), request, BufferSupplier.NO_CACHING);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new SyncGroupResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()), future.get());
    }

    @Test
    public void testSyncGroupInvalidGroupId() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        SyncGroupRequestData request = new SyncGroupRequestData().setGroupId(null).setMemberId("");
        CompletableFuture response = service.syncGroup(TestUtil.requestContext((ApiKeys)ApiKeys.SYNC_GROUP), request, BufferSupplier.NO_CACHING);
        Assertions.assertTrue((boolean)response.isDone());
        SyncGroupResponseData expectedResponse = new SyncGroupResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code());
        Assertions.assertEquals((Object)expectedResponse, response.get());
    }

    @Test
    public void testSyncGroupWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        SyncGroupRequestData request = new SyncGroupRequestData().setGroupId("foo");
        CompletableFuture future = service.syncGroup(TestUtil.requestContext((ApiKeys)ApiKeys.SYNC_GROUP), request, BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)new SyncGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()), future.get());
    }

    @Test
    public void testHeartbeat() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        HeartbeatRequestData request = new HeartbeatRequestData().setGroupId("foo");
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"classic-group-heartbeat"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(new HeartbeatResponseData()));
        CompletableFuture future = service.heartbeat(TestUtil.requestContext((ApiKeys)ApiKeys.HEARTBEAT), request);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new HeartbeatResponseData(), future.get());
    }

    @Test
    public void testHeartbeatCoordinatorNotAvailableException() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        HeartbeatRequestData request = new HeartbeatRequestData().setGroupId("foo");
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"classic-group-heartbeat"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new CoordinatorLoadInProgressException(null)));
        CompletableFuture future = service.heartbeat(TestUtil.requestContext((ApiKeys)ApiKeys.HEARTBEAT), request);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new HeartbeatResponseData(), future.get());
    }

    @Test
    public void testHeartbeatCoordinatorException() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        HeartbeatRequestData request = new HeartbeatRequestData().setGroupId("foo");
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"classic-group-heartbeat"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new RebalanceInProgressException()));
        CompletableFuture future = service.heartbeat(TestUtil.requestContext((ApiKeys)ApiKeys.HEARTBEAT), request);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new HeartbeatResponseData().setErrorCode(Errors.REBALANCE_IN_PROGRESS.code()), future.get());
    }

    @Test
    public void testHeartbeatWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        HeartbeatRequestData request = new HeartbeatRequestData().setGroupId("foo");
        CompletableFuture future = service.heartbeat(TestUtil.requestContext((ApiKeys)ApiKeys.CONSUMER_GROUP_HEARTBEAT), request);
        Assertions.assertEquals((Object)new HeartbeatResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()), future.get());
    }

    @Test
    public void testListGroups() throws ExecutionException, InterruptedException, TimeoutException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 3);
        List<ListGroupsResponseData.ListedGroup> expectedResults = Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group0").setProtocolType("protocol1").setGroupState("Stable").setGroupType("classic"), new ListGroupsResponseData.ListedGroup().setGroupId("group1").setProtocolType("consumer").setGroupState("Empty").setGroupType("consumer"), new ListGroupsResponseData.ListedGroup().setGroupId("group2").setProtocolType("consumer").setGroupState("Dead").setGroupType("consumer"));
        Mockito.when((Object)runtime.scheduleReadAllOperation((String)ArgumentMatchers.eq((Object)"list-groups"), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn(Arrays.asList(CompletableFuture.completedFuture(Collections.singletonList(expectedResults.get(0))), CompletableFuture.completedFuture(Collections.singletonList(expectedResults.get(1))), CompletableFuture.completedFuture(Collections.singletonList(expectedResults.get(2)))));
        CompletableFuture responseFuture = service.listGroups(TestUtil.requestContext((ApiKeys)ApiKeys.LIST_GROUPS), new ListGroupsRequestData());
        Assertions.assertEquals(expectedResults, (Object)((ListGroupsResponseData)responseFuture.get(5L, TimeUnit.SECONDS)).groups());
    }

    @Test
    public void testListGroupsFailedWithNotCoordinatorException() throws InterruptedException, ExecutionException, TimeoutException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 3);
        List<ListGroupsResponseData.ListedGroup> expectedResults = Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group0").setProtocolType("protocol1").setGroupState("Stable").setGroupType("classic"), new ListGroupsResponseData.ListedGroup().setGroupId("group1").setProtocolType("consumer").setGroupState("Empty").setGroupType("consumer"));
        Mockito.when((Object)runtime.scheduleReadAllOperation((String)ArgumentMatchers.eq((Object)"list-groups"), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn(Arrays.asList(CompletableFuture.completedFuture(Collections.singletonList(expectedResults.get(0))), CompletableFuture.completedFuture(Collections.singletonList(expectedResults.get(1))), FutureUtils.failedFuture((Throwable)new NotCoordinatorException(""))));
        CompletableFuture responseFuture = service.listGroups(TestUtil.requestContext((ApiKeys)ApiKeys.LIST_GROUPS), new ListGroupsRequestData());
        Assertions.assertEquals(expectedResults, (Object)((ListGroupsResponseData)responseFuture.get(5L, TimeUnit.SECONDS)).groups());
    }

    @Test
    public void testListGroupsWithFailure() throws InterruptedException, ExecutionException, TimeoutException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 3);
        Mockito.when((Object)runtime.scheduleReadAllOperation((String)ArgumentMatchers.eq((Object)"list-groups"), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn(Arrays.asList(CompletableFuture.completedFuture(Collections.emptyList()), CompletableFuture.completedFuture(Collections.emptyList()), FutureUtils.failedFuture((Throwable)new CoordinatorLoadInProgressException(""))));
        CompletableFuture responseFuture = service.listGroups(TestUtil.requestContext((ApiKeys)ApiKeys.LIST_GROUPS), new ListGroupsRequestData());
        Assertions.assertEquals((Object)new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()), responseFuture.get(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testListGroupsWithEmptyTopicPartitions() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        int partitionCount = 0;
        service.startup(() -> partitionCount);
        ListGroupsRequestData request = new ListGroupsRequestData();
        CompletableFuture future = service.listGroups(TestUtil.requestContext((ApiKeys)ApiKeys.LIST_GROUPS), request);
        Assertions.assertEquals((Object)new ListGroupsResponseData(), future.get());
    }

    @Test
    public void testListGroupsWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        ListGroupsRequestData request = new ListGroupsRequestData();
        CompletableFuture future = service.listGroups(TestUtil.requestContext((ApiKeys)ApiKeys.LIST_GROUPS), request);
        Assertions.assertEquals((Object)new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()), future.get());
    }

    @Test
    public void testDescribeGroups() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, (GroupCoordinatorMetrics)Mockito.mock(GroupCoordinatorMetrics.class), GroupConfigManagerTest.createConfigManager());
        int partitionCount = 2;
        service.startup(() -> partitionCount);
        DescribeGroupsResponseData.DescribedGroup describedGroup1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId("group-id-1");
        DescribeGroupsResponseData.DescribedGroup describedGroup2 = new DescribeGroupsResponseData.DescribedGroup().setGroupId("group-id-2");
        List<DescribeGroupsResponseData.DescribedGroup> expectedDescribedGroups = Arrays.asList(describedGroup1, describedGroup2);
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"describe-groups"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Collections.singletonList(describedGroup1)));
        CompletableFuture<List<DescribeGroupsResponseData.DescribedGroup>> describedGroupFuture = new CompletableFuture<List<DescribeGroupsResponseData.DescribedGroup>>();
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"describe-groups"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 1)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn(describedGroupFuture);
        CompletableFuture future = service.describeGroups(TestUtil.requestContext((ApiKeys)ApiKeys.DESCRIBE_GROUPS), Arrays.asList("group-id-1", "group-id-2"));
        Assertions.assertFalse((boolean)future.isDone());
        describedGroupFuture.complete(Collections.singletonList(describedGroup2));
        Assertions.assertEquals(expectedDescribedGroups, future.get());
    }

    @Test
    public void testDescribeGroupsInvalidGroupId() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, (GroupCoordinatorMetrics)Mockito.mock(GroupCoordinatorMetrics.class), GroupConfigManagerTest.createConfigManager());
        int partitionCount = 1;
        service.startup(() -> partitionCount);
        DescribeGroupsResponseData.DescribedGroup describedGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId("");
        List<DescribeGroupsResponseData.DescribedGroup> expectedDescribedGroups = Arrays.asList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("").setErrorCode(Errors.INVALID_GROUP_ID.code()), describedGroup);
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"describe-groups"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Collections.singletonList(describedGroup)));
        CompletableFuture future = service.describeGroups(TestUtil.requestContext((ApiKeys)ApiKeys.DESCRIBE_GROUPS), Arrays.asList("", null));
        Assertions.assertEquals(expectedDescribedGroups, future.get());
    }

    @Test
    public void testDescribeGroupCoordinatorLoadInProgress() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, (GroupCoordinatorMetrics)Mockito.mock(GroupCoordinatorMetrics.class), GroupConfigManagerTest.createConfigManager());
        int partitionCount = 1;
        service.startup(() -> partitionCount);
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"describe-groups"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new CoordinatorLoadInProgressException(null)));
        CompletableFuture future = service.describeGroups(TestUtil.requestContext((ApiKeys)ApiKeys.DESCRIBE_GROUPS), Collections.singletonList("group-id"));
        Assertions.assertEquals(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group-id").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())), future.get());
    }

    @Test
    public void testDescribeGroupsWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        CompletableFuture future = service.describeGroups(TestUtil.requestContext((ApiKeys)ApiKeys.DESCRIBE_GROUPS), Collections.singletonList("group-id"));
        Assertions.assertEquals(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group-id").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code())), future.get());
    }

    @ParameterizedTest
    @CsvSource(value={"false, false", "false, true", "true, false", "true, true"})
    public void testFetchOffsets(boolean fetchAllOffsets, boolean requireStable) throws ExecutionException, InterruptedException, TimeoutException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        OffsetFetchRequestData.OffsetFetchRequestGroup request = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group");
        if (!fetchAllOffsets) {
            request.setTopics(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setPartitionIndexes(Collections.singletonList(0))));
        }
        OffsetFetchResponseData.OffsetFetchResponseGroup response = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group").setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("foo").setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(100L)))));
        if (requireStable) {
            Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)(fetchAllOffsets ? "fetch-all-offsets" : "fetch-offsets")), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(response));
        } else {
            Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)(fetchAllOffsets ? "fetch-all-offsets" : "fetch-offsets")), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(response));
        }
        TriFunction<RequestContext, OffsetFetchRequestData.OffsetFetchRequestGroup, Boolean, CompletableFuture> fetchOffsets = fetchAllOffsets ? (arg_0, arg_1, arg_2) -> ((GroupCoordinatorService)service).fetchAllOffsets(arg_0, arg_1, arg_2) : (arg_0, arg_1, arg_2) -> ((GroupCoordinatorService)service).fetchOffsets(arg_0, arg_1, arg_2);
        CompletableFuture future = fetchOffsets.apply(TestUtil.requestContext((ApiKeys)ApiKeys.OFFSET_FETCH), request, requireStable);
        Assertions.assertEquals((Object)response, future.get(5L, TimeUnit.SECONDS));
    }

    @ParameterizedTest
    @CsvSource(value={"false, false", "false, true", "true, false", "true, true"})
    public void testFetchOffsetsWhenNotStarted(boolean fetchAllOffsets, boolean requireStable) throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        OffsetFetchRequestData.OffsetFetchRequestGroup request = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group");
        if (!fetchAllOffsets) {
            request.setTopics(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setPartitionIndexes(Collections.singletonList(0))));
        }
        TriFunction<RequestContext, OffsetFetchRequestData.OffsetFetchRequestGroup, Boolean, CompletableFuture> fetchOffsets = fetchAllOffsets ? (arg_0, arg_1, arg_2) -> ((GroupCoordinatorService)service).fetchAllOffsets(arg_0, arg_1, arg_2) : (arg_0, arg_1, arg_2) -> ((GroupCoordinatorService)service).fetchOffsets(arg_0, arg_1, arg_2);
        CompletableFuture future = fetchOffsets.apply(TestUtil.requestContext((ApiKeys)ApiKeys.OFFSET_FETCH), request, requireStable);
        Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()), future.get());
    }

    @ParameterizedTest
    @CsvSource(value={"false, UNKNOWN_TOPIC_OR_PARTITION, NOT_COORDINATOR", "false, NOT_ENOUGH_REPLICAS, NOT_COORDINATOR", "false, REQUEST_TIMED_OUT, NOT_COORDINATOR", "false, NOT_LEADER_OR_FOLLOWER, NOT_COORDINATOR", "false, KAFKA_STORAGE_ERROR, NOT_COORDINATOR", "true, UNKNOWN_TOPIC_OR_PARTITION, NOT_COORDINATOR", "true, NOT_ENOUGH_REPLICAS, NOT_COORDINATOR", "true, REQUEST_TIMED_OUT, NOT_COORDINATOR", "true, NOT_LEADER_OR_FOLLOWER, NOT_COORDINATOR", "true, KAFKA_STORAGE_ERROR, NOT_COORDINATOR"})
    public void testFetchOffsetsWithWrappedError(boolean fetchAllOffsets, Errors error, Errors expectedError) throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        OffsetFetchRequestData.OffsetFetchRequestGroup request = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group");
        if (!fetchAllOffsets) {
            request.setTopics(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setPartitionIndexes(Collections.singletonList(0))));
        }
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)(fetchAllOffsets ? "fetch-all-offsets" : "fetch-offsets")), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new CompletionException((Throwable)error.exception())));
        TriFunction<RequestContext, OffsetFetchRequestData.OffsetFetchRequestGroup, Boolean, CompletableFuture> fetchOffsets = fetchAllOffsets ? (arg_0, arg_1, arg_2) -> ((GroupCoordinatorService)service).fetchAllOffsets(arg_0, arg_1, arg_2) : (arg_0, arg_1, arg_2) -> ((GroupCoordinatorService)service).fetchOffsets(arg_0, arg_1, arg_2);
        CompletableFuture future = fetchOffsets.apply(TestUtil.requestContext((ApiKeys)ApiKeys.OFFSET_FETCH), request, true);
        Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group").setErrorCode(expectedError.code()), future.get());
    }

    @Test
    public void testLeaveGroup() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        LeaveGroupRequestData request = new LeaveGroupRequestData().setGroupId("foo");
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"classic-group-leave"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(new LeaveGroupResponseData()));
        CompletableFuture future = service.leaveGroup(TestUtil.requestContext((ApiKeys)ApiKeys.LEAVE_GROUP), request);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new LeaveGroupResponseData(), future.get());
    }

    @Test
    public void testLeaveGroupThrowsUnknownMemberIdException() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        LeaveGroupRequestData request = new LeaveGroupRequestData().setGroupId("foo").setMembers(Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setMemberId("member-1").setGroupInstanceId("instance-1"), new LeaveGroupRequestData.MemberIdentity().setMemberId("member-2").setGroupInstanceId("instance-2")));
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"classic-group-leave"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new UnknownMemberIdException()));
        CompletableFuture future = service.leaveGroup(TestUtil.requestContext((ApiKeys)ApiKeys.LEAVE_GROUP), request);
        Assertions.assertTrue((boolean)future.isDone());
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(new LeaveGroupResponseData.MemberResponse().setMemberId("member-1").setGroupInstanceId("instance-1").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), new LeaveGroupResponseData.MemberResponse().setMemberId("member-2").setGroupInstanceId("instance-2").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code())));
        Assertions.assertEquals((Object)expectedResponse, future.get());
    }

    @Test
    public void testLeaveGroupWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        LeaveGroupRequestData request = new LeaveGroupRequestData().setGroupId("foo");
        CompletableFuture future = service.leaveGroup(TestUtil.requestContext((ApiKeys)ApiKeys.LEAVE_GROUP), request);
        Assertions.assertEquals((Object)new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()), future.get());
    }

    @Test
    public void testConsumerGroupDescribe() throws InterruptedException, ExecutionException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        int partitionCount = 2;
        service.startup(() -> partitionCount);
        ArgumentCaptor readOperationCaptor = ArgumentCaptor.forClass(CoordinatorRuntime.CoordinatorReadOperation.class);
        ConsumerGroupDescribeResponseData.DescribedGroup describedGroup1 = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id-1");
        ConsumerGroupDescribeResponseData.DescribedGroup describedGroup2 = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id-2");
        List<ConsumerGroupDescribeResponseData.DescribedGroup> expectedDescribedGroups = Arrays.asList(describedGroup1, describedGroup2);
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"consumer-group-describe"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)readOperationCaptor.capture())).thenReturn(CompletableFuture.completedFuture(Collections.singletonList(describedGroup1)));
        CompletableFuture<List<ConsumerGroupDescribeResponseData.DescribedGroup>> describedGroupFuture = new CompletableFuture<List<ConsumerGroupDescribeResponseData.DescribedGroup>>();
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"consumer-group-describe"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 1)), (CoordinatorRuntime.CoordinatorReadOperation)readOperationCaptor.capture())).thenReturn(describedGroupFuture);
        CompletableFuture future = service.consumerGroupDescribe(TestUtil.requestContext((ApiKeys)ApiKeys.CONSUMER_GROUP_DESCRIBE), Arrays.asList("group-id-1", "group-id-2"));
        Assertions.assertFalse((boolean)future.isDone());
        describedGroupFuture.complete(Collections.singletonList(describedGroup2));
        Assertions.assertEquals(expectedDescribedGroups, future.get());
        GroupCoordinatorShard shard = (GroupCoordinatorShard)Mockito.mock(GroupCoordinatorShard.class);
        readOperationCaptor.getAllValues().forEach(x -> x.generateResponse((Object)shard, 100L));
        ((GroupCoordinatorShard)Mockito.verify((Object)shard)).consumerGroupDescribe(List.of("group-id-2"), 100L);
        ((GroupCoordinatorShard)Mockito.verify((Object)shard)).consumerGroupDescribe(List.of("group-id-1"), 100L);
    }

    @Test
    public void testConsumerGroupDescribeInvalidGroupId() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        int partitionCount = 1;
        service.startup(() -> partitionCount);
        ConsumerGroupDescribeResponseData.DescribedGroup describedGroup = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("").setErrorCode(Errors.INVALID_GROUP_ID.code());
        List<ConsumerGroupDescribeResponseData.DescribedGroup> expectedDescribedGroups = Arrays.asList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("").setErrorCode(Errors.INVALID_GROUP_ID.code()), describedGroup);
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"consumer-group-describe"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Collections.singletonList(describedGroup)));
        CompletableFuture future = service.consumerGroupDescribe(TestUtil.requestContext((ApiKeys)ApiKeys.CONSUMER_GROUP_DESCRIBE), Arrays.asList("", null));
        Assertions.assertEquals(expectedDescribedGroups, future.get());
    }

    @Test
    public void testConsumerGroupDescribeCoordinatorLoadInProgress() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        int partitionCount = 1;
        service.startup(() -> partitionCount);
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"consumer-group-describe"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new CoordinatorLoadInProgressException(null)));
        CompletableFuture future = service.consumerGroupDescribe(TestUtil.requestContext((ApiKeys)ApiKeys.CONSUMER_GROUP_DESCRIBE), Collections.singletonList("group-id"));
        Assertions.assertEquals(Collections.singletonList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())), future.get());
    }

    @Test
    public void testConsumerGroupDescribeCoordinatorNotActive() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"consumer-group-describe"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)Errors.COORDINATOR_NOT_AVAILABLE.exception()));
        CompletableFuture future = service.consumerGroupDescribe(TestUtil.requestContext((ApiKeys)ApiKeys.CONSUMER_GROUP_DESCRIBE), Collections.singletonList("group-id"));
        Assertions.assertEquals(Collections.singletonList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code())), future.get());
    }

    @Test
    public void testDeleteOffsets() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, (GroupCoordinatorMetrics)Mockito.mock(GroupCoordinatorMetrics.class), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection requestTopicCollection = new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(Collections.singletonList(new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("topic").setPartitions(Collections.singletonList(new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0)))).iterator());
        OffsetDeleteRequestData request = new OffsetDeleteRequestData().setGroupId("group").setTopics(requestTopicCollection);
        OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection responsePartitionCollection = new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0)).iterator());
        OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection responseTopicCollection = new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setPartitions(responsePartitionCollection)).iterator());
        OffsetDeleteResponseData response = new OffsetDeleteResponseData().setTopics(responseTopicCollection);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"delete-offsets"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(response));
        CompletableFuture future = service.deleteOffsets(TestUtil.requestContext((ApiKeys)ApiKeys.OFFSET_DELETE), request, BufferSupplier.NO_CACHING);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)response, future.get());
    }

    @Test
    public void testDeleteOffsetsInvalidGroupId() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, (GroupCoordinatorMetrics)Mockito.mock(GroupCoordinatorMetrics.class), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection requestTopicCollection = new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(Collections.singletonList(new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("topic").setPartitions(Collections.singletonList(new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0)))).iterator());
        OffsetDeleteRequestData request = new OffsetDeleteRequestData().setGroupId("").setTopics(requestTopicCollection);
        OffsetDeleteResponseData response = new OffsetDeleteResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code());
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"delete-offsets"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(response));
        CompletableFuture future = service.deleteOffsets(TestUtil.requestContext((ApiKeys)ApiKeys.OFFSET_DELETE), request, BufferSupplier.NO_CACHING);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)response, future.get());
    }

    @ParameterizedTest
    @MethodSource(value={"testGroupHeartbeatWithExceptionSource"})
    public void testDeleteOffsetsWithException(Throwable exception, short expectedErrorCode) throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, (GroupCoordinatorMetrics)Mockito.mock(GroupCoordinatorMetrics.class), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection requestTopicCollection = new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(Collections.singletonList(new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("topic").setPartitions(Collections.singletonList(new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0)))).iterator());
        OffsetDeleteRequestData request = new OffsetDeleteRequestData().setGroupId("group").setTopics(requestTopicCollection);
        OffsetDeleteResponseData response = new OffsetDeleteResponseData().setErrorCode(expectedErrorCode);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"delete-offsets"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)exception));
        CompletableFuture future = service.deleteOffsets(TestUtil.requestContext((ApiKeys)ApiKeys.OFFSET_DELETE), request, BufferSupplier.NO_CACHING);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)response, future.get());
    }

    @Test
    public void testDeleteOffsetsWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        OffsetDeleteRequestData request = new OffsetDeleteRequestData().setGroupId("foo");
        CompletableFuture future = service.deleteOffsets(TestUtil.requestContext((ApiKeys)ApiKeys.OFFSET_DELETE), request, BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)new OffsetDeleteResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()), future.get());
    }

    @Test
    public void testDeleteGroups() throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, (GroupCoordinatorMetrics)Mockito.mock(GroupCoordinatorMetrics.class), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 3);
        DeleteGroupsResponseData.DeletableGroupResultCollection resultCollection1 = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        DeleteGroupsResponseData.DeletableGroupResult result1 = new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-id-1");
        resultCollection1.add((ImplicitLinkedHashCollection.Element)result1);
        DeleteGroupsResponseData.DeletableGroupResultCollection resultCollection2 = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        DeleteGroupsResponseData.DeletableGroupResult result2 = new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-id-2");
        resultCollection2.add((ImplicitLinkedHashCollection.Element)result2);
        DeleteGroupsResponseData.DeletableGroupResult result3 = new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-id-3").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        DeleteGroupsResponseData.DeletableGroupResultCollection expectedResultCollection = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        expectedResultCollection.addAll(Arrays.asList(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(null).setErrorCode(Errors.INVALID_GROUP_ID.code()), result2.duplicate(), result3.duplicate(), result1.duplicate()));
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"delete-groups"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 2)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(resultCollection1));
        CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection> resultCollectionFuture = new CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection>();
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"delete-groups"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(resultCollectionFuture);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"delete-groups"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 1)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception()));
        List<String> groupIds = Arrays.asList("group-id-1", "group-id-2", "group-id-3", null);
        CompletableFuture future = service.deleteGroups(TestUtil.requestContext((ApiKeys)ApiKeys.DELETE_GROUPS), groupIds, BufferSupplier.NO_CACHING);
        Assertions.assertFalse((boolean)future.isDone());
        resultCollectionFuture.complete(resultCollection2);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedResultCollection, future.get());
    }

    @ParameterizedTest
    @MethodSource(value={"testGroupHeartbeatWithExceptionSource"})
    public void testDeleteGroupsWithException(Throwable exception, short expectedErrorCode) throws Exception {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, (GroupCoordinatorMetrics)Mockito.mock(GroupCoordinatorMetrics.class), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"delete-groups"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)exception));
        CompletableFuture future = service.deleteGroups(TestUtil.requestContext((ApiKeys)ApiKeys.DELETE_GROUPS), Collections.singletonList("group-id"), BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)new DeleteGroupsResponseData.DeletableGroupResultCollection(Collections.singletonList(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-id").setErrorCode(expectedErrorCode)).iterator()), future.get());
    }

    @Test
    public void testDeleteGroupsWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, (GroupCoordinatorMetrics)Mockito.mock(GroupCoordinatorMetrics.class), GroupConfigManagerTest.createConfigManager());
        CompletableFuture future = service.deleteGroups(TestUtil.requestContext((ApiKeys)ApiKeys.DELETE_GROUPS), Collections.singletonList("foo"), BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)new DeleteGroupsResponseData.DeletableGroupResultCollection(Collections.singletonList(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("foo").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code())).iterator()), future.get());
    }

    @Test
    public void testCommitTransactionalOffsetsWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        TxnOffsetCommitRequestData request = new TxnOffsetCommitRequestData().setGroupId("foo").setTransactionalId("transactional-id").setMemberId("member-id").setGenerationId(10).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L)))));
        CompletableFuture future = service.commitTransactionalOffsets(TestUtil.requestContext((ApiKeys)ApiKeys.TXN_OFFSET_COMMIT), request, BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)new TxnOffsetCommitResponseData().setTopics(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()))))), future.get());
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(strings={""})
    public void testCommitTransactionalOffsetsWithInvalidGroupId(String groupId) throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        TxnOffsetCommitRequestData request = new TxnOffsetCommitRequestData().setGroupId(groupId).setTransactionalId("transactional-id").setMemberId("member-id").setGenerationId(10).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L)))));
        CompletableFuture future = service.commitTransactionalOffsets(TestUtil.requestContext((ApiKeys)ApiKeys.TXN_OFFSET_COMMIT), request, BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)new TxnOffsetCommitResponseData().setTopics(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.INVALID_GROUP_ID.code()))))), future.get());
    }

    @ParameterizedTest
    @ValueSource(shorts={4, 5})
    public void testCommitTransactionalOffsets(Short txnOffsetCommitVersion) throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        TxnOffsetCommitRequestData request = new TxnOffsetCommitRequestData().setGroupId("foo").setTransactionalId("transactional-id").setProducerId(10L).setProducerEpoch((short)5).setMemberId("member-id").setGenerationId(10).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L)))));
        TxnOffsetCommitResponseData response = new TxnOffsetCommitResponseData().setTopics(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code())))));
        Mockito.when((Object)runtime.scheduleTransactionalWriteOperation((String)ArgumentMatchers.eq((Object)"txn-commit-offset"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (String)ArgumentMatchers.eq((Object)"transactional-id"), ArgumentMatchers.eq((long)10L), ArgumentMatchers.eq((short)5), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any(), (Short)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(response));
        CompletableFuture future = service.commitTransactionalOffsets(TestUtil.requestContext((ApiKeys)ApiKeys.TXN_OFFSET_COMMIT, (Short)txnOffsetCommitVersion), request, BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)response, future.get());
    }

    @ParameterizedTest
    @CsvSource(value={"NOT_ENOUGH_REPLICAS, COORDINATOR_NOT_AVAILABLE", "NETWORK_EXCEPTION, COORDINATOR_LOAD_IN_PROGRESS"})
    public void testCommitTransactionalOffsetsWithWrappedError(Errors error, Errors expectedError) throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        TxnOffsetCommitRequestData request = new TxnOffsetCommitRequestData().setGroupId("foo").setTransactionalId("transactional-id").setProducerId(10L).setProducerEpoch((short)5).setMemberId("member-id").setGenerationId(10).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L)))));
        TxnOffsetCommitResponseData response = new TxnOffsetCommitResponseData().setTopics(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(expectedError.code())))));
        Mockito.when((Object)runtime.scheduleTransactionalWriteOperation((String)ArgumentMatchers.eq((Object)"txn-commit-offset"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (String)ArgumentMatchers.eq((Object)"transactional-id"), ArgumentMatchers.eq((long)10L), ArgumentMatchers.eq((short)5), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any(), (Short)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new CompletionException((Throwable)error.exception())));
        CompletableFuture future = service.commitTransactionalOffsets(TestUtil.requestContext((ApiKeys)ApiKeys.TXN_OFFSET_COMMIT), request, BufferSupplier.NO_CACHING);
        Assertions.assertEquals((Object)response, future.get());
    }

    @Test
    public void testCompleteTransaction() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleTransactionCompletion((String)ArgumentMatchers.eq((Object)"write-txn-marker"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), ArgumentMatchers.eq((long)100L), ArgumentMatchers.eq((short)5), ArgumentMatchers.eq((int)10), (TransactionResult)ArgumentMatchers.eq((Object)TransactionResult.COMMIT), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(100L)))).thenReturn(CompletableFuture.completedFuture(null));
        CompletableFuture future = service.completeTransaction(new TopicPartition("__consumer_offsets", 0), 100L, (short)5, 10, TransactionResult.COMMIT, Duration.ofMillis(100L));
        Assertions.assertNull(future.get());
    }

    @Test
    public void testCompleteTransactionWhenNotCoordinatorServiceStarted() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        CompletableFuture future = service.completeTransaction(new TopicPartition("foo", 0), 100L, (short)5, 10, TransactionResult.COMMIT, Duration.ofMillis(100L));
        TestUtils.assertFutureThrows((Future)future, CoordinatorNotAvailableException.class);
    }

    @Test
    public void testCompleteTransactionWithUnexpectedPartition() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 1);
        CompletableFuture future = service.completeTransaction(new TopicPartition("foo", 0), 100L, (short)5, 10, TransactionResult.COMMIT, Duration.ofMillis(100L));
        TestUtils.assertFutureThrows((Future)future, IllegalStateException.class);
    }

    @Test
    public void testOnPartitionsDeleted() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        service.startup(() -> 3);
        Mockito.when((Object)runtime.scheduleWriteAllOperation((String)ArgumentMatchers.eq((Object)"on-partition-deleted"), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(Arrays.asList(CompletableFuture.completedFuture(null), CompletableFuture.completedFuture(null), FutureUtils.failedFuture((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception())));
        Assertions.assertDoesNotThrow(() -> service.onPartitionsDeleted(Collections.singletonList(new TopicPartition("foo", 0)), BufferSupplier.NO_CACHING));
    }

    @Test
    public void testOnPartitionsDeletedWhenServiceIsNotStarted() {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        Assertions.assertThrows(CoordinatorNotAvailableException.class, () -> service.onPartitionsDeleted(Collections.singletonList(new TopicPartition("foo", 0)), BufferSupplier.NO_CACHING));
    }

    @Test
    public void testShareGroupHeartbeatWhenNotStarted() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        ShareGroupHeartbeatRequestData request = new ShareGroupHeartbeatRequestData().setGroupId("foo");
        CompletableFuture future = service.shareGroupHeartbeat(TestUtil.requestContext((ApiKeys)ApiKeys.SHARE_GROUP_HEARTBEAT), request);
        Assertions.assertEquals((Object)new ShareGroupHeartbeatResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()), future.get());
    }

    @Test
    public void testShareGroupHeartbeat() throws ExecutionException, InterruptedException, TimeoutException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        ShareGroupHeartbeatRequestData request = new ShareGroupHeartbeatRequestData().setGroupId("foo");
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"share-group-heartbeat"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(new ShareGroupHeartbeatResponseData()));
        CompletableFuture future = service.shareGroupHeartbeat(TestUtil.requestContext((ApiKeys)ApiKeys.SHARE_GROUP_HEARTBEAT), request);
        Assertions.assertEquals((Object)new ShareGroupHeartbeatResponseData(), future.get(5L, TimeUnit.SECONDS));
    }

    @ParameterizedTest
    @MethodSource(value={"testGroupHeartbeatWithExceptionSource"})
    public void testShareGroupHeartbeatWithException(Throwable exception, short expectedErrorCode, String expectedErrorMessage) throws ExecutionException, InterruptedException, TimeoutException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        ShareGroupHeartbeatRequestData request = new ShareGroupHeartbeatRequestData().setGroupId("foo");
        service.startup(() -> 1);
        Mockito.when((Object)runtime.scheduleWriteOperation((String)ArgumentMatchers.eq((Object)"share-group-heartbeat"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(5000L)), (CoordinatorRuntime.CoordinatorWriteOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)exception));
        CompletableFuture future = service.shareGroupHeartbeat(TestUtil.requestContext((ApiKeys)ApiKeys.SHARE_GROUP_HEARTBEAT), request);
        Assertions.assertEquals((Object)new ShareGroupHeartbeatResponseData().setErrorCode(expectedErrorCode).setErrorMessage(expectedErrorMessage), future.get(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testShareGroupDescribe() throws InterruptedException, ExecutionException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        int partitionCount = 2;
        service.startup(() -> partitionCount);
        ArgumentCaptor readOperationCaptor = ArgumentCaptor.forClass(CoordinatorRuntime.CoordinatorReadOperation.class);
        ShareGroupDescribeResponseData.DescribedGroup describedGroup1 = new ShareGroupDescribeResponseData.DescribedGroup().setGroupId("share-group-id-1");
        ShareGroupDescribeResponseData.DescribedGroup describedGroup2 = new ShareGroupDescribeResponseData.DescribedGroup().setGroupId("share-group-id-2");
        List<ShareGroupDescribeResponseData.DescribedGroup> expectedDescribedGroups = Arrays.asList(describedGroup1, describedGroup2);
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"share-group-describe"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)readOperationCaptor.capture())).thenReturn(CompletableFuture.completedFuture(Collections.singletonList(describedGroup1)));
        CompletableFuture<List<ShareGroupDescribeResponseData.DescribedGroup>> describedGroupFuture = new CompletableFuture<List<ShareGroupDescribeResponseData.DescribedGroup>>();
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"share-group-describe"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 1)), (CoordinatorRuntime.CoordinatorReadOperation)readOperationCaptor.capture())).thenReturn(describedGroupFuture);
        CompletableFuture future = service.shareGroupDescribe(TestUtil.requestContext((ApiKeys)ApiKeys.SHARE_GROUP_DESCRIBE), Arrays.asList("share-group-id-1", "share-group-id-2"));
        Assertions.assertFalse((boolean)future.isDone());
        describedGroupFuture.complete(Collections.singletonList(describedGroup2));
        Assertions.assertEquals(expectedDescribedGroups, future.get());
        GroupCoordinatorShard shard = (GroupCoordinatorShard)Mockito.mock(GroupCoordinatorShard.class);
        readOperationCaptor.getAllValues().forEach(x -> x.generateResponse((Object)shard, 100L));
        ((GroupCoordinatorShard)Mockito.verify((Object)shard)).shareGroupDescribe(List.of("share-group-id-2"), 100L);
        ((GroupCoordinatorShard)Mockito.verify((Object)shard)).shareGroupDescribe(List.of("share-group-id-1"), 100L);
    }

    @Test
    public void testShareGroupDescribeInvalidGroupId() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        int partitionCount = 1;
        service.startup(() -> partitionCount);
        ShareGroupDescribeResponseData.DescribedGroup describedGroup = new ShareGroupDescribeResponseData.DescribedGroup().setGroupId("").setErrorCode(Errors.INVALID_GROUP_ID.code());
        List<ShareGroupDescribeResponseData.DescribedGroup> expectedDescribedGroups = Arrays.asList(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId("").setErrorCode(Errors.INVALID_GROUP_ID.code()), describedGroup);
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"share-group-describe"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Collections.singletonList(describedGroup)));
        CompletableFuture future = service.shareGroupDescribe(TestUtil.requestContext((ApiKeys)ApiKeys.SHARE_GROUP_DESCRIBE), Arrays.asList("", null));
        Assertions.assertEquals(expectedDescribedGroups, future.get());
    }

    @Test
    public void testShareGroupDescribeCoordinatorLoadInProgress() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        int partitionCount = 1;
        service.startup(() -> partitionCount);
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"share-group-describe"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new CoordinatorLoadInProgressException(null)));
        CompletableFuture future = service.shareGroupDescribe(TestUtil.requestContext((ApiKeys)ApiKeys.SHARE_GROUP_DESCRIBE), Collections.singletonList("share-group-id"));
        Assertions.assertEquals(Collections.singletonList(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId("share-group-id").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())), future.get());
    }

    @Test
    public void testShareGroupDescribeCoordinatorNotActive() throws ExecutionException, InterruptedException {
        CoordinatorRuntime<GroupCoordinatorShard, CoordinatorRecord> runtime = this.mockRuntime();
        GroupCoordinatorService service = new GroupCoordinatorService(new LogContext(), this.createConfig(), runtime, new GroupCoordinatorMetrics(), GroupConfigManagerTest.createConfigManager());
        Mockito.when((Object)runtime.scheduleReadOperation((String)ArgumentMatchers.eq((Object)"share-group-describe"), (TopicPartition)ArgumentMatchers.eq((Object)new TopicPartition("__consumer_offsets", 0)), (CoordinatorRuntime.CoordinatorReadOperation)ArgumentMatchers.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)Errors.COORDINATOR_NOT_AVAILABLE.exception()));
        CompletableFuture future = service.shareGroupDescribe(TestUtil.requestContext((ApiKeys)ApiKeys.SHARE_GROUP_DESCRIBE), Collections.singletonList("share-group-id"));
        Assertions.assertEquals(Collections.singletonList(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId("share-group-id").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code())), future.get());
    }

    @FunctionalInterface
    static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

