/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.ConsumerGroupMigrationPolicy;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.assignor.RangeAssignor;
import org.apache.kafka.coordinator.group.assignor.UniformAssignor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorConfigTest {
    private static final List<ConfigDef> GROUP_COORDINATOR_CONFIG_DEFS = List.of(GroupCoordinatorConfig.CLASSIC_GROUP_CONFIG_DEF, GroupCoordinatorConfig.GROUP_COORDINATOR_CONFIG_DEF, GroupCoordinatorConfig.OFFSET_MANAGEMENT_CONFIG_DEF, GroupCoordinatorConfig.CONSUMER_GROUP_CONFIG_DEF, GroupCoordinatorConfig.SHARE_GROUP_CONFIG_DEF);

    @Test
    public void testConsumerGroupAssignorFullClassNames() {
        Assertions.assertEquals((Object)"org.apache.kafka.coordinator.group.assignor.UniformAssignor", (Object)UniformAssignor.class.getName());
        Assertions.assertEquals((Object)"org.apache.kafka.coordinator.group.assignor.RangeAssignor", (Object)RangeAssignor.class.getName());
    }

    @Test
    public void testConsumerGroupAssignors() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("group.consumer.assignors", "range, uniform");
        GroupCoordinatorConfig config = GroupCoordinatorConfigTest.createConfig(configs);
        List assignors = config.consumerGroupAssignors();
        Assertions.assertEquals((int)2, (int)assignors.size());
        Assertions.assertTrue((boolean)(assignors.get(0) instanceof RangeAssignor));
        Assertions.assertTrue((boolean)(assignors.get(1) instanceof UniformAssignor));
        configs.put("group.consumer.assignors", CustomAssignor.class.getName());
        config = GroupCoordinatorConfigTest.createConfig(configs);
        assignors = config.consumerGroupAssignors();
        Assertions.assertEquals((int)1, (int)assignors.size());
        Assertions.assertTrue((boolean)(assignors.get(0) instanceof CustomAssignor));
        Assertions.assertNotNull(((CustomAssignor)assignors.get((int)0)).configs);
        configs.put("group.consumer.assignors", List.of(RangeAssignor.class, CustomAssignor.class));
        config = GroupCoordinatorConfigTest.createConfig(configs);
        assignors = config.consumerGroupAssignors();
        Assertions.assertEquals((int)2, (int)assignors.size());
        Assertions.assertTrue((boolean)(assignors.get(0) instanceof RangeAssignor));
        Assertions.assertTrue((boolean)(assignors.get(1) instanceof CustomAssignor));
        configs.put("group.consumer.assignors", "uniform, " + CustomAssignor.class.getName());
        config = GroupCoordinatorConfigTest.createConfig(configs);
        assignors = config.consumerGroupAssignors();
        Assertions.assertEquals((int)2, (int)assignors.size());
        Assertions.assertTrue((boolean)(assignors.get(0) instanceof UniformAssignor));
        Assertions.assertTrue((boolean)(assignors.get(1) instanceof CustomAssignor));
        configs.put("group.consumer.assignors", List.of("uniform", CustomAssignor.class.getName()));
        config = GroupCoordinatorConfigTest.createConfig(configs);
        assignors = config.consumerGroupAssignors();
        Assertions.assertEquals((int)2, (int)assignors.size());
        Assertions.assertTrue((boolean)(assignors.get(0) instanceof UniformAssignor));
        Assertions.assertTrue((boolean)(assignors.get(1) instanceof CustomAssignor));
    }

    @Test
    public void testConfigs() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("group.coordinator.threads", 10);
        configs.put("group.coordinator.append.linger.ms", 10);
        configs.put("group.consumer.session.timeout.ms", 555);
        configs.put("group.consumer.heartbeat.interval.ms", 200);
        configs.put("group.consumer.max.size", 55);
        configs.put("group.consumer.assignors", Collections.singletonList(RangeAssignor.class));
        configs.put("offsets.topic.segment.bytes", 2222);
        configs.put("offset.metadata.max.bytes", 3333);
        configs.put("group.max.size", 60);
        configs.put("group.initial.rebalance.delay.ms", 3000);
        configs.put("group.min.session.timeout.ms", 120);
        configs.put("group.max.session.timeout.ms", 600000);
        configs.put("offsets.retention.check.interval.ms", 600000);
        configs.put("offsets.retention.minutes", 1440);
        configs.put("offsets.commit.timeout.ms", 5000);
        configs.put("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DISABLED.name());
        configs.put("offsets.topic.compression.codec", Integer.valueOf(CompressionType.GZIP.id));
        configs.put("offsets.load.buffer.size", 555);
        configs.put("offsets.topic.num.partitions", 111);
        configs.put("offsets.topic.replication.factor", (short)11);
        configs.put("group.consumer.min.session.timeout.ms", 333);
        configs.put("group.consumer.max.session.timeout.ms", 666);
        configs.put("group.consumer.min.heartbeat.interval.ms", 111);
        configs.put("group.consumer.max.heartbeat.interval.ms", 222);
        configs.put("confluent.group.subscription.pattern.log.interval.ms", 60000);
        configs.put("confluent.group.highest.offset.commit.rates.log.enable", true);
        configs.put("confluent.group.highest.offset.commit.rates.log.interval.ms", 600000);
        configs.put("confluent.group.highest.offset.commit.rates.log.count", 5);
        configs.put("confluent.group.coordinator.dynamic.append.linger.enable", true);
        GroupCoordinatorConfig config = GroupCoordinatorConfigTest.createConfig(configs);
        Assertions.assertEquals((int)10, (int)config.numThreads());
        Assertions.assertEquals((int)555, (int)config.consumerGroupSessionTimeoutMs());
        Assertions.assertEquals((int)200, (int)config.consumerGroupHeartbeatIntervalMs());
        Assertions.assertEquals((int)55, (int)config.consumerGroupMaxSize());
        Assertions.assertEquals((int)1, (int)config.consumerGroupAssignors().size());
        Assertions.assertEquals((Object)"range", (Object)((ConsumerGroupPartitionAssignor)config.consumerGroupAssignors().get(0)).name());
        Assertions.assertEquals((int)2222, (int)config.offsetsTopicSegmentBytes());
        Assertions.assertEquals((int)3333, (int)config.offsetMetadataMaxSize());
        Assertions.assertEquals((int)60, (int)config.classicGroupMaxSize());
        Assertions.assertEquals((int)3000, (int)config.classicGroupInitialRebalanceDelayMs());
        Assertions.assertEquals((int)300000, (int)config.classicGroupNewMemberJoinTimeoutMs());
        Assertions.assertEquals((int)120, (int)config.classicGroupMinSessionTimeoutMs());
        Assertions.assertEquals((int)600000, (int)config.classicGroupMaxSessionTimeoutMs());
        Assertions.assertEquals((long)600000L, (long)config.offsetsRetentionCheckIntervalMs());
        Assertions.assertEquals((long)Duration.ofMinutes(1440L).toMillis(), (long)config.offsetsRetentionMs());
        Assertions.assertEquals((int)5000, (int)config.offsetCommitTimeoutMs());
        Assertions.assertEquals((Object)CompressionType.GZIP, (Object)config.offsetsTopicCompressionType());
        Assertions.assertEquals((int)10, (int)config.appendLingerMs());
        Assertions.assertEquals((int)555, (int)config.offsetsLoadBufferSize());
        Assertions.assertEquals((int)111, (int)config.offsetsTopicPartitions());
        Assertions.assertEquals((int)11, (int)config.offsetsTopicReplicationFactor());
        Assertions.assertEquals((int)333, (int)config.consumerGroupMinSessionTimeoutMs());
        Assertions.assertEquals((int)666, (int)config.consumerGroupMaxSessionTimeoutMs());
        Assertions.assertEquals((int)111, (int)config.consumerGroupMinHeartbeatIntervalMs());
        Assertions.assertEquals((int)222, (int)config.consumerGroupMaxHeartbeatIntervalMs());
        Assertions.assertEquals((int)60000, (int)config.classicGroupSubscriptionPatternLogIntervalMs());
        Assertions.assertEquals((Object)true, (Object)config.groupHighestOffsetCommitRatesLogEnable());
        Assertions.assertEquals((int)600000, (int)config.groupHighestOffsetCommitRatesLogIntervalMs());
        Assertions.assertEquals((int)5, (int)config.groupHighestOffsetCommitRatesLogCount());
        Assertions.assertEquals((Object)true, (Object)config.dynamicAppendLingerEnable());
    }

    @Test
    public void testInvalidConfigs() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("group.consumer.max.heartbeat.interval.ms", 10);
        configs.put("group.consumer.min.heartbeat.interval.ms", 20);
        configs.put("group.consumer.heartbeat.interval.ms", 20);
        Assertions.assertEquals((Object)"group.consumer.max.heartbeat.interval.ms must be greater than or equal to group.consumer.min.heartbeat.interval.ms", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.max.heartbeat.interval.ms", 30);
        configs.put("group.consumer.min.heartbeat.interval.ms", 20);
        configs.put("group.consumer.heartbeat.interval.ms", 10);
        Assertions.assertEquals((Object)"group.consumer.heartbeat.interval.ms must be greater than or equal to group.consumer.min.heartbeat.interval.ms", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.max.heartbeat.interval.ms", 30);
        configs.put("group.consumer.min.heartbeat.interval.ms", 20);
        configs.put("group.consumer.heartbeat.interval.ms", 40);
        Assertions.assertEquals((Object)"group.consumer.heartbeat.interval.ms must be less than or equal to group.consumer.max.heartbeat.interval.ms", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.max.session.timeout.ms", 10);
        configs.put("group.consumer.min.session.timeout.ms", 20);
        configs.put("group.consumer.session.timeout.ms", 20);
        Assertions.assertEquals((Object)"group.consumer.max.session.timeout.ms must be greater than or equal to group.consumer.min.session.timeout.ms", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.max.session.timeout.ms", 30);
        configs.put("group.consumer.min.session.timeout.ms", 20);
        configs.put("group.consumer.session.timeout.ms", 10);
        Assertions.assertEquals((Object)"group.consumer.session.timeout.ms must be greater than or equal to group.consumer.min.session.timeout.ms", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.max.session.timeout.ms", 30);
        configs.put("group.consumer.min.session.timeout.ms", 20);
        configs.put("group.consumer.session.timeout.ms", 40);
        Assertions.assertEquals((Object)"group.consumer.session.timeout.ms must be less than or equal to group.consumer.max.session.timeout.ms", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.assignors", Object.class);
        Assertions.assertEquals((Object)"Invalid value class java.lang.Object for configuration group.consumer.assignors: Expected a comma separated list.", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.assignors", Collections.singletonList(Object.class));
        Assertions.assertEquals((Object)"class java.lang.Object is not an instance of org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor", (Object)((KafkaException)Assertions.assertThrows(KafkaException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.assignors", Object.class.getName());
        Assertions.assertEquals((Object)"java.lang.Object is not an instance of org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor", (Object)((KafkaException)Assertions.assertThrows(KafkaException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.assignors", "foo");
        Assertions.assertEquals((Object)"Class foo cannot be found", (Object)((KafkaException)Assertions.assertThrows(KafkaException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.migration.policy", "foobar");
        Assertions.assertEquals((Object)"Invalid value foobar for configuration group.consumer.migration.policy: String must be one of (case insensitive): DISABLED, DOWNGRADE, UPGRADE, BIDIRECTIONAL", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("offsets.topic.compression.codec", -100);
        Assertions.assertEquals((Object)"Unknown compression type id: -100", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.consumer.min.heartbeat.interval.ms", 45000);
        configs.put("group.consumer.max.heartbeat.interval.ms", 60000);
        configs.put("group.consumer.heartbeat.interval.ms", 50000);
        configs.put("group.consumer.session.timeout.ms", 50000);
        Assertions.assertEquals((Object)"group.consumer.heartbeat.interval.ms must be less than group.consumer.session.timeout.ms", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
        configs.clear();
        configs.put("group.share.min.heartbeat.interval.ms", 45000);
        configs.put("group.share.max.heartbeat.interval.ms", 60000);
        configs.put("group.share.heartbeat.interval.ms", 50000);
        configs.put("group.share.session.timeout.ms", 50000);
        Assertions.assertEquals((Object)"group.share.heartbeat.interval.ms must be less than group.share.session.timeout.ms", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GroupCoordinatorConfigTest.createConfig(configs))).getMessage());
    }

    public static GroupCoordinatorConfig createGroupCoordinatorConfig(int offsetMetadataMaxSize, long offsetsRetentionCheckIntervalMs, int offsetsRetentionMinutes) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("group.coordinator.threads", 1);
        configs.put("group.coordinator.append.linger.ms", 10);
        configs.put("group.consumer.session.timeout.ms", 45);
        configs.put("group.consumer.min.session.timeout.ms", 45);
        configs.put("group.consumer.heartbeat.interval.ms", 5);
        configs.put("group.consumer.min.heartbeat.interval.ms", 5);
        configs.put("group.consumer.max.size", Integer.MAX_VALUE);
        configs.put("group.consumer.assignors", Collections.singletonList(RangeAssignor.class));
        configs.put("offsets.topic.segment.bytes", 1000);
        configs.put("offset.metadata.max.bytes", offsetMetadataMaxSize);
        configs.put("group.max.size", Integer.MAX_VALUE);
        configs.put("group.initial.rebalance.delay.ms", 3000);
        configs.put("group.min.session.timeout.ms", 120);
        configs.put("group.max.session.timeout.ms", 50000);
        configs.put("offsets.retention.check.interval.ms", offsetsRetentionCheckIntervalMs);
        configs.put("offsets.retention.minutes", offsetsRetentionMinutes);
        configs.put("offsets.commit.timeout.ms", 5000);
        configs.put("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DISABLED.name());
        configs.put("offsets.topic.compression.codec", Integer.valueOf(CompressionType.NONE.id));
        configs.put("confluent.group.subscription.pattern.log.interval.ms", 60000);
        configs.put("confluent.offsets.log.cleaner.max.compaction.lag.ms", 86400000);
        configs.put("group.share.session.timeout.ms", 45);
        configs.put("group.share.min.session.timeout.ms", 45);
        configs.put("group.share.heartbeat.interval.ms", 5);
        configs.put("group.share.min.heartbeat.interval.ms", 5);
        configs.put("group.share.max.size", 1000);
        return GroupCoordinatorConfigTest.createConfig(configs);
    }

    public static GroupCoordinatorConfig createConfig(Map<String, Object> configs) {
        return new GroupCoordinatorConfig(new AbstractConfig(Utils.mergeConfigs(GROUP_COORDINATOR_CONFIG_DEFS), configs, false));
    }

    public static class CustomAssignor
    implements ConsumerGroupPartitionAssignor,
    Configurable {
        public Map<String, ?> configs;

        public void configure(Map<String, ?> configs) {
            this.configs = configs;
        }

        public String name() {
            return "CustomAssignor";
        }

        public GroupAssignment assign(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) throws PartitionAssignorException {
            return null;
        }
    }
}

