/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfigTest;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupConfig;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupConfigTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupConfigTest {
    private static final int OFFSET_METADATA_MAX_SIZE = 4096;
    private static final long OFFSETS_RETENTION_CHECK_INTERVAL_MS = 1000L;
    private static final int OFFSETS_RETENTION_MINUTES = 1440;
    private static final boolean SHARE_GROUP_ENABLE = true;
    private static final int SHARE_GROUP_PARTITION_MAX_RECORD_LOCKS = 200;
    private static final int SHARE_GROUP_DELIVERY_COUNT_LIMIT = 5;
    private static final short SHARE_GROUP_MAX_GROUPS = 10;
    private static final int SHARE_GROUP_RECORD_LOCK_DURATION_MS = 30000;
    private static final int SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS = 15000;
    private static final int SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS = 60000;

    @Test
    public void testFromPropsInvalid() {
        GroupConfig.configNames().forEach(name -> {
            if ("consumer.session.timeout.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, "not_a_number", "-0.1", "1.2");
            } else if ("consumer.heartbeat.interval.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, "not_a_number", "-0.1", "1.2");
            } else if ("share.session.timeout.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, "not_a_number", "-0.1", "1.2");
            } else if ("share.heartbeat.interval.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, "not_a_number", "-0.1", "1.2");
            } else if ("share.record.lock.duration.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, "not_a_number", "-0.1", "1.2");
            } else if ("share.auto.offset.reset".equals(name)) {
                this.assertPropertyInvalid((String)name, "hello", "1.0");
            } else {
                this.assertPropertyInvalid((String)name, "not_a_number", "-0.1");
            }
        });
    }

    private void assertPropertyInvalid(String name, Object ... values) {
        for (Object value : values) {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            Assertions.assertThrows(Exception.class, () -> new GroupConfig((Map)props));
        }
    }

    @Test
    public void testValidShareAutoOffsetResetValues() {
        Properties props = this.createValidGroupConfig();
        props.put("share.auto.offset.reset", "latest");
        this.doTestValidProps(props);
        props = this.createValidGroupConfig();
        props.put("share.auto.offset.reset", "earliest");
        this.doTestValidProps(props);
        props.put("share.auto.offset.reset", "by_duration:PT10S");
        this.doTestValidProps(props);
    }

    @Test
    public void testInvalidProps() {
        Properties props = this.createValidGroupConfig();
        props.put("consumer.session.timeout.ms", "1");
        this.doTestInvalidProps(props, InvalidConfigurationException.class);
        props = this.createValidGroupConfig();
        props.put("consumer.session.timeout.ms", "70000");
        this.doTestInvalidProps(props, InvalidConfigurationException.class);
        props = this.createValidGroupConfig();
        props.put("consumer.heartbeat.interval.ms", "1");
        this.doTestInvalidProps(props, InvalidConfigurationException.class);
        props = this.createValidGroupConfig();
        props.put("consumer.heartbeat.interval.ms", "70000");
        this.doTestInvalidProps(props, InvalidConfigurationException.class);
        props = this.createValidGroupConfig();
        props.put("share.session.timeout.ms", "1");
        this.doTestInvalidProps(props, InvalidConfigurationException.class);
        props = this.createValidGroupConfig();
        props.put("share.session.timeout.ms", "70000");
        this.doTestInvalidProps(props, InvalidConfigurationException.class);
        props = this.createValidGroupConfig();
        props.put("share.heartbeat.interval.ms", "1");
        this.doTestInvalidProps(props, InvalidConfigurationException.class);
        props = this.createValidGroupConfig();
        props.put("share.heartbeat.interval.ms", "70000");
        this.doTestInvalidProps(props, InvalidConfigurationException.class);
        props = this.createValidGroupConfig();
        props.put("share.record.lock.duration.ms", "10000");
        this.doTestInvalidProps(props, InvalidConfigurationException.class);
        props = this.createValidGroupConfig();
        props.put("share.record.lock.duration.ms", "70000");
        this.doTestInvalidProps(props, InvalidConfigurationException.class);
        props = this.createValidGroupConfig();
        props.put("share.auto.offset.reset", "hello");
        this.doTestInvalidProps(props, ConfigException.class);
        props.put("share.auto.offset.reset", "by_duration");
        this.doTestInvalidProps(props, ConfigException.class);
        props.put("share.auto.offset.reset", "by_duration:-PT10S");
        this.doTestInvalidProps(props, ConfigException.class);
        props.put("share.auto.offset.reset", "by_duration:invalid");
        this.doTestInvalidProps(props, ConfigException.class);
    }

    private void doTestInvalidProps(Properties props, Class<? extends Exception> exceptionClassName) {
        Assertions.assertThrows(exceptionClassName, () -> GroupConfig.validate((Properties)props, (GroupCoordinatorConfig)this.createGroupCoordinatorConfig(), (ShareGroupConfig)this.createShareGroupConfig()));
    }

    private void doTestValidProps(Properties props) {
        Assertions.assertDoesNotThrow(() -> GroupConfig.validate((Properties)props, (GroupCoordinatorConfig)this.createGroupCoordinatorConfig(), (ShareGroupConfig)this.createShareGroupConfig()));
    }

    @Test
    public void testFromPropsWithDefaultValue() {
        HashMap<String, String> defaultValue = new HashMap<String, String>();
        defaultValue.put("consumer.session.timeout.ms", "10");
        defaultValue.put("consumer.heartbeat.interval.ms", "10");
        defaultValue.put("share.session.timeout.ms", "10");
        defaultValue.put("share.heartbeat.interval.ms", "10");
        defaultValue.put("share.record.lock.duration.ms", "2000");
        defaultValue.put("share.auto.offset.reset", "latest");
        Properties props = new Properties();
        props.put("consumer.session.timeout.ms", "20");
        GroupConfig config = GroupConfig.fromProps(defaultValue, (Properties)props);
        Assertions.assertEquals((int)10, (Integer)config.getInt("consumer.heartbeat.interval.ms"));
        Assertions.assertEquals((int)20, (Integer)config.getInt("consumer.session.timeout.ms"));
        Assertions.assertEquals((int)10, (Integer)config.getInt("share.heartbeat.interval.ms"));
        Assertions.assertEquals((int)10, (Integer)config.getInt("share.session.timeout.ms"));
        Assertions.assertEquals((int)2000, (Integer)config.getInt("share.record.lock.duration.ms"));
        Assertions.assertEquals((Object)"latest", (Object)config.getString("share.auto.offset.reset"));
    }

    @Test
    public void testInvalidConfigName() {
        Properties props = new Properties();
        props.put("consumer.session.timeout.ms", "10");
        props.put("invalid.config.name", "10");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> GroupConfig.validate((Properties)props, (GroupCoordinatorConfig)this.createGroupCoordinatorConfig(), (ShareGroupConfig)this.createShareGroupConfig()));
    }

    private Properties createValidGroupConfig() {
        Properties props = new Properties();
        props.put("consumer.session.timeout.ms", "45000");
        props.put("consumer.heartbeat.interval.ms", "5000");
        props.put("share.session.timeout.ms", "45000");
        props.put("share.heartbeat.interval.ms", "5000");
        props.put("share.record.lock.duration.ms", "30000");
        props.put("share.auto.offset.reset", "latest");
        return props;
    }

    private GroupCoordinatorConfig createGroupCoordinatorConfig() {
        return GroupCoordinatorConfigTest.createGroupCoordinatorConfig(4096, 1000L, 1440);
    }

    private ShareGroupConfig createShareGroupConfig() {
        return ShareGroupConfigTest.createShareGroupConfig(true, 200, 5, (short)10, 30000, 15000, 60000);
    }
}

