/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import io.confluent.kafka.multitenant.TenantUtils;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.common.runtime.MockCoordinatorExecutor;
import org.apache.kafka.coordinator.group.Assertions;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.ConsumerGroupMigrationPolicy;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.GroupMetadataManagerTestContext;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.MockPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupBuilder;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ResolvedRegularExpression;
import org.apache.kafka.image.MetadataImage;
import org.junit.jupiter.api.Test;

public class ConfluentGroupMetadataManagerTest {
    @Test
    public void testConsumerGroupRegexStartAnchor() {
        String tenantPrefix = "lkc-12345_";
        String groupId = "lkc-12345_fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "lkc-12345_foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build(12345L)).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("^foo*").setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("^foo*").setServerAssignorName("range").build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        List<MockCoordinatorExecutor.ExecutorResult<CoordinatorRecord>> tasks = context.processTasks();
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new MockCoordinatorExecutor.ExecutorResult(groupId + "-regex", new CoordinatorResult(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)groupId, (String)"^foo*", (ResolvedRegularExpression)new ResolvedRegularExpression(Set.of(fooTopicName), 12345L, context.time.milliseconds())), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11))))), tasks);
    }

    @Test
    public void testConsumerGroupRegexTenantIsolation() {
        String tenantPrefix = "lkc-12345_";
        String otherTenantPrefix = "lkc-abcde_";
        String groupId = "lkc-12345_fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "lkc-12345_foo";
        Uuid otherFooTopicId = Uuid.randomUuid();
        String otherFooTopicName = "lkc-abcde_foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(otherFooTopicId, otherFooTopicName, 6).build(12345L)).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex(".*foo*").setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex(".*foo*").setServerAssignorName("range").build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        List<MockCoordinatorExecutor.ExecutorResult<CoordinatorRecord>> tasks = context.processTasks();
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new MockCoordinatorExecutor.ExecutorResult(groupId + "-regex", new CoordinatorResult(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)groupId, (String)".*foo*", (ResolvedRegularExpression)new ResolvedRegularExpression(Set.of(fooTopicName), 12345L, context.time.milliseconds())), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11))))), tasks);
    }

    @Test
    public void testClassicGroupSyncToConsumerGroupAssignmentTenantPrefixes() throws Exception {
        String tenantPrefix = "lkc-12345_";
        String groupId = tenantPrefix + "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = tenantPrefix + "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = tenantPrefix + "bar";
        for (short version = 0; version <= 3; version = (short)(version + 1)) {
            List<TopicPartition> topicPartitions = List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1));
            List<TopicPartition> unprefixedTopicPartitions = topicPartitions.stream().map(tp -> new TopicPartition(TenantUtils.removeTenantPrefix((String)tp.topic()), tp.partition())).collect(Collectors.toList());
            List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = Collections.singletonList(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, topicPartitions), (short)version))));
            Map<Uuid, Set<Integer>> member1Assignment = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1));
            ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setSubscribedTopicNames(List.of("foo", "bar")).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setAssignedPartitions(member1Assignment).build();
            Map<Uuid, Set<Integer>> member2Assignment = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2));
            ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setSubscribedTopicNames(List.of("foo", "bar")).setAssignedPartitions(member2Assignment).build();
            GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConfig("group.consumer.assignors", List.of(new MockPartitionAssignor("range"))).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, member1Assignment).withAssignment(memberId2, member2Assignment).withAssignmentEpoch(10)).build();
            context.verifyClassicGroupSyncToConsumerGroup(groupId, memberId1, 10, "range", "consumer", unprefixedTopicPartitions, version);
        }
    }

    @Test
    public void testClassicGroupToConsumerGroupUpgradeAssignmentTenantPrefixes() {
        String tenantPrefix = "lkc-12345_";
        String groupId = tenantPrefix + "group-id";
        String memberId1 = "member-id-1";
        String memberId2 = "member-id-2";
        Uuid fooTopicId = Uuid.randomUuid();
        String unprefixedFooTopicName = "foo";
        String fooTopicName = tenantPrefix + unprefixedFooTopicName;
        Uuid barTopicId = Uuid.randomUuid();
        String unprefixedBarTopicName = "bar";
        String barTopicName = tenantPrefix + unprefixedBarTopicName;
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))))));
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 1).addTopic(barTopicId, barTopicName, 1).addRacks().build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.UPGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(metadataImage).build();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(1);
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0)))))));
        Map<String, byte[]> assignments = Collections.singletonMap(memberId1, Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(unprefixedFooTopicName, 0), new TopicPartition(unprefixedBarTopicName, 0))))));
        ClassicGroup group = context.createClassicGroup(groupId);
        group.setProtocolName(Optional.of("range"));
        group.add(new ClassicGroupMember(memberId1, Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", protocols, assignments.get(memberId1)));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        group.transitionTo(ClassicGroupState.STABLE);
        context.replay(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, assignments));
        context.commit();
        group = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setTopicPartitions(Collections.emptyList()));
        ConsumerGroupMember expectedMember1 = new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(0).setPreviousMemberEpoch(0).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(10000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols))).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).build();
        ConsumerGroupMember expectedMember2 = new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(1).setPreviousMemberEpoch(0).setState(MemberState.UNRELEASED_PARTITIONS).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setServerAssignorName("range").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(5000).setAssignedPartitions(Collections.emptyMap()).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 1), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)0), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, (Map)expectedMember1.assignedPartitions()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)0), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId2, assignor.targetPartitions(memberId2)), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, assignor.targetPartitions(memberId1)), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember2));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testConsumerGroupToClassicGroupDowngradeAssignmentTenantPrefixes() {
        String tenantPrefix = "lkc-12345_";
        String groupId = tenantPrefix + "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String unprefixedFooTopicName = "foo";
        String fooTopicName = tenantPrefix + unprefixedFooTopicName;
        Uuid barTopicId = Uuid.randomUuid();
        String unprefixedBarTopicName = "bar";
        String barTopicName = tenantPrefix + unprefixedBarTopicName;
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = Collections.singletonList(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1)))))));
        Map<Uuid, Set<Integer>> member1Assignment = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setAssignedPartitions(member1Assignment).build();
        Map<Uuid, Set<Integer>> member2Assignment = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2));
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setAssignedPartitions(member2Assignment).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, member1Assignment).withAssignment(memberId2, member2Assignment).withAssignmentEpoch(10)).build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))));
        context.commit();
        ConsumerGroup consumerGroup = context.groupMetadataManager.consumerGroup(groupId);
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(-1).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setTopicPartitions(Collections.emptyList()));
        byte[] assignment = Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(unprefixedFooTopicName, 0), new TopicPartition(unprefixedFooTopicName, 1), new TopicPartition(unprefixedFooTopicName, 2), new TopicPartition(unprefixedBarTopicName, 0), new TopicPartition(unprefixedBarTopicName, 1)))));
        Map<String, byte[]> assignments = Collections.singletonMap(memberId1, assignment);
        ClassicGroup expectedClassicGroup = new ClassicGroup(new LogContext(), groupId, ClassicGroupState.STABLE, (Time)context.time, context.metrics, 10, Optional.of("consumer"), Optional.of("range"), Optional.of(memberId1), Optional.of(context.time.milliseconds()));
        expectedClassicGroup.add(new ClassicGroupMember(memberId1, Optional.ofNullable(member1.instanceId()), member1.clientId(), member1.clientHost(), member1.rebalanceTimeoutMs(), ((Integer)member1.classicProtocolSessionTimeout().get()).intValue(), "consumer", member1.supportedJoinGroupRequestProtocols(), assignment));
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)expectedClassicGroup, assignments))), result.records());
    }
}

