/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams.assignor;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.streams.assignor.AssignmentMemberSpec;
import org.apache.kafka.coordinator.group.streams.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.streams.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.streams.assignor.GroupSpecImpl;
import org.apache.kafka.coordinator.group.streams.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.streams.assignor.MockAssignor;
import org.apache.kafka.coordinator.group.streams.assignor.TaskAssignorException;
import org.apache.kafka.coordinator.group.streams.assignor.TopologyDescriber;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MockAssignorTest {
    private final MockAssignor assignor = new MockAssignor();

    @Test
    public void testZeroMembers() {
        TaskAssignorException ex = (TaskAssignorException)Assertions.assertThrows(TaskAssignorException.class, () -> this.assignor.assign((GroupSpec)new GroupSpecImpl(Collections.emptyMap(), new HashMap()), (TopologyDescriber)new TopologyDescriberImpl(5, Collections.singletonList("test-subtopology"))));
        Assertions.assertEquals((Object)"No member available to assign task 0 of subtopology test-subtopology", (Object)ex.getMessage());
    }

    @Test
    public void testDoubleAssignment() {
        AssignmentMemberSpec memberSpec1 = new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonMap("test-subtopology", new HashSet<Integer>(List.of(Integer.valueOf(0)))), Collections.emptyMap(), Collections.emptyMap(), "test-process", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        AssignmentMemberSpec memberSpec2 = new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonMap("test-subtopology", new HashSet<Integer>(List.of(Integer.valueOf(0)))), Collections.emptyMap(), Collections.emptyMap(), "test-process", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        TaskAssignorException ex = (TaskAssignorException)Assertions.assertThrows(TaskAssignorException.class, () -> this.assignor.assign((GroupSpec)new GroupSpecImpl(Map.of("member1", memberSpec1, "member2", memberSpec2), new HashMap()), (TopologyDescriber)new TopologyDescriberImpl(5, Collections.singletonList("test-subtopology"))));
        Assertions.assertEquals((Object)"Task 0 of subtopology test-subtopology is assigned to multiple members", (Object)ex.getMessage());
    }

    @Test
    public void testBasicScenario() {
        GroupAssignment result = this.assignor.assign((GroupSpec)new GroupSpecImpl(Collections.emptyMap(), new HashMap()), (TopologyDescriber)new TopologyDescriberImpl(5, Collections.emptyList()));
        Assertions.assertEquals((int)0, (int)result.members().size());
    }

    @Test
    public void testSingleMember() {
        AssignmentMemberSpec memberSpec = new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "test-process", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        GroupAssignment result = this.assignor.assign((GroupSpec)new GroupSpecImpl(Collections.singletonMap("test_member", memberSpec), new HashMap()), (TopologyDescriber)new TopologyDescriberImpl(4, List.of("test-subtopology")));
        Assertions.assertEquals((int)1, (int)result.members().size());
        MemberAssignment testMember = (MemberAssignment)result.members().get("test_member");
        Assertions.assertNotNull((Object)testMember);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test-subtopology", Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)))}), (Object)testMember.activeTasks());
    }

    @Test
    public void testTwoMembersTwoSubtopologies() {
        AssignmentMemberSpec memberSpec1 = new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "test-process", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        AssignmentMemberSpec memberSpec2 = new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "test-process", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        GroupAssignment result = this.assignor.assign((GroupSpec)new GroupSpecImpl(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_member1", (Object)memberSpec1), Utils.mkEntry((Object)"test_member2", (Object)memberSpec2)}), new HashMap()), (TopologyDescriber)new TopologyDescriberImpl(4, List.of("test-subtopology1", "test-subtopology2")));
        Map expected1 = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test-subtopology1", Set.of(Integer.valueOf(1), Integer.valueOf(3))), Utils.mkEntry((Object)"test-subtopology2", Set.of(Integer.valueOf(1), Integer.valueOf(3)))});
        Map expected2 = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test-subtopology1", Set.of(Integer.valueOf(0), Integer.valueOf(2))), Utils.mkEntry((Object)"test-subtopology2", Set.of(Integer.valueOf(0), Integer.valueOf(2)))});
        Assertions.assertEquals((int)2, (int)result.members().size());
        MemberAssignment testMember1 = (MemberAssignment)result.members().get("test_member1");
        MemberAssignment testMember2 = (MemberAssignment)result.members().get("test_member2");
        Assertions.assertNotNull((Object)testMember1);
        Assertions.assertNotNull((Object)testMember2);
        Assertions.assertTrue((expected1.equals(testMember1.activeTasks()) || expected2.equals(testMember1.activeTasks()) ? 1 : 0) != 0);
        Assertions.assertTrue((expected1.equals(testMember2.activeTasks()) || expected2.equals(testMember2.activeTasks()) ? 1 : 0) != 0);
    }

    @Test
    public void testTwoMembersTwoSubtopologiesStickiness() {
        AssignmentMemberSpec memberSpec1 = new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test-subtopology1", new HashSet<Integer>(List.of(Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(3)))), Utils.mkEntry((Object)"test-subtopology2", new HashSet<Integer>(List.of(Integer.valueOf(0))))}), Collections.emptyMap(), Collections.emptyMap(), "test-process", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        AssignmentMemberSpec memberSpec2 = new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test-subtopology1", new HashSet<Integer>(List.of(Integer.valueOf(1)))), Utils.mkEntry((Object)"test-subtopology2", new HashSet<Integer>(List.of(Integer.valueOf(3))))}), Collections.emptyMap(), Collections.emptyMap(), "test-process", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        GroupAssignment result = this.assignor.assign((GroupSpec)new GroupSpecImpl(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_member1", (Object)memberSpec1), Utils.mkEntry((Object)"test_member2", (Object)memberSpec2)}), new HashMap()), (TopologyDescriber)new TopologyDescriberImpl(4, List.of("test-subtopology1", "test-subtopology2")));
        Assertions.assertEquals((int)2, (int)result.members().size());
        MemberAssignment testMember1 = (MemberAssignment)result.members().get("test_member1");
        MemberAssignment testMember2 = (MemberAssignment)result.members().get("test_member2");
        Assertions.assertNotNull((Object)testMember1);
        Assertions.assertNotNull((Object)testMember2);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test-subtopology1", Set.of(Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(3))), Utils.mkEntry((Object)"test-subtopology2", Set.of(Integer.valueOf(0)))}), (Object)testMember1.activeTasks());
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test-subtopology1", Set.of(Integer.valueOf(1))), Utils.mkEntry((Object)"test-subtopology2", Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)))}), (Object)testMember2.activeTasks());
    }

    private record TopologyDescriberImpl(int numPartitions, List<String> subtopologies) implements TopologyDescriber
    {
        public int numTasks(String subtopologyId) {
            return this.numPartitions;
        }

        public boolean isStateful(String subtopologyId) {
            return false;
        }
    }
}

