/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.share;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;
import org.apache.kafka.image.MetadataImage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShareGroupMemberTest {
    @Test
    public void testNewMember() {
        Uuid topicId1 = Uuid.randomUuid();
        ShareGroupMember member = new ShareGroupMember.Builder("member-id").setMemberEpoch(10).setPreviousMemberEpoch(9).setRackId("rack-id").setClientId("client-id").setClientHost("hostname").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3))).build();
        Assertions.assertEquals((Object)"member-id", (Object)member.memberId());
        Assertions.assertEquals((int)10, (int)member.memberEpoch());
        Assertions.assertEquals((int)9, (int)member.previousMemberEpoch());
        Assertions.assertNull((Object)member.instanceId());
        Assertions.assertEquals((Object)"rack-id", (Object)member.rackId());
        Assertions.assertEquals((Object)"client-id", (Object)member.clientId());
        Assertions.assertEquals((Object)"hostname", (Object)member.clientHost());
        Assertions.assertEquals(Set.of("bar", "foo"), (Object)member.subscribedTopicNames());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3)), (Object)member.assignedPartitions());
    }

    @Test
    public void testEquals() {
        Uuid topicId1 = Uuid.randomUuid();
        ShareGroupMember member1 = new ShareGroupMember.Builder("member-id").setMemberEpoch(10).setPreviousMemberEpoch(9).setRackId("rack-id").setClientId("client-id").setClientHost("hostname").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3))).build();
        ShareGroupMember member2 = new ShareGroupMember.Builder("member-id").setMemberEpoch(10).setPreviousMemberEpoch(9).setRackId("rack-id").setClientId("client-id").setClientHost("hostname").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3))).build();
        Assertions.assertEquals((Object)member1, (Object)member2);
    }

    @Test
    public void testUpdateMember() {
        Uuid topicId1 = Uuid.randomUuid();
        ShareGroupMember member = new ShareGroupMember.Builder("member-id").setMemberEpoch(10).setPreviousMemberEpoch(9).setRackId("rack-id").setClientId("client-id").setClientHost("hostname").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3))).build();
        ShareGroupMember updatedMember = new ShareGroupMember.Builder(member).maybeUpdateRackId(Optional.empty()).maybeUpdateSubscribedTopicNames(Optional.empty()).build();
        Assertions.assertEquals((Object)member, (Object)updatedMember);
        updatedMember = new ShareGroupMember.Builder(member).maybeUpdateRackId(Optional.of("new-rack-id")).maybeUpdateSubscribedTopicNames(Optional.of(Collections.singletonList("zar"))).build();
        Assertions.assertNull((Object)member.instanceId());
        Assertions.assertEquals((Object)"new-rack-id", (Object)updatedMember.rackId());
        Assertions.assertEquals(Set.of("zar"), (Object)updatedMember.subscribedTopicNames());
    }

    @Test
    public void testUpdateWithShareGroupMemberMetadataValue() {
        ShareGroupMemberMetadataValue record = new ShareGroupMemberMetadataValue().setClientId("client-id").setClientHost("host-id").setRackId("rack-id").setSubscribedTopicNames(Arrays.asList("foo", "bar"));
        ShareGroupMember member = new ShareGroupMember.Builder("member-id").updateWith(record).build();
        Assertions.assertNull((Object)member.instanceId());
        Assertions.assertEquals((Object)"rack-id", (Object)member.rackId());
        Assertions.assertEquals((Object)"client-id", (Object)member.clientId());
        Assertions.assertEquals((Object)"host-id", (Object)member.clientHost());
        Assertions.assertEquals(Set.of("bar", "foo"), (Object)member.subscribedTopicNames());
    }

    @Test
    public void testAsShareGroupDescribeMember() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(topicId1, "topic1", 3).addTopic(topicId2, "topic2", 3).build();
        List<String> subscribedTopicNames = Arrays.asList("topic1", "topic2");
        List<Integer> assignedPartitions = Arrays.asList(0, 1, 2);
        int epoch = 10;
        ShareGroupMemberMetadataValue record = new ShareGroupMemberMetadataValue().setClientId("client-id").setClientHost("host-id").setRackId("rack-id").setSubscribedTopicNames(subscribedTopicNames);
        String memberId = Uuid.randomUuid().toString();
        ShareGroupMember member = new ShareGroupMember.Builder(memberId).updateWith(record).setMemberEpoch(epoch).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 0, 1, 2))).build();
        ShareGroupDescribeResponseData.Member actual = member.asShareGroupDescribeMember(metadataImage.topics());
        ShareGroupDescribeResponseData.Member expected = new ShareGroupDescribeResponseData.Member().setMemberId(memberId).setMemberEpoch(epoch).setClientId("client-id").setRackId("rack-id").setClientHost("host-id").setSubscribedTopicNames(subscribedTopicNames).setAssignment(new ShareGroupDescribeResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ShareGroupDescribeResponseData.TopicPartitions().setTopicId(topicId1).setTopicName("topic1").setPartitions(assignedPartitions))));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

