/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.kafka.coordinator.group.modern.UnionSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnionSetTest {
    @Test
    public void testSetsCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new UnionSet(Collections.emptySet(), null));
        Assertions.assertThrows(NullPointerException.class, () -> new UnionSet(null, Collections.emptySet()));
    }

    @Test
    public void testUnion() {
        UnionSet union = new UnionSet(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), Set.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        ArrayList result = new ArrayList(union);
        result.sort(Integer::compareTo);
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)), result);
    }

    @Test
    public void testSize() {
        UnionSet union = new UnionSet(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), Set.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        Assertions.assertEquals((int)5, (int)union.size());
    }

    @Test
    public void testIsEmpty() {
        UnionSet union = new UnionSet(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), Set.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        Assertions.assertFalse((boolean)union.isEmpty());
        union = new UnionSet(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), Collections.emptySet());
        Assertions.assertFalse((boolean)union.isEmpty());
        union = new UnionSet(Collections.emptySet(), Set.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        Assertions.assertFalse((boolean)union.isEmpty());
        union = new UnionSet(Collections.emptySet(), Collections.emptySet());
        Assertions.assertTrue((boolean)union.isEmpty());
    }

    @Test
    public void testContains() {
        UnionSet union = new UnionSet(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), Set.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        IntStream.range(1, 6).forEach(item -> Assertions.assertTrue((boolean)union.contains((Object)item)));
        Assertions.assertFalse((boolean)union.contains((Object)0));
        Assertions.assertFalse((boolean)union.contains((Object)6));
    }

    @Test
    public void testToArray() {
        UnionSet union = new UnionSet(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), Set.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        Object[] expected = new Object[]{1, 2, 3, 4, 5};
        Object[] actual = union.toArray();
        Arrays.sort(actual);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testToArrayWithArrayParameter() {
        UnionSet union = new UnionSet(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), Set.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        Object[] input = new Integer[5];
        Object[] expected = new Integer[]{1, 2, 3, 4, 5};
        union.toArray(input);
        Arrays.sort(input);
        Assertions.assertArrayEquals((Object[])expected, (Object[])input);
    }

    @Test
    public void testEquals() {
        UnionSet union = new UnionSet(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), Set.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        Assertions.assertEquals(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)), (Object)union);
    }
}

